/******************************************************************************
 * $RCSfile: xwhonick.c,v $   $Revision: 1.4 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

list nicklist;


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*--- nicklist ---------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    Add_nicklist(xwhonick n)
{
	AppendTrue_list(&nicklist, n);
}


/*----------------------------------------------------------------------------*/
xwhonick
    Seek_nicklist(string login)
{
	list l;

	for (l = nicklist; ! Empty_list(l); l = Next_list(l)) {
		xwhonick n = (xwhonick)First_list(l);

		if (strcmp(n->login, login) == 0)
		    return (n);
	}
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Free_nicklist()
{
	Free_list(&nicklist, Free_xwhonick);
}


/*--- xwhonick ---------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhonick
    New_xwhonick()
{
	xwhonick n;

	n = (xwhonick)TrueReAlloc(NULL, 1, sizeof (struct xwhonick));
	n->nick = n->login = NULL;
	n->background = groupbackground;
	n->foreground = groupforeground;
	return (n);
}


/*----------------------------------------------------------------------------*/
xwhonick
    Init_xwhonick(char* nickname)
{
	xwhonick n;

	n = New_xwhonick();
	StrTrueReAlloc(&(n->nick), nickname);
	return (n);
}


/*----------------------------------------------------------------------------*/
void
    AddLogin_xwhonick(xwhonick n,
		      char* login)
{
	StrTrueReAlloc(&(n->login), login);
}


/*----------------------------------------------------------------------------*/
void
    SetColors_xwhonick(xwhonick n,
		       Pixel background,
		       Pixel foreground)
{
	n->background = background;
	n->foreground = foreground;
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhonick(void** n_ref)
{
	xwhonick n = *n_ref;

	if (n != NULL) {
		StrFree(&(n->nick));
		StrFree(&(n->login));
		Free(n_ref);
	}
}
