/******************************************************************************
 * $RCSfile: xwhologin.c,v $   $Revision: 1.12 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static xwhologin
    New_xwhologin();

static int
    CmpLogin_xwhologin(void*, void*);

static void
    Send_xwhologin(conn, xwhologin);

static xwhologin
    Recv_xwhologin(conn);


static void
    Send_xwhottys(conn, list);

static list
    Recv_xwhottys(conn);

static void
    Free_xwhottys(void**);


static xwhotty
    New_xwhotty();

static int
    Cmp_xwhotty(void*, void *);

static void
    Send_xwhotty(conn, xwhotty);

static xwhotty
    Recv_xwhotty(conn);

static void
    Free_xwhotty(void**);


static string
    GetRHost(struct UTmp *, string);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*--- xwhologins -------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhologins
    New_xwhologins()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Add_xwhologins(xwhologins* ll_ref,
		   xwhologin l)
{
	AddTrueSorted_list(ll_ref, l, CmpLogin_xwhologin);
}


/*----------------------------------------------------------------------------*/
xwhologins
    Get_xwhologins(void* servedhost)
{
	xwhodservedhost h = servedhost;
	xwhologins logins = New_xwhologins();
	struct UTmp * utent;
	list ll;

	UTmpName(h->utmpfile);
	while ((utent = GetUTEnt()) != NULL) {
		xwhologin login, l;
		xwhotty tty;

		if (utent->user[0] == '\0'  ||  utent->tty[0] == '\0')
		    continue;   /* ignore entries without user or tty */

		l = New_xwhologin();
		l->login = utent->user;
		login = (xwhologin)SeekSorted_list(logins, l, NULL,
						   CmpLogin_xwhologin);
		if (login == NULL) {
			login = New_xwhologin();

			StrTrueReAlloc(&(login->login), utent->user);
			StrTrueReAlloc(&(login->fullname),
				       GetRealName(utent->user));
			StrTrueReAlloc(&(login->nick), "");

			Add_xwhologins(&logins, login);
		}
		Free((void**)&l);


		tty = New_xwhotty();
		StrTrueReAlloc(&(tty->tty), utent->tty);

		tty->rhost = GetRHost(utent, h->hostname);

		AddTrueSorted_list(&(login->ttys), tty, Cmp_xwhotty);
	}
	EndUTEnt();

	for (ll = (list)logins; ! Empty_list(ll); ll = Next_list(ll)) {
		xwhologin l = ll->data;

		l->islocal = IsLocal_xwhottys(l->ttys, h->localtty);
	}

	return (logins);
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static string
    GetRHost(struct UTmp * utent,
	     string hostname)
{
	string rhost = NULL;

	if (utent->host[0] == '\0')
	    StrTrueReAlloc(&rhost, NULL);
	else {
		StrSplit(&rhost, NULL, utent->host, ".:");
		if (TestHostname(rhost)) {
			StrTrueReAlloc(&rhost, GetHostnameByName(rhost));
			if (strcmp(rhost, hostname) == 0)
			    StrTrueReAlloc(&rhost, NULL);
		}
	}
	return (rhost);
}


/*----------------------------------------------------------------------------*/
xwhologin
    TakeOut_xwhologins(xwhologins* ll)
{
	return ( (xwhologin)TakeOut_list((list*)ll) );
}


/*----------------------------------------------------------------------------*/
int
    Cmp_xwhologins(xwhologins ll1,
		   xwhologins ll2)
{
	list l1 = (list)ll1;
	list l2 = (list)ll2;
	int cmp;

	while (! Empty_list(l1) && ! Empty_list(l2)) {
		cmp = Cmp_xwhologin(First_list(l1), First_list(l2));
		if (cmp != 0)
		    return (cmp);
		l1 = Next_list(l1);
		l2 = Next_list(l2);
	}
	if (Empty_list(l1) && Empty_list(l2))
	    return (0);
	if (Empty_list(l1))
	    return (-1);
	else
	    return (1);
}


/*----------------------------------------------------------------------------*/
void
    Send_xwhologins(conn c,
		    xwhologins ll)
{
	list l;

	for (l = (list)ll; ! Empty_list(l); l = Next_list(l)) {
		ProtocolNext(c);
		Send_xwhologin(c, (xwhologin)First_list(l));
	}
	ProtocolEnd(c);
}


/*----------------------------------------------------------------------------*/
xwhologins
    Recv_xwhologins(conn c)
{
	xwhologins ll = New_xwhologins();

	while (ProtocolHasNext(c))
	    Add_xwhologins(&ll, Recv_xwhologin(c));
	return (ll);
}


/*----------------------------------------------------------------------------*/
void
    InOrder_xwhologins(xwhologins ll,
		       void (*func)(void*))
{
	InOrder_list((list)ll, *func);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhologins(void** l_ref)
{
	Free_list((list*)l_ref, Free_xwhologin);
}


/*--- xwhologin --------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
static xwhologin
    New_xwhologin()
{
	xwhologin l;

	l = (xwhologin)TrueReAlloc(NULL, 1, sizeof (struct xwhologin));
	l->login = l->fullname = l->nick = NULL;
	l->ttys = NULL;
	l->islocal = 0;
	return (l);
}


/*----------------------------------------------------------------------------*/
int
    Cmp_xwhologin(void* login1,
		  void* login2)
{
	xwhologin l1 = (xwhologin)login1;
	xwhologin l2 = (xwhologin)login2;
	int cmp;

	cmp = CmpLogin_xwhologin((void*)l1, (void*)l2);
	if (cmp == 0)
	    return ( Cmp_xwhottys(l1->ttys, l2->ttys) );
	else
	    return (cmp);
}


/*----------------------------------------------------------------------------*/
static int
    CmpLogin_xwhologin(void* l1,
		       void* l2)
{
	return ( strcmp(((xwhologin)l1)->login, ((xwhologin)l2)->login) );
}


/*----------------------------------------------------------------------------*/
int
    IsLocal_xwhologin(xwhologin l)
{
	return (l->islocal);
}


/*----------------------------------------------------------------------------*/
static void
    Send_xwhologin(conn c,
		   xwhologin l)
{
	SendLoginData(c, l->login, l->fullname, l->nick, l->islocal);
	Send_xwhottys(c, l->ttys);
}


/*----------------------------------------------------------------------------*/
static xwhologin
    Recv_xwhologin(conn c)
{
	xwhologin l = New_xwhologin();

	RecvLoginData(c, &(l->login), &(l->fullname), &(l->nick),
		      &(l->islocal));
	l->ttys = Recv_xwhottys(c);
	return (l);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhologin(void** l_ref)
{
	xwhologin l = *l_ref;

	if (l != NULL) {
		StrFree(&(l->login));
		StrFree(&(l->fullname));
		StrFree(&(l->nick));
		Free_xwhottys((void*)l->ttys);
		Free(l_ref);
	}
}


/*--- xwhottys ---------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhottys
    New_xwhottys()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Add_xwhottys(xwhottys* tl_ref,
		 xwhotty t)
{
	AddTrueSorted_list((list*)tl_ref, t, Cmp_xwhotty);
}


/*----------------------------------------------------------------------------*/
int
    Cmp_xwhottys(xwhottys tl1,
		 xwhottys tl2)
{
	list l1 = (list)tl1;
	list l2 = (list)tl2;
	int cmp;

	while (! Empty_list(l1) && ! Empty_list(l2)) {
		cmp = Cmp_xwhotty(First_list(l1), First_list(l2));
		if (cmp != 0)
		    return (cmp);
		l1 = Next_list(l1);
		l2 = Next_list(l2);
	}
	if (Empty_list(l1) && Empty_list(l2))
	    return (0);
	if (Empty_list(l1))
	    return (-1);
	else
	    return (1);
}


/*----------------------------------------------------------------------------*/
static void
    Send_xwhottys(conn c,
		  xwhottys ttys)
{
	list l;

	for (l = (list)ttys; ! Empty_list(l); l = Next_list(l)) {
		ProtocolNext(c);
		Send_xwhotty(c, (xwhotty)First_list(l));
	}
	ProtocolEnd(c);
}


/*----------------------------------------------------------------------------*/
static xwhottys
    Recv_xwhottys(conn c)
{
	xwhottys tl = New_xwhottys();

	while (ProtocolHasNext(c))
	    Add_xwhottys(&tl, Recv_xwhotty(c));
	return (tl);
}


/*----------------------------------------------------------------------------*/
int
    IsLocal_xwhottys(xwhottys tl,
		     string localtty)
{
	list l;

	for (l = (list)tl; ! Empty_list(l); l = Next_list(l)) {
		xwhotty t = (xwhotty)First_list(l);

#ifdef _NO_SPECIAL_DEVICE
		if (t->rhost[0] != '\0')
		    return (0);
#else
		if (strcmp(t->tty, localtty) == 0)
		    return (1);
#endif
	}
#ifdef _NO_SPECIAL_DEVICE
	return (1);
#else
	return (0);
#endif
}


/*----------------------------------------------------------------------------*/
void
    InOrder_xwhottys(xwhottys tl,
		     void (*func)(void*))
{
	InOrder_list((list)tl, *func);
}


/*----------------------------------------------------------------------------*/
static void
    Free_xwhottys(void** tl_ref)
{
	Free_list((list*)tl_ref, Free_xwhotty);
}


/*--- xwhotty ----------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
static xwhotty
    New_xwhotty()
{
	xwhotty t;

	t = (xwhotty)TrueReAlloc(NULL, 1, sizeof (struct xwhotty));
	t->tty = t->rhost = NULL;
	return (t);
}


/*----------------------------------------------------------------------------*/
static int
    Cmp_xwhotty(void* t1,
		void* t2)
{
	return ( strcmp(((xwhotty)t1)->tty, ((xwhotty)t2)->tty) );
}


/*----------------------------------------------------------------------------*/
static void
    Send_xwhotty(conn c,
		 xwhotty t)
{
	SendTtyData(c, t->tty, t->rhost);
}


/*----------------------------------------------------------------------------*/
static xwhotty
    Recv_xwhotty(conn c)
{
	xwhotty t = New_xwhotty();

	RecvTtyData(c, &(t->tty), &(t->rhost));
	return (t);
}


/*----------------------------------------------------------------------------*/
static void
    Free_xwhotty(void** t_ref)
{
	xwhotty t = *t_ref;

	StrFree(&(t->tty));
	StrFree(&(t->rhost));
	Free(t_ref);
}
