/******************************************************************************
 * $RCSfile: xwhodclient.c,v $   $Revision: 1.9 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

extern const int verboseflag;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static xwhodclient
    New_xwhodclient();


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*--- xwhodclients -----------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhodclients
    New_xwhodclients()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Add_xwhodclients(xwhodclients* cl_ref,
		     xwhodclient c)
{
	if (c != NULL) {
		Del_xwhodclients(cl_ref, c);
		AddTrueSorted_list((list*)cl_ref, (void*)c, Cmp_xwhodclient);
	}
}


/*----------------------------------------------------------------------------*/
void
    Del_xwhodclients(xwhodclients* cl_ref,
		     xwhodclient c)
{
	xwhodclient old;

	old = (xwhodclient)DelSorted_list((list*)cl_ref, (void*)c, NULL,
					  Cmp_xwhodclient);
	if (old != NULL)
	    Free_xwhodclient((void**)&old);
}


/*----------------------------------------------------------------------------*/
void
    Serve_xwhodclients(xwhodclients cl,
		       xwhodservedhost host)
{
	list l = (list)cl;

	for (l = (list)cl; ! Empty_list(l); l = Next_list(l))
	    Serve_xwhodclient((xwhodclient)First_list(l), host);
}


/*----------------------------------------------------------------------------*/
void
    TimeOut_xwhodclients(xwhodclients* cl_ref)
{
	list l = (list)*cl_ref;

	while (! Empty_list(l)) {
		xwhodclient c = (xwhodclient)First_list(l);
		time_t now;

		l = Next_list(l);
		time(&now);
		if (c->timeout < now) {
			conn clientinput;

			if (verboseflag)
			    printf("removing client on %s:%d ...\n",
				   c->hostname, c->port);
			clientinput = Connect_conn(NULL, c->hostname, c->port,
						   0, CONN_DATAGRAM);
			if (clientinput == NULL)
			    Warning("can't connect to client %s:%d",
				    c->hostname, c->port);
			SendProtocol(NULL, c->protocol_version);
			SendTimeOut(NULL);
			SendBuffer_conn(clientinput);
			Close_conn(&clientinput);
			Del_xwhodclients(cl_ref, c);
		}
	}
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhodclients(void** cl_ref)
{
	Free_list((list*)cl_ref, Free_xwhodclient);
}


/*--- xwhodclient ------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
static xwhodclient
New_xwhodclient()
{
	xwhodclient c;

        c = (xwhodclient)TrueReAlloc(NULL, 1, sizeof (struct xwhodclient));
        c->hostname = NULL;
	c->port = c->protocol_version = -1;
	time(&(c->timeout));
        return (c);
}


/*----------------------------------------------------------------------------*/
xwhodclient
    Init_xwhodclient(conn streamconn,
		     xwhodservedhosts hosts)
{
	xwhodclient c = New_xwhodclient();

	if (SettleProtocol_server(streamconn)  <  0  ||
	    RecvServerInput(streamconn, &(c->hostname), &(c->port),
			    &(c->protocol_version), hosts)  <  0) {
		Warning("can't communicate with client");
		Free_xwhodclient((void**)&c);
	}
	else {
		time(&(c->timeout));
		c->timeout += XWHOD_CLIENT_TIMEOUT;
	}
	return (c);
}


/*----------------------------------------------------------------------------*/
int
    Cmp_xwhodclient(void* client1,
		    void* client2)
{
	xwhodclient c1 = (xwhodclient)client1;
	xwhodclient c2 = (xwhodclient)client2;
	int cmp;

	cmp = strcmp(c1->hostname, c2->hostname);
	if (cmp == 0)
	    return (c1->port - c2->port);
	return (cmp);
}


/*----------------------------------------------------------------------------*/
void
    Serve_xwhodclient(xwhodclient c,
		      xwhodservedhost host)
{
	conn clientinput;

	if (verboseflag)
	    printf("sending update to client on %s:%d\n",
		   c->hostname, c->port);
	clientinput = Connect_conn(NULL, c->hostname, c->port,
				   0, CONN_DATAGRAM);
	if (clientinput == NULL) {
		Warning("can't connect to client %s:%d", c->hostname, c->port);
		return;
	}
	SendProtocol(NULL, c->protocol_version);
	SendUpdateData(NULL, host);
	if (SendBuffer_conn(clientinput) < 0)
	    Warning("can't send update to client %s:%d", c->hostname, c->port);
	Close_conn(&clientinput);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhodclient(void** c_ref)
{
	xwhodclient c = (xwhodclient)*c_ref;

	if (c != NULL) {
		StrFree(&(c->hostname));
		Free(c_ref);
	}
}
