/******************************************************************************
 * $RCSfile: ReadConfig.c,v $   $Revision: 1.10 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "Parser.h"


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static xwhodconfig conf = NULL;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static xwhodaemons
    ReadDomain();

static xwhodaemons
    ReadGateways();

static xwhodservedhost
    ReadSubhost();


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
int
    ReadConfig(string conffile)
{
	extern FILE* yyin;
	int isready;

	EndConfig();
	conf = New_xwhodconfig();

	ylineno = 1;
	StrTrueReAlloc(&yfile, conffile);
	if ((yyin = fopen(yfile,"r"))  ==  NULL) {
		Warning("XWho-configuration-file \"%s\" not found", yfile);
		return (-1);
	}

	isready = 0;
	while (!isready) {
		switch (ParseConfig()) {
		    case DOMAIN:
			if (conf->domain != NULL) {
				ywarn("THIS_DOMAIN redefined");
				Free_xwhodaemons((void**)&(conf->domain));
			}
			conf->domain = ReadDomain();
			break;
		    case GATEWAYS:
			if (conf->gateways != NULL) {
				ywarn("GATEWAYS redefined");
				Free_xwhodaemons((void**)&(conf->gateways));
			}
			conf->gateways = ReadGateways();
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			yerror("illegal keyword");
		}
	}

	fclose(yyin);
	return (0);
}


/*----------------------------------------------------------------------------*/
static xwhodaemons
    ReadDomain()
{
	xwhodaemons domain = New_xwhodaemons();
	xwhodaemon curdaemon = NULL;
	int isready;

	if (ParseDomain() != OPEN)
	    yerror("{ not found");

	isready = 0;
	while (!isready) {
		switch (ParseDomain()) {
		    case HOST:
			if (curdaemon != NULL) {
				Add_xwhodaemons(&domain, curdaemon);
				curdaemon = NULL;
			}
			if (TestHostname(parsetext)) {
				xwhoseekserver s;

				curdaemon = Init_xwhodaemon(parsetext);
				s = New_xwhoseekserver();
				s->subhost = curdaemon->hostname;
				s->daemon = curdaemon;
				AddTrue_tree(&(conf->seektree), s,
					     Cmp_xwhoseekserver);
			}
			else
			    ywarn("illegal hostname in server-configuration");
			break;
		    case PORT:
			if (curdaemon != NULL)
			    SetPort_xwhodaemon(curdaemon, atoi(parsetext));
			break;
		    case SUBHOST:
			{
				xwhodservedhost subhost = ReadSubhost();

				if (curdaemon != NULL && subhost != NULL) {
					xwhoseekserver s;

					s = New_xwhoseekserver();
					s->subhost = subhost->hostname;
					s->daemon = curdaemon;
					AddTrue_tree(&(conf->seektree), s,
						     Cmp_xwhoseekserver);

					AddSubhost_xwhodaemon(curdaemon,
							      subhost);
				}
			}
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			yerror("illegal host-configuration in THIS_DOMAIN");
		}
	}
	if (curdaemon != NULL)
	    Add_xwhodaemons(&domain, curdaemon);
	return (domain);
}


/*----------------------------------------------------------------------------*/
static xwhodservedhost
    ReadSubhost()
{
	xwhodservedhost subhost = NULL;
	int status = 0;
	int isready;

	if (ParseSubhost() != HOST)
	    yerror("hostname expected");
	if (TestHostname(parsetext))
	    subhost = Init_xwhodservedhost(parsetext);
	else {
		ywarn("illegal hostname in subhost-configuration");
		return (NULL);
	}

	isready = 0;
	while (! isready) {
		switch (ParseSubhost()) {
		    case HOST:
		    case FILENAME:
			switch (status) {
			    case 0:
				SetUtmpFile_xwhodservedhost(subhost, parsetext);
				status++;
				break;
			    case 1:
				SetLocalTty_xwhodservedhost(subhost, parsetext);
				status++;
				break;
			    default:
				yerror("too many arguments in subhost-configuration");
			}
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			yerror("error in subhost-configuration");
		}
	}

	return (subhost);
}


/*----------------------------------------------------------------------------*/
/* NOT YET IMPLEMENTED */
static xwhodaemons
    ReadGateways()
{
	xwhodaemons gateways = NULL;
	int isready;

	if (ParseGateways() != OPEN)
	    yerror("{ not found");

	isready = 0;
	while (!isready) {
		switch (ParseGateways()) {
		    case HOST:
			break;
		    case PORT:
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			yerror("illegal host-configuration in GATEWAYS");
		}
	}

	return (gateways);
}


/*----------------------------------------------------------------------------*/
xwhodaemon
    GetConfigServer(string subhost)
{
	if (conf == NULL)
	    ReadConfig(CONFIGFILE);

	return (SeekServer_xwhodconfig(conf, subhost));
}


/*----------------------------------------------------------------------------*/
void
    EndConfig()
{
	Free_xwhodconfig((void**)&conf);
}
