/******************************************************************************
 * $RCSfile: Popup.c,v $   $Revision: 1.9 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static struct {
	Widget shell;
	Widget dialog;
	string hostname;
} lastpopup = {NULL, NULL, NULL};
static string text = NULL;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    CreatePopup(Widget, xwhowidget);

static void
    CreatePopupText(xwhowidget);

static void
    CreatePopupTextTty(void*);

static void
    CreatePopupTextRlogin(void*);

static void
    CreatePopupTextRloginTty(void*);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    UserClick(Widget parent,
	      xwhowidget w)
{
	DestroyLastPopup();
	CreatePopup((Widget)parent, (xwhowidget)w);
}


/*----------------------------------------------------------------------------*/
static void
    CreatePopup(Widget parent,
		xwhowidget w)
{
	Widget popupshell;
	Widget popupdialog;
	Position x, y;
	Dimension parentwidth, parentheight, parentborder;


	XtVaGetValues(parent,
		      XtNwidth, &parentwidth, XtNheight, &parentheight,
		      XtNborderWidth, &parentborder, NULL);
	parentwidth += 2 * parentborder;
	parentheight += 2 * parentborder;
	XtTranslateCoords(parent,
			  (Position)parentwidth, (Position)parentheight,
			  &x, &y);


	popupshell =
	    XtVaCreatePopupShell("prompt", transientShellWidgetClass, toplevel,
				 XtNx, x, XtNy, y,
				 XtNallowShellResize, 1, NULL);
	popupdialog = XtVaCreateManagedWidget("xwhoPopup", dialogWidgetClass,
					      popupshell, NULL);
	lastpopup.shell = popupshell;
	lastpopup.dialog = popupdialog;
	StrTrueReAlloc(&(lastpopup.hostname), w->host.name);


	CreatePopupText(w);
	Create_popupbuttons(popupdialog, w);
	XawDialogAddButton(popupdialog, "dismiss",
			   (XtCallbackProc)DestroyLastPopup, NULL);

	XtRealizeWidget(popupshell);


	{
		Display* display = XtDisplay(toplevel);
		int screen = DefaultScreen(display);
		Dimension rootwidth = XDisplayWidth(display, screen);
		Dimension rootheight = XDisplayHeight(display, screen);
		Dimension width, height, border;

		XtVaGetValues(popupshell, XtNwidth, &width, XtNheight, &height,
			      XtNborderWidth, &border, NULL);
		width += 2 * border;
		height += 2 * border;
		if (x + width > rootwidth) {
			x -= width + parentwidth;
			if (x < 0)
			    x = rootwidth - width;
		}
		if (y + height > rootheight) {
			y -= height + parentheight;
			if (y < 0)
			    y = rootheight - height;
		}
		XtVaSetValues(popupshell, XtNx, x, XtNy, y, NULL);
	}


	XtPopup(popupshell, XtGrabNone);
}


/*----------------------------------------------------------------------------*/
static void
    CreatePopupText(xwhowidget w)
{
	string entry;
	char str[200];

	entry = w->host.name;
	if (entry != NULL) {
		sprintf(str, "%.150s\n\n", entry);
		StrTrueCat(&text, str);
	}

	if (w->host.login != NULL) {
		entry = w->host.login->login;
		if (entry != NULL  &&  entry[0] != '\0') {
			sprintf(str, "Login:             %.150s\n", entry);
			StrTrueCat(&text, str);
		}
		entry = w->host.login->nick;
		if (entry != NULL  &&  entry[0] != '\0') {
			sprintf(str, "Nickname:          %.150s\n", entry);
			StrTrueCat(&text, str);
		}
		entry = w->host.login->fullname;
		if (entry != NULL  &&  entry[0] != '\0') {
			sprintf(str, "Name,Office,Phone: %.150s\n", entry);
			StrTrueCat(&text, str);
		}
		StrTrueCat(&text, "Ttys:");
		InOrder_xwhottys(w->host.login->ttys, CreatePopupTextTty);
		StrTrueCat(&text, "\n\n");
	}

	if (w->host.rlogins != NULL) {
		StrTrueCat(&text, "rlogins:\n");
		InOrder_xwhologins(w->host.rlogins, CreatePopupTextRlogin);
		StrTrueCat(&text, "\n");
	}

	XtVaSetValues(lastpopup.dialog, XtNlabel, text, NULL);
	StrFree(&text);
}


/*----------------------------------------------------------------------------*/
static void
    CreatePopupTextTty(void* tty)
{
	xwhotty t = (xwhotty)tty;

	StrTrueCat(&text, " ");
	StrTrueCat(&text, t->tty);
	if (t->rhost[0] != '\0') {
		StrTrueCat(&text, ":");
		if (strlen(t->rhost) > 20)
		    t->rhost[20] = '\0';
		StrTrueCat(&text, t->rhost);
	}
}

/*----------------------------------------------------------------------------*/
static void
    CreatePopupTextRlogin(void* rlogin)
{
	xwhologin l = (xwhologin)rlogin;
	char str[200];

	sprintf(str, "   %-8.8s %-8.8s %.150s",
		l->login, l->nick, l->fullname);
	StrTrueCat(&text, str);
	StrTrueCat(&text, "\n");
	InOrder_xwhottys(l->ttys, CreatePopupTextRloginTty);
}


/*----------------------------------------------------------------------------*/
static void
    CreatePopupTextRloginTty(void* tty)
{
	xwhotty t = (xwhotty)tty;

	StrTrueCat(&text, "            ");
	StrTrueCat(&text, t->tty);
	if (t->rhost[0] != '\0') {
		StrTrueCat(&text, ":");
		StrTrueCat(&text, t->rhost);
	}
	StrTrueCat(&text, "\n");
}


/*----------------------------------------------------------------------------*/
void
    UpdateLastPopup(xwhowidget w)
{
	if (lastpopup.shell != NULL  &&
	    strcmp(lastpopup.hostname, w->host.name) == 0) {
		Display* display = XtDisplay(toplevel);
		int screen = DefaultScreen(display);
		Dimension rootwidth = XDisplayWidth(display, screen);
		Dimension rootheight = XDisplayHeight(display, screen);
		Position x, y;
		Dimension width, height, border;

		CreatePopupText(w);

		XtVaGetValues(lastpopup.shell, XtNx, &x, XtNy, &y,
			      XtNwidth, &width, XtNheight, &height,
			      XtNborderWidth, &border, NULL);
		width += 2 * border;
		height += 2 * border;
		if (x + width > rootwidth)
		    if ((x = rootwidth - width) < 0)
			x = 0;
		if (y + height > rootheight)
		    if ((y = rootheight - height) < 0)
			y = 0;
		XtVaSetValues(lastpopup.shell, XtNx, x, XtNy, y, NULL);
	}
}


/*----------------------------------------------------------------------------*/
void
    DestroyLastPopup()
{
	if (lastpopup.shell != NULL) {
		XtDestroyWidget(lastpopup.shell);
		lastpopup.shell = NULL;
		StrFree(&(lastpopup.hostname));
	}
}
