/******************************************************************************
 * $RCSfile: time.c,v $   $Revision: 1.2 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/


#include "time.h"


/*----------------------------------------------------------------------------*/
time_t
DatumToCal(
   char *datum
)
{
	struct tm t;
	int day, month, year;

	t.tm_sec = t.tm_min = t.tm_hour = 0;
	sscanf(datum, "%d.%d.%d", &day, &month, &year);
	if (day < 1 || day > 31)
		return (-1);
	if (month < 1 || month > 12)
		return (-1);
	if (year > 1969)
		year -= 1900;
	if (year < 1 && year > 99)
		return (-1);
	t.tm_mday = day;
	t.tm_mon = month - 1;
	t.tm_year = year;
	return (mktime(&t));
}
