/******************************************************************************
 * $RCSfile: math.c,v $   $Revision: 1.9 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/


#include <math.h>
#include "misc/math.h"

#if defined(sun) && ! defined(SVR4)
#define RAND_MAX (exp2(31) - 1)
#endif

static double
    RInt(double);


/*----------------------------------------------------------------------------*/
double
    Percent(long value,
	    long base)
{
	if (base != 0)
	    return (value * 100 / base);
	else
	    return (100);
}


/*----------------------------------------------------------------------------*/
double
    RandInterval(double min,
		 double max)
{
	return (((max-min) * rand()) / RAND_MAX  +  min);
}


/*----------------------------------------------------------------------------*/
int
    RandIntInterval(int min,
		    int max)
{
	return ( RInt(RandInterval(min, max)) );
}


/*----------------------------------------------------------------------------*/
static double
    RInt(double x)
{
#if defined(hpux) || defined(aix)
	return ( floor(x + 0.5) );
#else
	return (rint(x));
#endif
}
