/******************************************************************************
 * $RCSfile: ipc.h,v $   $Revision: 1.9 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#ifndef _MISC_IPC_H
#define _MISC_IPC_H


#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>		/* AF_UNIX */
#include <netinet/in.h>		/* AF_INET */

#include <misc/error.h>
#include <misc/mem.h>
#include <misc/str.h>
#include <misc/sys.h>


#define IPC_UNIXSOCKTEMPL  "/tmp/uxsock.XXXXXX"
#define IPC_LISTENQUEUELEN 5
#define IPC_BUFLEN         9216


/*----------------------------------------------------------------------------*
 * typedefs
 *----------------------------------------------------------------------------*/

#define CONN_STREAM      1
#define CONN_DATAGRAM    2
#define CONN_NONBLOCKING 4
#define CONN_ISLISTENER  8
#define CONN_ISREAD      16
#define CONN_ISWRITE     32
#define CONN_INETD       64

struct conn {
	unsigned flags;
	int addrfam;                    /* AF_UNIX, AF_INET */
	union {
		struct sockaddr_un un;
		struct sockaddr_in in;
	} to;
	union {
		struct sockaddr_un un;
		struct sockaddr_in in;
	} from;
	int addrlen;
	int port;
	int sock;
};
typedef struct conn * conn;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern conn  /* opened listen-connection  or  NULL */
    Open_conn(char*,    /* hostname  or  NULL */
	      int,      /* minimum portnumber */
	      int,      /* maximum portnumber */
	      unsigned  /* flags */
	      );  /* open a listen-connection to the host using the lowest
		   * free portnumber of the specified range
		   * if the hostname is NULL the listen-connection accepts
		   * connections from any host */


extern conn
    Accept_conn(conn,  /* listen-connection returned by Open_conn() */
		long   /* seconds to wait (-1 == infinite) */
		);


extern conn
    Connect_conn(char*,    /* filename of a UNIX-socket */
		 char*,    /* hostname of a INET-socket */
		 int,      /* port of a INET-socket  or  -1 */
		 long,     /* seconds to wait (-1 == infinite) */
		 unsigned  /* flags */
		 );

extern int
    SendMesg_conn(conn,   /* open connection */
		  void*,  /* buffer */
		  size_t  /* length of the buffer */
		  );

extern int
    SendBuffer_conn(conn);

extern void*  /* pointer to the message (static buffer)  or  NULL */
    RecvMesg_conn(conn,  /* open connection */
		  int*   /* length of the message */
		  );

extern int
    RecvBuffer_conn(conn);

extern int
    SendNumber_conn(conn,   /* open connection */
		    void*,  /* buffer for the number */
		    size_t  /* size of the number */
		    );

extern int
    RecvNumber_conn(conn,   /* open connection */
		    void*,  /* buffer for the number */
		    size_t  /* size of the number */
		    );

extern void
    SendTrueINT_conn(conn, int);

extern int
    SendINT_conn(conn, int);

extern int
    RecvTrueINT_conn(conn);

extern int
    RecvINT_conn(conn);

extern void
    SendTrueString_conn(conn, char*);

extern int
    SendString_conn(conn, char*);

extern char*  /* (static buffer) */
    RecvTrueString_conn(conn);

extern char*  /* (static buffer) */
    RecvString_conn(conn);

extern void
    Close_conn(conn*  /* connection to close */
	       );

extern int
    Test_conn(int,
	      int,  /* CONN_ISREAD or CONN_ISWRITE */
	      long  /* seconds to wait (-1 == infinite) */
	      );


#endif	 /* _MISC_IPC_H */
