/******************************************************************************
 * $RCSfile: file.c,v $   $Revision: 1.2 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#include "file.h"
#include <fcntl.h>


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
FILE*
    fTrueOpen(char* file,
	      char* access)
{
	FILE* stream;

	if ((stream = fopen(file, access)) == NULL)
	    Error(ERROR, "can't open file \"%s\"", file);
	return (stream);
}


/*----------------------------------------------------------------------------*/
void
    fSetFlags(int fd,
	      int flags)
{
	int val;

	if ((val = fcntl(fd, F_GETFL, 0)) < 0) {
		perror("fcntl()");
		Error(-1, "can't get flags");
	}
	val |= flags;
	if (fcntl(fd, F_SETFL, val) < 0) {
		perror("fcntl()");
		Error(-1, "can't set flags");
	}
}


/*----------------------------------------------------------------------------*/
void
    fClearFlags(int fd,
		int flags)
{
	int val;

	if ((val = fcntl(fd, F_GETFL, 0)) < 0) {
		perror("fcntl()");
		Error(-1, "can't get flags");
	}
	val &= ~flags;
	if (fcntl(fd, F_SETFL, val) < 0) {
		perror("fcntl()");
		Error(-1, "can't set flags");
	}
}


/*----------------------------------------------------------------------------*/
char*
    fName(char* fullname)
{
	static string namebuf = NULL;
	register char* s;
	char* name;

	name = fullname;
	for (s = fullname; *s != '\0'; s++) {
		if (
#ifdef DOS
		    *s == '\\' || *s == ':'
#else
		    *s == '/'
#endif
		    )
		    name = s + 1;
	}
	StrTrueReAlloc(&namebuf, name);
	return ((char *)namebuf);
}
