/******************************************************************************
 * $RCSfile: error.c,v $   $Revision: 1.6 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#include "error.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

FILE* errout = stderr;
FILE* debugout = stderr;
char* programname = "Unknown";
int debugflag = 0;


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static char msgbuf[1000];  /* prevent messages to be longer than this! */


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    MsgToStream(FILE*,   /* output stream */
		char*,   /* format of message */
		va_list  /* argument list */
		);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    Error(int exitcode,
	  char* msgfmt,
	  ...)
{
	va_list arglist;

	if (errout != NULL) {
		sprintf(msgbuf, "%s: ", programname);
#ifdef sun
		va_start(arglist);
#else
		va_start(arglist, msgfmt);
#endif
		MsgToStream(errout, msgfmt, arglist);
		va_end(arglist);
	}
	exit(exitcode);
}


/*----------------------------------------------------------------------------*/
void
    Warning(char* msgfmt,
	    ...)
{
	va_list arglist;

	if (errout != NULL) {
		sprintf(msgbuf, "%s: warning: ", programname);
#ifdef sun
		va_start(arglist);
#else
		va_start(arglist, msgfmt);
#endif
		MsgToStream(errout, msgfmt, arglist);
		va_end(arglist);
	}
}


/*----------------------------------------------------------------------------*/
void
    DebugMsg(char* debugfile,
	     char* fkt,
	     char *msgfmt,
	     ...)
{
	if (debugflag) {
		FILE *stream = NULL;
		va_list arglist;

		if (debugfile != NULL)
			stream = fopen(debugfile, "a");
		if (stream == NULL)
			stream = debugout;
		if (stream != NULL) {
			sprintf(msgbuf, "[%s-debug] %s(): ", programname, fkt);
#ifdef sun
			va_start(arglist);
#else
			va_start(arglist, msgfmt);
#endif
			MsgToStream(stream, msgfmt, arglist);
			va_end(arglist);
			if (stream != debugout)
			    fclose(stream);
		}
	}
}


/*----------------------------------------------------------------------------*/
void
    MsgToFile(char* filename,
	      char* msgfmt,
	      ...)
{
	FILE* stream;

	if ((stream = fopen(filename, "a")) != NULL) {
		va_list arglist;
		time_t ti;

#ifdef sun
		va_start(arglist);
#else
		va_start(arglist, msgfmt);
#endif
		vfprintf(stream, msgfmt, arglist);
		va_end(arglist);
		time(&ti);
		fprintf(stream, "\tat %s", ctime(&ti));
		fclose(stream);
	}
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void
    MsgToStream(FILE* stream,
		char* msgfmt,
		va_list arglist)
{
	vsprintf(msgbuf + strlen(msgbuf), msgfmt, arglist);
	strcat(msgbuf, "\n");
	fflush(stream);
	fputs(msgbuf, stream);
#if defined(sun) || defined(aix)
	fflush(stream);
#else
	fflush(NULL);  /* flushes all output streams */
#endif
}
