/* xtea - distribute beverages and other resources over the network
 *
 * Copyright (c) 1994 Henning Spruth (spruth@regent.e-technik.tu-muenchen.de)
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <stdio.h>

#include "config.h"
#include "alloc.h"

/* The list of commodities used. Must be less than MAX_RESOURCES! */
char *xtea_resources[]=
{
  "tea",
  "coffee",
  "cappuchino",
  "beer",
  "jellybeans",
  "champagne",
  "espresso",
  "cake",
  "wine",
  "lunch",
  "hamburger"
};


/* ******************************** resource_count() ************************
 *
 * Return the number of different commodities.
 *
*/
int resource_count()
{
  int n;
  n=sizeof(xtea_resources)/sizeof(char *);
  if(n>MAX_RESOURCES)
  {
    fprintf(stderr,"Fatal: too many resources specified\n");
    fatal_error(3);
  }
  return n;
}
