.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "21-Jun-98 (2.23)" "X Version 11"
.SH NAME
xscreensaver-command - control a running xscreensaver process
.SH SYNOPSIS
.B xscreensaver-command
[\-help] \
[\-demo] \
[\-activate] \
[\-deactivate] \
[\-cycle] \
[\-next] \
[\-prev] \
[\-exit] \
[\-restart] \
[\-lock] \
[\-version] \
[\-time]
.SH DESCRIPTION
The \fIxscreensaver\-command\fP program controls a running \fIxscreensaver\fP
process by sending it client-messages.

.BR xscreensaver (1)
has a client-server model: the xscreensaver process is a
daemon that runs in the background; it is controlled by the 
foreground \fIxscreensaver-command\fP program.
.SH OPTIONS
.I xscreensaver-command
accepts the following command-line options:
.TP 8
.B \-help
Prints a brief summary of command-line options.
.TP 8
.B \-demo
Cause the screensaver to enter its interactive demo mode, in which one
can experiment with the various graphics hacks available.  See
.BR xscreensaver (1)
for details.
.TP 8
.B \-activate
Tell xscreensaver to turn on immediately (that is, blank the screen, as if
the user had been idle for long enough.)  The screensaver will deactivate as
soon as there is any user activity, as usual.

It is useful to run this from a menu; you may wish to run it as
.EX
sleep 5 ; xscreensaver-command -activate
.EE
to be sure that you have time to remove your hand from the mouse before
the screensaver comes on.  (Because if you jiggle the mouse, xscreensaver
will notice, and deactivate.)
.TP 8
.B \-deactivate
If the screensaver is active (the screen is blanked), this command will
deactivate it just as if there had been keyboard or mouse activity.  
If locking is enabled, then the screensaver will prompt for a password
as usual.
.TP 8
.B \-cycle
If the screensaver is active (the screen is blanked), then stop the current
graphics demo and run a new one (chosen randomly.)
.TP 8
.B \-next
This is like either \fI\-activate\fP or \fI\-cycle\fP, depending on which is
more appropriate, except that the graphics hack that will be run is the next
one in the list, instead of a randomly-chosen one.  In other words, 
repeatedly executing -next will cause the xscreensaver process to invoke each
graphics demo sequentially.  (Though using the \fI\-demo\fP option is probably
an easier way to accomplish that.)
.TP 8
.B \-prev
This is like \fI\-next\fP, but cycles in the other direction.
.TP 8
.B \-exit
Causes the xscreensaver process to exit gracefully.  This is roughly the same
as killing the process with
.BR kill (1),
but it is easier, since you don't need to first figure out the pid.  

.B Warning:
never use \fIkill -9\fP with \fIxscreensaver\fP while the screensaver is
active.  If you are using a virtual root window manager, that can leave
things in an inconsistent state, and you may need to restart your window
manager to repair the damage.
.TP 8
.B \-restart
Causes the screensaver process to exit and then restart with the same command
line arguments as last time.  Do this after you've changed the resource
database, to cause xscreensaver to notice the changes.

If the screensaver is run from \fIxdm(1)\fP (that is, it is already running
before you log in) then you may want to issue the \fI\-restart\fP command from
one of your startup scripts, so that the screensaver gets your resource
settings instead of the default ones.
.TP 8
.B \-lock
Tells the running xscreensaver process to lock the screen immediately.  
This is like \fI\-activate\fP, but forces locking as well, even if locking
is not the default (that is, even if xscreensaver's \fIlock\fP resource is
false, and even if the \fIlockTimeout\fP resource is non-zero.)
.TP 8
.B \-version
Prints the version of xscreensaver that is currently running on the display:
that is, the actual version number of the running xscreensaver background 
process, rather than the version number of xscreensaver-command.  (To see
the version number of \fIxscreensaver-command\fP itself, use 
the \fI\-help\fP option.)
.TP 8
.B \-time
Prints the time at which the screensaver last activated or 
deactivated (roughly, how long the user has been idle or non-idle: but 
not quite, since it only tells you when the screen became blanked or
un-blanked.)
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the host and display number of the screen whose saver is
to be manipulated.
.TP 8
.B PATH
to find the executable to restart (for the \fI\-restart\fP command).  
Note that this variable is consulted in the environment of 
the \fIxscreensaver\fP process, not the \fIxscreensaver-command\fP process.
.SH UPGRADES
The latest version of
.BR xscreensaver (1)
and \fIxscreensaver\-command\fP can always be found at 
http://people.netscape.com/jwz/xscreensaver/
.SH "SEE ALSO"
.BR X (1),
.BR xscreensaver (1)
.SH BUGS
Some diagnostics are reported on the stderr of the \fIxscreensaver\fP
process, not this process, so the caller of \fIxscreensaver-command\fP
may not see the error messages.
.SH COPYRIGHT
Copyright \(co 1992, 1993, 1997, 1998
by Jamie Zawinski.  Permission to use, copy, modify, distribute, and sell
this software and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of this
software for any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Jamie Zawinski <jwz@netscape.com>, 13-aug-92.

Please let me know if you find any bugs or make any improvements.
