/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.2 $ $Date: 1997/04/06 19:05:38 $
*/
#ifndef XQUOTEP_H
#define XQUOTEP_H

/* Application resources */
typedef struct {
  XmFontList font_list;
  Boolean    help;
  Boolean    install;
  Boolean    tape;
  char       *restore;
}  AppData;

static XtResource resources [] = {
  {
     XmNfontList,
     XmCFontList,
     XmRFontList,
     sizeof( XmFontList ),
     XtOffsetOf ( AppData, font_list),
     XtRString,
     XmNdefaultFontList
  },
  {
     "help", 
     "Help", 
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf ( AppData, help),
     XmRImmediate, 
     False 
  },
  {
     "install", 
     "Install", 
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf ( AppData, install),
     XmRImmediate, 
     False 
  },
  {
     "tape", 
     "Tape", 
     XmRBoolean,
     sizeof(Boolean),
     XtOffsetOf ( AppData, tape),
     XmRImmediate, 
     False 
  },
  {
     "restore", 
     "Restore", 
     XmRString,
     sizeof(char *),
     XtOffsetOf ( AppData, restore),
     XmRImmediate, 
     NULL 
  },
};

/* Application defined options */
static XrmOptionDescRec options [] = {
  { "-help", "help", XrmoptionNoArg, "True" },
  { "-install", "install", XrmoptionNoArg, "True" },
  { "-tape", "tape", XrmoptionNoArg, "True" },
  { "-restore", "restore", XrmoptionSepArg, NULL }
};
#endif
