/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.4 $ $Date: 1997/05/17 14:46:33 $
*/

#include <Xm/XmAll.h>
#include "xutil.h"

extern Widget Toplevel;
/* Select table or tape view */
extern Widget Tape, Scroll;
extern Widget Heading;

static void viewWindowSet ( int which )
{
  static Dimension twidth = 0, theight;
  static Dimension swidth = 0, sheight;

  AllowShellResize (Toplevel, ALLOW);

  if ( which == 1) {
    /* -tape, there may be no Scroll, else clause should not fire */
    if (Scroll) {
      XtVaGetValues ( Toplevel, XmNheight, &sheight, XmNwidth, &swidth, NULL);
      XtManageChild ( Tape );
      XtUnmanageChild ( Heading );
      XtUnmanageChild ( Scroll );
    }
    if (twidth)
      XtVaSetValues ( Toplevel, XmNheight, theight, XmNwidth, twidth, NULL);
  } else {
    XtVaGetValues ( Toplevel, XmNheight, &theight, XmNwidth, &twidth, NULL);
    if (swidth)
      XtVaSetValues ( Toplevel, XmNheight, sheight, XmNwidth, swidth, NULL);
    XtManageChild ( Heading );
    XtManageChild ( Scroll );
    XtUnmanageChild ( Tape );
  }

  AllowShellResize (Toplevel, DISALLOW);
}

static void viewButtonSet (Widget parent, int which)
{
  WidgetList buttons;
  int numbuttons;

  XtVaGetValues ( parent, 
                  XmNchildren, &buttons,
                  XmNnumChildren, &numbuttons,
		  NULL );
  for (numbuttons--; numbuttons >= 0; numbuttons--)
    XmToggleButtonSetState ( buttons[numbuttons], 
                             (which == numbuttons)?True:False, 
                             False );
}

/* ARGSUSED */
void viewCB ( Widget w, int which, XtPointer call_data)
{
  viewButtonSet (XtParent(w), which);
  viewWindowSet (which);
}

int viewGet ()
{
  if (XtIsManaged(Tape))
    return (1);
  else
    return (0);
}

void viewSet ( int which )
{
  extern Widget Viewmenu;

  if (Viewmenu)
    viewButtonSet ( Viewmenu, which );
  viewWindowSet ( which );
}


