/*
  Xquote Copyright (c)1997 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.3 $ $Date: 1997/10/13 11:37:14 $
*/

#include <stdlib.h>
#include <string.h>

#include <Xm/XmAll.h>

#include "optnet.h"
#include "opttick.h"
#include "optdetail.h"
#include "optupdate.h"
#include "pixmap.h"
#include "server.h"
#include "tape.h"
#include "xutil.h"

/* Externs */
extern Widget Toplevel;

/* Local Globals */
Widget Detail_dialog = NULL;       /* set from main */
static Widget Tick_dialog = NULL;
static Widget Update_dialog = NULL;
static Widget Tape_dialog = NULL;
static Widget Net_dialog = NULL;

/* 
** Main app menu support 
*/

/* Create appropriate dialog when an option is selected */

/* ARGSUSED */
void optionCB( Widget w, int menu_pos, XtPointer call_data)
{
  Dimension height, width, border;
  
  switch (menu_pos) {

    case 0: /* Network setup */
            if (Net_dialog == NULL)
              Net_dialog = createNetDialog();

            XtManageChild (Net_dialog);
            XtPopup ( Net_dialog, XtGrabNone);
            break;

    case 1: /* Ticker symbol dialog */
            if (Tick_dialog == NULL)
	      Tick_dialog = createTickDialog();

            XtManageChild (Tick_dialog);
            XtPopup ( Tick_dialog, XtGrabNone);

            break;

    case 2: /* Tape setup */
            if (Tape_dialog == NULL) {
              Widget pane, frame, form, button, scale;
	      int smooth, delay;
               
	      tapeGetScroll (&smooth, &delay);

              Tape_dialog = XtVaCreatePopupShell( "OptionTape", 
                                                  xmDialogShellWidgetClass,
                                                  GetTopShell(w),
                                                  NULL );

              /*
              ** This allows the frame to work and the buttons to not cause
              ** the dialog to auto unmanage.  Where is this documented?
              */
              pane = XtVaCreateWidget ( "TapePane", xmPanedWindowWidgetClass,
                                        Tape_dialog,
                                        XmNsashWidth, 1,
                                        XmNsashHeight, 1,
                                        NULL );

              frame =   XtVaCreateManagedWidget( "Tapeframe",
                            xmFrameWidgetClass, pane,
                            NULL);

              form = XtVaCreateWidget ( "Tapeform", 
                            xmFormWidgetClass, frame, 
                            NULL );
              button = XtVaCreateManagedWidget ( "button_0",
                        xmPushButtonWidgetClass, form,
                        XmNlabelType, XmPIXMAP,
                        XmNlabelPixmap, GetPixmap(PEJECT, NORMAL),
                        XmNlabelInsensitivePixmap, GetPixmap(PEJECT, INSENS),
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
                        NULL );
              XtAddCallback ( button, XmNactivateCallback,
                              (XtCallbackProc) procTape, (XtPointer) 0);
              button = XtVaCreateManagedWidget ( "button_1",
                        xmPushButtonWidgetClass, form,
                        XmNlabelType, XmPIXMAP,
                        XmNlabelPixmap, GetPixmap(PPLAY, NORMAL),
                        XmNlabelInsensitivePixmap, GetPixmap(PPLAY, INSENS),
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, button,
                        NULL );
              XtAddCallback ( button, XmNactivateCallback,
                              (XtCallbackProc) procTape, (XtPointer) 1);
              button = XtVaCreateManagedWidget ( "button_2",
                        xmPushButtonWidgetClass, form,
                        XmNlabelType, XmPIXMAP,
                        XmNlabelPixmap, GetPixmap(PSTOP, NORMAL),
                        XmNlabelInsensitivePixmap, GetPixmap(PSTOP, INSENS),
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, button,
                        NULL );
              XtAddCallback ( button, XmNactivateCallback,
                              (XtCallbackProc) procTape, (XtPointer) 2);
              button = XtVaCreateManagedWidget ( "button_3",
                        xmToggleButtonWidgetClass, form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, button,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );
              XtAddCallback ( button, XmNvalueChangedCallback,
                              (XtCallbackProc) procTape, (XtPointer) 3);
	      XmToggleButtonSetState (button, (smooth)?XmSET:XmUNSET, False);

              scale = XtVaCreateManagedWidget ("TapeScale", 
                        xmScaleWidgetClass, form, 
			XmNvalue, delay,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
                        NULL);
              XtAddCallback ( scale, XmNvalueChangedCallback, 
                              (XtCallbackProc) procTape, (XtPointer) 4);
              XtManageChild (form);
              XtManageChild (pane);

              /* Prevent pane from changing size */
              XtVaGetValues ( Tape_dialog, 
                              XmNwidth, &width,
                              XmNheight, &height,
                              XmNborderWidth, &border,
                              NULL );

              XtVaSetValues ( Tape_dialog,
                              XmNminWidth,  width +  border,
                              XmNmaxWidth,  width +  border,
                              XmNminHeight, height + border,
                              XmNmaxHeight, height + border,
                              NULL );
            }

            XtManageChild (Tape_dialog);
            XtPopup (Tape_dialog, XtGrabNone);
            break;

    case 3: /* Select update params */
            if (Update_dialog == NULL)
	      Update_dialog = createUpdateDialog ();
	    
	    XtSetMappedWhenManaged (Update_dialog, True);
            XtManageChild (Update_dialog);
            XtPopup (Update_dialog, XtGrabNone);

            break;
    case 4: /* Select interesting params */
            if (Detail_dialog == NULL)
	      Detail_dialog = createDetailDialog ();
	    
	    XtSetMappedWhenManaged ( Detail_dialog, True );
            XtManageChild (Detail_dialog);
            XtPopup ( Detail_dialog, XtGrabNone);

            break;

    default:
            break;
  }
}
