"\n",
NULL,
"Name\n",
"Xinvest 2.5.1, a personal finance package for X/Motif.\n",
"\n",
"Visit the Xinvest/Xquote home page at http://sunsite.auc.dk/xinvest/\n",
"\n",
NULL,
"Description\n",
"Xinvest is a personal finance ",
"tracking and performance tool.\n",
"\n",
"With Xinvest you can:\n",
"\n",
"Centralize record keeping by ",
"storing all transactions in account ",
"specific files.\n",
"\n",
"Calculate total and annualized ",
"returns including the effects of ",
"buys, sells, and dividends. This ",
"provides a means of comparing the ",
"results of all accounts in a ",
"portfolio, be they CDs, bonds, ",
"mutual funds, or your checking ",
"account.\n",
"\n",
"Receive automatic price updates from ",
"Xquote. On receipt of a price update ",
"Xinvest will recalculate return information.\n",
"\n",
"View various transaction parameters ",
"such as share price, shares per ",
"transaction, transaction cost, ",
"transaction value (at current ",
"price), dividends, internal and total return, ",
"and/or cumulative and moving averages of ",
"the above. Plots are transaction ",
"based bar or date based x-y charts.\n",
"\n",
"View overall value weightings of ",
"accounts in a portfolio. Specify ",
"categories, what percent of an ",
"account is in that category, and ",
"which accounts are of interest and ",
"Xinvest will tell you the value and ",
"percentage of all categories in the ",
"defined portfolio. Predefined is a ",
"account category to view weighting ",
"of accounts in the total portfolio. ",
"Categories are hierarchical, so you ",
"can zoom into the makeup of your ",
"portfolio. View in text and pie ",
"chart form.\n",
"\n",
"A Financial calculator with common ",
"equations is provided. Included ",
"are FV, PV, FV of sum of payments, ",
"and periodic loan payments.\n",
"\n",
"Hopefully, all of this is displayed ",
"using an easy-to-use, point-and-",
"click interface. There are few ",
"command line switches, no dot files, ",
"and X resources are limited to ",
"color and font selection allowing ",
"you to tailor the look of the tool ",
"to your own preferences.\n",
"\n",
"To report problems or bugs, please ",
"see the section REPORTING BUGS.\n",
"\n",
NULL,
"Invocation\n",
"Xinvest [options ...]\n",
"\n",
"where,\n",
"\n",
"options include:\n",
"\n",
"-f filename(s)  to load transaction file(s),\n",
"-help           to print this message.\n",
"-install        to install a private colormap,\n",
"or any valid X toolkit option.\n",
"\n",
"\n",
"Transaction file(s) refer to zero or more ",
"Xinvest transaction history files. 'inv' is the ",
"preferred filename extension for Xinvest transaction ",
"files, though Xinvest will read any filename.\n",
"\n",
"Xinvest supports all X toolkit ",
"options, such as -geometry (see \"man X\"). ",
"\n",
"For example, \"Xinvest -geometry 800x600 -bg gray60 -f *.inv\"",
NULL,
" Application Resources\n",
"These are X resources that are not defined by the X toolkit, ",
"but by the application itself. They are associated with the ",
"application class or toplevel shell widget, both named ",
"\"Xinvest\". A description of each resource follows.\n",
"\n",
"Xinvest.color0:\n",
"...\n",
"Xinvest.color7:\n",
"\n",
"Plot and asset allocation graphing functions draw ",
"in the colors specified with these eight resources. ",
"They may be specified in the same manner ",
"and format as any other X color resource specification.\n",
"\n",
"Xinvest.fontlist:\n",
"\n",
"Plot and report window text is rendered in two font ",
"sizes. They are specified in the ",
"default resource file as:\n",
"\n",
" \"Xinvest.fontList: fontname=small,\\\n",
" fontname=large\",\n",
"where fontname is a valid X11 font ",
"specification. These can be overridden ",
"in a user resource file like any other ",
"X resource.\n",
"\n",
"The \"=large\" and \"=small\" are ",
"significant and must be present.\n",
"\n",
"The large font is used for graph titles, ",
"reports, and to draw the financial calculator display. ",
"The small font is used for the scales ",
"in the graph display and in the asset allocation display.\n",
"\n",
"Xinvest.help:\n",
"\n",
"When this resource is set to True, Xinvest will ",
"display usage information to standard output and ",
"exit. Not recommended (at all) for use in a ",
"resource file, this resource may be set on the ",
"command line with the -help switch.\n",
"\n",
"Xinvest.install:\n",
"\n",
"When this resource is set to True, Xinvest ",
"will install a private colormap. Useful ",
"when running other applications that use ",
"a lot of the available colors. Not recommended ",
"for use in a resource file, this resource may ",
"be set on the command line with the -install ",
"switch.\n",
NULL,
"Getting Started\n",
"All that is really needed is a file ",
"containing a transaction history. ",
"See TRANSACTION FILE FORMAT for the ",
"allowable commands and format. This ",
"file can be created within Xinvest ",
"or with your favorite text editor ",
"and loaded into Xinvest (see FILE ",
"OPERATIONS).\n",
"\n",
"Once you have a transaction history ",
"loaded all the tools become active. ",
"See specific tool topics for more ",
"help.\n",
"\n",
NULL,
"Transaction File Format\n",
"The transaction file is where all ",
"of an accounts activity is ",
"recorded. Any purchase, sale, or ",
"dividend should be placed here.\n",
"\n",
"There are several types of records ",
"possible: , COMMENT(s), ",
"PERCENT(s), REINVEST(s), TICKER(s), ",
"TITLE(s), and TRANSACTION(s). ",
"Each is discussed separately.\n",
"\n",
"Transaction file contents are NOT ",
"case sensitive.\n",
"\n",
NULL,
" Comment Record\n",
"A comment record is an optional record which ",
"is ignored by Xinvest. Use as many as you like ",
"to explain the contents of a transaction file.\n",
"\n",
"A comment is any line in the ",
"transaction file which meets any of ",
"the following requirements:\n",
"\n",
"1. Column one is any white space ",
"character,\n",
"\n",
"2. Column one is the '#' or '*' ",
"characters.\n",
"\n",
"Comments may not be appended to ",
"other record types. Each comment ",
"must be on its own line.\n",
"\n",
"An example comment record is:\n",
"# This file contains the history of\n",
"# purchases of IBM stock.\n",
"\n",
NULL,
" Percent Record\n",
"The percent record is an optional ",
"record. It is used in asset ",
"allocation analysis (see ",
"ASSET ALLOCATION).\n",
"\n",
"A PERCENT record is composed of ",
"the following fields:\n",
"\n",
"KEYWORD VALUE% CAT[.CAT]\n",
"\n",
"The percent keyword is \"Percent\" ",
"and MUST begin in column one.\n",
"\n",
"VALUE is a decimal notated number ",
"signifying what percent of this ",
"account value is in this category. ",
"The number MUST be followed by the ",
"'%' character with NO spaces ",
"between them.\n",
"\n",
"The CAT field is composed of an ",
"alphanumeric string with the '.' ",
"character denoting optional levels ",
"of hierarchy. The hierarichal ",
"category name is limited to the ",
"remainder of the current line.\n",
"\n",
"There can be any number of percent ",
"records in a transaction file.\n",
"\n",
"All percent records in a file ",
"should add up to 100%, but are not ",
"required to do so. See ASSET ALLOCATION ",
"for more information.\n",
"\n",
"Example percent records are:\n",
"percent 43.8% stock.us.hitech\n",
"percent 15.3% stock.us.auto\n",
"percent 40.9% stock.intl\n",
"\n",
NULL,
" Reinvest Record\n",
"The reinvest record is an optional record. ",
"It is used to specify how to treat ",
"any \"gain\" transactions in an account. Gain transactions ",
"include any STCG, LTCG, or DIV transaction types.\n",
"\n",
"A REINVEST record is composed of the ",
"following fields:\n",
"\n",
"KEYWORD OPTION\n",
"\n",
"The reinvest KEYWORD is \"Reinvest\" ",
"and MUST begin in column one.\n",
"\n",
"The reinvest OPTION must be ",
"one of the following key words: ALL ",
"(reinvest all gains) or NONE (distribute ",
"all gains).\n",
"\n",
"If no reinvest record is specified, the ",
"default value of ALL is assumed.\n",
"\n",
"Multiple reinvest records are supported. ",
"The reinvest option used for a given transaction is the ",
"value of the last previous reinvest record or ",
"ALL, if no reinvest records were specified.\n",
"\n",
"If the reinvest option is ALL, then all gain ",
"transactions are assumed reinvested. If the reinvest ",
"option is NONE, all gains are assumed distributed from ",
"the account. If gains are distributed, this is equivalent ",
"to selling those shares on the transaction date. This ",
"effects the number of shares, cost, and value remaining in ",
"an account. The asset allocation, total return, and plot ",
"tools will reflect the setting of this option.\n",
"\n",
"Example reinvest records are:\n",
"# All gains are reinvested\n",
"Reinvest ALL\n",
"11/20/95 Buy   20.24 15\n",
"# Dividend of 11.50 reinvested at price 21.71\n",
"12/31/95 Div   21.71  0.53\n",
"# All gains are from now on are distributed\n",
"Reinvest NONE\n",
NULL,
" Ticker Record\n",
"The ticker record is an optional record. ",
"It is used to enable automatic price updates ",
"to be received from Xquote. Xquote reports ",
"price changes in terms of ticker symbols. There ",
"are ticker symbols for all publically traded ",
"companies, mutual funds, currencies, and some ",
"other commodities.\n",
"\n",
"A TICKER record is composed of the following ",
"fields:\n",
"\n",
"KEYWORD TICKER_SYMBOL\n",
"\n",
"The ticker keyword is \"Ticker\" ",
"and MUST begin in column one.\n",
"\n",
"TICKER_SYMBOL is a one to six character ",
"string defined to represent a publically ",
"traded company, mutual fund, currency, etc. ",
"The ticker symbol must be present in the ",
"Xquote ticker list for price communication ",
"to occur. See Xquote online help for more ",
"information.\n",
"\n",
"Multiple tickers are allowable, but ",
"only the last ticker directive is ",
"used.\n",
"\n",
"Example ticker records are:\n",
"ticker JANSX\n",
"ticker IBM\n",
"\n",
NULL,
" Title Record\n",
"The title record is an optional ",
"record. It is used to generate ",
"the title of accounts, reports, plots or asset allocation ",
"graphs.\n",
"\n",
"A TITLE record is composed of the ",
"following fields:\n",
"\n",
"KEYWORD TITLE_TEXT\n",
"\n",
"The title KEYWORD is \"Title\" ",
"and MUST begin in column one.\n",
"\n",
"TITLE_TEXT is any text from the ",
"end of the keyword to the end of ",
"the line. Whitespace between the ",
"end of the keyword to the start of ",
"printable characters is ignored.\n",
"\n",
"Multiple titles are allowable, but ",
"only the last title directive is ",
"used.\n",
"\n",
"An example title record is:\n",
"title Janus Fund (IRA)\n",
"\n",
NULL,
" Transaction Record\n",
"A TRANSACTION record is composed of ",
"the following fields:\n",
"\n",
"DATE TYPE PRICE [UNITS] [FEE[%]] or\n",
"DATE TYPE PRICE MAJOR:MINOR\n",
"\n",
"The DATE is the day the transaction ",
"was effective. The date format is ",
"\"month/day/year\". Years from 0 ",
"to 49 are assumed to be 20xx. ",
"Years from 50 to 99 are assumed to be ",
"19xx. It's recommended to use a full ",
"four digit year. ",
"The date MUST appear in column 1 to ",
"be recognized by Xinvest.\n",
"\n",
"The TYPE of a transaction must be ",
"one of the following key words: \n",
"BUY,\n",
"DIV (dividend or interest gain),\n",
"LTCG (long-term capital gain),\n",
"STCG (short-term capital gain),\n",
"PRICE (record price without a transaction),\n",
"SELL, or\n",
"SPLIT (record a split or reverse share split)\n",
"\n",
"The PRICE field is the unit price ",
"of the transaction. It is ",
"expressed in decimal notation.\n",
"\n",
"The UNITS field is the number of ",
"shares, at cost PRICE per unit, in ",
"the transaction. It is expressed in ",
"decimal notation. This value is always ",
"positive, regardless of the transaction TYPE. ",
"For the PRICE or SPLIT transaction type, ",
"there is NO UNITS field.\n",
"\n",
"The MAJOR:MINOR field is the ratio of a share ",
"split. It is expressed as two integers separated ",
"by a ':' with NO space intervening. These values ",
"must be in the range of 1 to 255. The first ",
"number is the multiplicand, the second the divisor. ",
"To express a 2 for 1 split use 2:1. A reverse split ",
"of 3 to 2 is expressed 2:3. This field is only ",
"valid for the SPLIT transaction type.\n",
"\n",
"The optional FEE field is a decimal notated number that ",
"can be expressed as a straight cost or as a percentage of ",
"the price times shares. A fee based on percentage MUST ",
"be followed by a '%' character with NO space between the ",
"number and percent sign. \n",
"\n",
"A fee may be specified on a BUY ",
"or DIV transaction as a broker fee or front end load, ",
"or on a SELL transaction as a back end load. ",
"The fee is NOT deducted from the amount of shares ",
"purchased. It is only used to calculate its effect ",
"on investment return. To specify a fee with no shares ",
"(eg. annual fee) bought or sold, simply specify 0 shares ",
"in a buy or sell transaction.\n",
"\n",
"Any white space in a transaction record is ",
"ignored, EXCEPT before the date field.\n",
"\n",
"Example transaction records are:\n",
"# Buy 15 shares at 20.24\n",
"11/20/95 Buy   20.24 15\n",
"# Record a price point\n",
"11/21/95 Price 20.35\n",
"# Sell 10 shares at 22.04 per share\n",
"12/21/95 Sell  22.04 10\n",
"# Dividend of 11.50 reinvested at price 21.71\n",
"12/31/95 Div   21.71  0.53\n",
"# Buy 100 shares at 21.52 with 1% front end load\n",
"1/10/96 Buy    21.53  100.0 1%\n",
"# Sell 100 shares at 22.03 with fee of 75\n",
"2/15/96 Sell   22.03  100.0 75.00\n",
"# 2 for 1 split and a slight gain in price\n",
"2/20/96 Split  11.04  2:1\n",
"\n",
NULL,
" Localized Numbers\n",
"For localized format numbers, set the ",
"LC_NUMERIC environment variable before ",
"starting Xinvest. For example, ",
"under HP-UX, \"setenv LC_NUMERIC french\". ",
"With this setting, Xinvest will accept the ",
"',' character as the decimal digit. Note ",
"that the value to set LC_NUMERIC to is architecture ",
"dependent and will be different from machine to ",
"machine.\n",
"\n",
"Some architectures do not support localized format ",
"numbers (Linux for instance). On such machines, a default ",
"U.S. format is used.\n",
"\n",
NULL,
"File Operations\n",
"File operations are related to ",
"reading, writing, and creating new ",
"account transaction files. There are two ",
"methods provided to access file ",
"functions, the file menu or the ",
"file manager.\n",
NULL,
" File Menu\n",
"The file menu is accessed by ",
"clicking on the \"File\" item on the ",
"menu bar. Choices selectable on ",
"the menu are New, Open, Close, Save, ",
"Save As, and Quit.\n",
"\n",
"The NEW button creates a new account and ",
"displays an account template in the transaction ",
"window.\n",
"\n",
"The OPEN button brings up a file ",
"selection box so that the directory ",
"and file to load may be selected. ",
"The newly loaded account becomes the ",
"currently displayed account. ",
"See ERROR CHECKS for which checks ",
"are performed when transaction ",
"files are loaded.\n",
"\n",
"The CLOSE button closes the currently ",
"displayed account. Any memory associated ",
"with the open account is freed. Xinvest will ",
"ask for confirmation before closing any account ",
"with unsaved changes. This button will ",
"not be selectable if no file was loaded.\n",
"\n",
"The SAVE button writes the contents ",
"of the transaction area back into ",
"the file it was loaded from. The ",
"originally read file is moved to ",
"\"filename\".bak. No error checks are ",
"performed on written files. This button will ",
"not be selectable if no ",
"file was loaded or there are no unsaved changes ",
"in the currently displayed account.\n",
"\n",
"The SAVE AS button writes the ",
"contents of the currently displayed account ",
"into a user selectable filename. A ",
"file selection box is brought up, ",
"where any valid directory and file",
"name may be selected to hold the ",
"transaction history. An existing ",
"or new file may be selected. A ",
"directory must be an existing one. ",
"The originally loaded file remains ",
"as it was.\n",
"\n",
"The QUIT button exits from Xinvest. ",
"The quit function may also be ",
"activated from the TOOL BUTTON BOX. ",
"Xinvest will ask for confirmation before ",
"exiting if any open account has unsaved changes.\n",
"\n",
NULL,
" File Manager\n",
"The file manager is a quick access ",
"method for creating, opening, ",
"saving, or cycling through open accounts. ",
"At startup, the file ",
"manager list window provides a list ",
"of all files in the directory where ",
"Xinvest was started. Entries are sorted ",
"alphabetically with directory entries listed ",
"first.\n",
"\n",
"By double clicking on directories ",
"(signified with \"/\" in the list ",
"window), that directory will be ",
"entered and its contents reflected ",
"in the list window.\n",
"\n",
"By double clicking on a filename, ",
"that file will be opened and displayed ",
"as the current account. See ",
"ERROR CHECKS for which checks are ",
"performed when transaction files ",
"are loaded.\n",
"\n",
"If you are using the Linux binary or ",
"compiled Xinvest with Motif 2.0, you ",
"may type the first character of any ",
"entry in the list window and the first item ",
"that begins with that character will be selected. ",
"The keyboard focus must be in the list window ",
"for this functionality.\n",
"\n",
"When an account has ",
"has been modified, the save button ",
"in the file manager will become ",
"active. Pressing this button will ",
"save all changes to the current ",
"filename. This button has the same ",
"functionality as the save file menu item.\n",
"\n",
"The new button has the same functionality ",
"as the new file menu item.\n",
"\n",
"The next and previous account buttons change the currently displayed ",
"account to the next or previous account in the open list. ",
"The open list is maintained in the order in which ",
"transaction files were opened. See ACCOUNT OPERATIONS.\n",
NULL,
"Edit Menu\n",
"The edit menu is accessed by ",
"clicking on the \"Edit\" item on the ",
"menu bar. Choices selectable on ",
"the menu are Copy, Cut, and Paste.\n",
"\n",
"The edit menu provides access to X-Windows ",
"clipboard functions, better known as cut ",
"and paste. When text in the transaction ",
"window is selected, the cut and copy operations ",
"will be enabled. Cut and copy add the selected ",
"text to the X-Windows clipboard (close enough ",
"anyway). In addition, cut removes the selected text from ",
"the transaction window. Paste places the text ",
"currently in the clipboard (from Xinvest or any ",
"other X application) into the transaction window ",
"at the position of the insertion cursor.\n",
"\n",
"The cut and copy functions are disabled if no text ",
"is selected in the transaction window. Note that you ",
"may only paste into the transaction window.\n",
NULL,
" Edit Accelerators\n",
"Accelerators have been added so that ",
"the Edit menu does not have to be pulled down ",
"in order to use the Edit functions.\n",
"\n",
"The default accelerators are <Ctrl>c for copy, ",
"<Ctrl>v, for paste, and <Ctrl>x for cut.\n",
"\n",
"To copy to the clipboard, select text in the transaction ",
"window and type <Ctrl>c. To paste, set the insertion cursor ",
"in the transaction window to the location where the new text ",
"should be added and type <Ctrl>v.\n",
"\n",
"<Ctrl> signifies holding down the control key while ",
"typing c, v, or x.\n",
NULL,
"Tool Operations\n",
"These are the main functions of Xinvest. \n",
"Tools can be selected from the \"Tools\" menu ",
"or from the button box running down ",
"the right side of the main window. ",
"The tools available are ABOUT, RETURN REPORT, ",
"PLOT, ASSET ALLOCATION, or FINANCIAL CALCULATOR.\n",
NULL,
" Tool Menu\n",
"The tool menu is accessed by clicking on the \"Tool\" ",
"item on the menu bar. Choices selectable on the menu ",
"are About, Return Report, Plot, Asset Allocation, and ",
"Financial Calculator.\n",
NULL,
" Tool Button Box\n",
"The tool button box provides an ",
"alternate method of selecting ",
"tools in addition to the tool menu. ",
"Along the side of Xinvest are a ",
"number of buttons, each corresponding ",
"to a different tool function ",
"or a button to quit Xinvest. \n",
"\n",
"Placing the mouse focus into a button will enable the ",
"display of text describing the function that ",
"button will invoke. This text may be changed in ",
"your personal or system resource file. See ",
"file Xinvest.ad.\n",
"\n",
NULL,
" Return Report Tool\n",
"The return report tool allows you to generate ",
"custom reports on your account(s) or portfolio. ",
"Results are drawn into a separate window for ",
"each report generated.\n",
"\n",
"Reports may be customized in a number of ways: ",
"by selecting a time range to calculate the report ",
"over, by selecting single account, all accounts, ",
"or portfolio reports, and by selecting a level of ",
"detail for the report.\n",
"\n",
"The following sections cover each area in detail. ",
"A report can not be generated until a time frame ",
"and account have been selected.\n",
NULL,
"  Time Frame\n",
"To select time frames of interest you may select one ",
"of the built-in time frames or create your own.\n",
"\n",
"To select a built-in time frame click on the button ",
"representing the time frame of interest. When the ",
"mouse enters a button, a line of text will be ",
"posted describing the time range of that button. ",
"Built-in time ranges consist of: 1 day, 1 week, 1 month, ",
"1 quarter (3 months), year to date (YTD), 1 year, since ",
"inception of the account, and custom. You may select as ",
"many time frames simultaneously as you like.\n",
"\n",
NULL,
"   Custom Time\n",
"Selecting the custom time frame button allows you to ",
"exactly specify the starting and ending report times. ",
"When the custom time frame button is selected, the next/previous ",
"page button at the bottom of the tool manager will become ",
"active. Click on it to enter the custom date screen.\n",
"\n",
"The custom time frame screen consists of a calendar, a ",
"menu to select between start and end dates, and ",
"a number of buttons to help you navigate to dates which ",
"are specified in the currently displayed account. The ",
"default values of the start and end dates are the first ",
"transaction date, and the current date, respectively.\n",
"\n",
"To specify a different start date, insure the option menu is displaying ",
"'Start'. Manipulate the calendar until the start date of the ",
"report is selected. A date is selected when the month and year ",
"of interest are displayed and you have clicked on a day. Selecting ",
"an end date is similar. When switching between start and end date ",
"displays, Xinvest remembers the other date and will redisplay it ",
"when you return to that endpoint's display.\n",
"\n",
"Buttons are provided to navigate between dates valid in the ",
"currently displayed account. Dates that appear in the transaction ",
"history are highlighted on the calendar. Four buttons allow you to ",
"easily select among these dates. The previous transaction button ",
"will change the calendar display to the next older transaction defined ",
"in the transaction history (if there is one). Similarly, the next ",
"transaction button will change the calendar display to the next newer ",
"transaction (if there is one). ",
"The first transaction button displays the date of the first ",
"transaction in the transaction history, while the last transaction ",
"button displays the date of the last transaction.\n",
"\n",
"You may return to the return report tool main screen by clicking ",
"on the next/previous screen button at the bottom of the tool ",
"manager.\n",
NULL,
"  Accounts\n",
"To select which accounts are to be included in a report simply ",
"click on one of the three account buttons. The choices ",
"include the currently displayed account, all accounts, or ",
"a portfolio report. Current account and all accounts may ",
"not be selected simultaneously. When the mouse enters one ",
"of the account buttons, text will be posted describing the ",
"value of that choice.\n",
"\n",
NULL,
"  Options\n",
"Three options are available for report generation: details, ",
"annualize, and live. \n",
"\n",
"When 'details' is selected, more information ",
"is provided in the report (see Report Display). \n",
"\n",
"When 'annualize' is selected, the total return and yield calculations ",
"will include annualized results (see Report Equations). \n",
"\n",
"When 'live' is selected, the last report window posted (or next ",
"if none are currently open) will be refreshed by: any price quote, ",
"changing the currently displayed account, or by clicking on the ",
"\"check\" report button. If 'live' is not selected, then report ",
"windows remain static and to view any report changes it is ",
"necessary to post a new report.\n",
NULL,
"  Display\n",
"The return report tool provides account or portfolio summary ",
"information in a new window for each report. Data displayed ",
"consists of:\n",
"\n",
"For each account or portfolio:\n",
"* account or portfolio title.\n",
"* current value, number of shares,\n",
"  and last price per share.\n",
"For each report time frame:\n",
"* report time frame\n",
"  If the detail option is on:\n",
"    * change in value over the time frame.\n",
"    * change in debit over the time frame.\n",
"    * change in cost over the time frame.\n",
"    * change in fee over the time frame.\n",
"  * total return (TR) over the time frame.\n",
"  * internal rate of return (IRR) over the time frame.\n",
"  * yield over the time frame.\n",
"\n",
"If annualize is on, total return and yield ",
"will include the raw return as well as the ",
"return annualized (see Report Equations).\n",
NULL,
"   Localized Currency and Date\n",
"For localized format dates, set the ",
"LC_TIME environment variable before ",
"starting Xinvest. For example, ",
"under Solaris, \"setenv LC_TIME en_US\". ",
"With this setting, Xinvest will display dates ",
"in the MM/DD/YY format. Note that the ",
"value to set LC_TIME to (and the resultant ",
"display) is architecture dependent and ",
"will be different from machine to ",
"machine. Some architectures do not support ",
"localized dates (Linux), on such machines a default ",
"U.S. format is used.\n",
"\n",
"For localized format currency, set the ",
"LC_MONETARY environment variable before ",
"starting Xinvest. For example, ",
"under Solaris, \"setenv LC_MONETARY fr\". ",
"With this setting, Xinvest will display monetary ",
"values with the French Franc (eg 1.200,37F). ",
"Note that the value to set LC_MONETARY to (and ",
"the resultant display) is architecture dependent ",
"and will be different from machine to machine. ",
"Some architectures do not support ",
"localized currency (Linux), on such machines a default ",
"U.S. format is used.\n",
"\n",
"Xinvest's default is not to display with localized ",
"currency because some architectures don't support ",
"it yet (Linux). To build Xinvest with this support see the ",
"README file.\n",
NULL,
"  Equations\n",
"Xinvest reports calculate three return ",
"values: yield, total return, and internal ",
"rate of return. Each is described in the following ",
"sections as well as the method of annualization.\n",
"\n",
"Return calculations are effected by the ",
"reinvest record. See \"Reinvest Record\" ",
"for more help.\n",
"\n",
"Calculations are also affected by any ",
"fees associated with transactions. Fees ",
"on purchases increase the cost of transactions, ",
"while fees on sales reduce the number of ",
"shares remaining in the account. This can be ",
"considered a bug, as Xinvest should support fees ",
"more flexibly (either taken from account or ",
"paid out-of-pocket.\n",
"\n",
"Note that return values in excess of 1000% are displayed ",
"as '>1000%'.\n",
NULL,
"   Yield\n",
"Yield is defined as return generated as a result of ",
"distributions from the account (DIV, STCG, or ",
"LTCG transactions). These distributions are counted ",
"whether distributed or reinvested.\n",
"\n",
"Daily yield is calculated as the number of shares ",
"distributed divided by the number of shares ",
"previously owned. Final yield is the summation of the ",
"daily yields. The summation is performed only over ",
"the transactions within the start and end dates ",
"selected.\n",
NULL,
"   Total Return\n",
"Total return is calculated as the ",
"sum of all current shares times the ",
"current price, plus the value of any ",
"shares sold, divided by the cost of ",
"all shares bought. The summation is ",
"performed only over the transactions ",
"within the start and end ",
"dates selected.\n",
"\n",
NULL,
"   Internal Rate of Return\n",
"IRR is calculated by ",
"using the summation of future values (FV) ",
"of all purchases and sales of shares. ",
"This is compared to the value of all ",
"current shares times the current price. ",
"The FV equation is iterated with a ",
"\"guess\" of the actual rate until the FV ",
"result matches the current value.\n",
"\n",
"The summation of future values is ",
"performed only on transactions within ",
"the specified start and end dates. ",
"If any transactions exist before the ",
"start date, the net value of the account ",
"on the start date is added as a pseudo ",
"buy transaction.\n",
"\n",
NULL,
"   Annualize\n",
"Report values are annualized by the following ",
"equation: ((1.0+rate)**(1.0/years) - 1.0) * 100.0.\n",
"This is a simple compounding equation where the ",
"compunding period is derived from the time frame ",
"of the report period. For example, a one day time ",
"frame report would have a 'years' value of 1.0/365.0.\n",
"\n",
"NOTE THAT SHORT TIME FRAMES CAN GENERATE ",
"PREPOSTEROUSLY HUGE ANNUALIZED VALUES.\n",
NULL,
" Plot Tool\n",
"The plot tool provides information ",
"about a transaction history in a ",
"graphical manner. Plots are displayed ",
"in the plot window. \n",
"\n",
"To select a plot variable, simply select the plot tool ",
"from the tool menu or button bar. ",
"A list of plot variables will be presented. ",
"Click on the desired component's button. The button ",
"pixmap will change from the graph background color when ",
"selected to an actual sample of how that variable will ",
"look in the plot window. In effect, the control area ",
"becomes a legend to interpreting the plot window.\n",
"\n",
"Information that may be plotted consists of: \n",
"\n",
"1. Price per transaction,\n",
"2. Shares per transaction,\n",
"3. Cost per transaction,\n",
"4. Value per transaction (at current NAV),\n",
"5. Distribution per transaction,\n",
"6. Internal rate of return,\n",
"7. Total return, and a\n",
"8. Line with user definable start and slope.\n",
"\n",
"Also selectable are simple ",
"functions (derived variables) of the ",
"above, such as moving average and ",
"cumulative results.\n",
"\n",
"Graphs may be drawn in a bar graph by ",
"transaction or line graph by date. ",
"As many variables may be selected ",
"at once as desired.\n",
"\n",
NULL,
"  Plot Modes - Single or Multi-Account\n",
"The plot tool has two distinct mechanisms ",
"for supporting accounts: single ",
"or multi-account modes. Each is selectable from ",
"the plot control panel in the tool manager. Single ",
"account mode is selected with the button containing a ",
"single document icon, multi-account with the button ",
"containing a multiple document icon.\n",
"\n",
"Single account mode applies the currently ",
"selected plot variables to every displayed account. ",
"Select any number of plot variables, change the ",
"displayed account and the same list of plot variables ",
"is drawn, but reflecting the values of the currently ",
"displayed account transactions. The plot variable legends do not ",
"change on displaying a different account.\n",
"\n",
"Multi-account mode allows you to selectively pick what ",
"plot variable in which account is plotted. All selected ",
"plot variables across all open accounts are displayed ",
"simultaneously. The plot variable selection area only ",
"displays a legend for those variables in the currently ",
"displayed account. Change the displayed account and the ",
"legends will reflect which plot variables are on in this ",
"newly displayed account. The plot window will always ",
"display all selected plot variables in all open accounts.\n",
NULL,
"  Plot Style - Bar or Line Graph\n",
"The plot tool supports two distinct plotting styles: ",
"bar or line (X-Y). Each is selectable from the plot control ",
"panel in the tool manager.\n",
"\n",
"Bar graphs, or plotting by transaction, displays a transaction ",
"history value by drawing a bar (filled rectangle) for each ",
"transaction in the transaction history. Selected plot ",
"variables are overlaid in each bar such that they are all ",
"visible at once. Bar plots are DISABLED in multi-account mode.\n",
"\n",
"Line graphs, or plotting by date, displays a transaction ",
"history by dividing up the graph area width into equal ",
"time segments. A line is drawn from each transaction ",
"date to the next using the value at that transaction. ",
"Each plot variable is drawn with its own line.\n",
NULL,
"  Plot Options\n",
"Zoom - by selecting Zoom from the option menu, ",
"the graph vertical ",
"range will be bounded by the actual minimum ",
"and maximum of selected plot variables. If ",
"this option is off, the Y axis will begin at 0 ",
"or the minimum plot value (if less than 0). ",
"The zoom default keyboard accelerator is <Ctrl>z.\n",
"\n",
"Show Points - by selecting Show Points from ",
"the option menu, when plotting by date, each ",
"transaction will be highlighted at the point ",
"on the line corresponding to the date specified ",
"in the transaction history. The show points ",
"default keyboard accelerator is <Ctrl>p.\n",
"\n",
"Show Grid - by selecting Show Grid from ",
"the option menu a grid will be superimposed ",
"over the graph area. If this option is off, ",
"no grid will be displayed. The show grid ",
"default keyboard accelerator is <Ctrl>g.\n",
NULL,
"  Colors and Attributes\n",
"The user may specify the eight colors that ",
"are used to draw in the plot window. See ",
"\"Application Resources\" for how to select them.\n",
"\n",
"Furthermore, there are three patterns that ",
"are used to draw plots. This provides for up ",
"to 24 distinct plot attributes. Any number of plot ",
"variables over this number results in some ",
"duplication of drawing attributes.\n",
"\n",
"For line plots, the line attributes are solid, ",
"and two patterns of dashed line. For bar plots, ",
"the fill attributes are solid color, and two ",
"\"stipple\" patterns.\n",
NULL,
"  Fonts\n",
"To select the small and large fonts used ",
"in the plot window, see \"Application ",
"Resources\".\n",
"\n",
"If the drawing area is sized too small ",
"for text to be drawn into, a warning ",
"message will pop up. You may either ",
"resize the Xinvest window to make it ",
"larger (hence the text fits), or quit ",
"and change the small and large font ",
"sizes.\n",
NULL,
"  Plot Window Resizing\n",
"The plot window may be resized from ",
"its default size up to the size of ",
"the entire height of the Xinvest ",
"main window by dragging the horizontal ",
"resize sash.\n",
"\n",
"If you have built Xinvest ",
"with Motif 2.0 or are using the Linux ",
"binary, the plot window may be sized ",
"to fill the entire width of the window ",
"using the vertical resize sash. ",
NULL,
"  Derived Variables\n",
"Cumulative variables are a simple ",
"running summation of all transaction ",
"values from the first transaction ",
"(date) to the current transaction ",
"(date).\n",
"\n",
"Moving average variables depend on ",
"the selected graph type, transaction ",
"or date based. Transaction based ",
"moving averages are the summation of ",
"the last N transactions divided by N. ",
"Date based moving averages are the ",
"summation of all transactions within ",
"the previous N weeks, divided by the ",
"number of transactions in that period. ",
"N is selected with the moving ",
"average slider. If N is larger than ",
"the current transaction, no summations ",
"are started.\n",
NULL,
"  Localized Date Display\n",
"Xinvest will display localized dates in ",
"graphs when plotting by date. See \"Localized ",
"Currency and Date\" under Return Report ",
"for more information.\n",
NULL,
"  Other Notes\n",
"1. If the values selected for the ",
"constant line do not appear within ",
"the graph area defined by other ",
"plotted variables, the line will not ",
"be visible.\n",
"\n",
"2. The plot display will inform you if ",
"values are based on a NAV changed in ",
"the total return screen. If the NAV ",
"calculator is changed from the value ",
"of the last transaction in the transaction ",
"history, that value will be used in value, ",
"IRR, and TR calculations. A change in the ",
"calendar currently has no effect on graph ",
"calculations but will result in a changed NAV ",
"indication.\n",
"\n",
"3. If you receive errors about needing ",
"to change font sizes, see \"Fonts\" under ",
"\"Plot\".\n",
NULL,
" Asset Allocation Tool\n",
"The asset allocation tool provides a look ",
"across a portfolio, providing data ",
"on content. This tool answers such ",
"questions as what percent of my money ",
"is in account X, what percent is in ",
"US stock funds, global bond funds, ",
"etc. The categories are completely ",
"user definable by adding \"Percent\" ",
"lines to the transaction history file. ",
"A portfolio is any combination of ",
"transaction files that contain ",
"\"Percent\" records.\n",
"\n",
"To use, define whatever categories ",
"you are interested in and the ",
"percentage of the account in those categories. ",
"Percent lines are hierarchical, so that in ",
"one account there may be stock.us ",
"and in another stock.intl. Both ",
"appear under stock. With these two ",
"lines you can determine how much of ",
"the two accounts' value is in stock, ",
"stock.intl or stock.us.\n",
"\n",
"Percent records in a transaction file ",
"do not have to add up to 100%. If they ",
"do not, then any remaining percentage of ",
"the account is not counted in the portfolio ",
"value.\n",
NULL,
"  Adding and Deleting Accounts\n",
"To add or delete an account from the ",
"portfolio, load the account into ",
"Xinvest (if not already loaded) or ",
"display the account (if it is; see ",
"ACCOUNT OPERATIONS).\n",
"\n",
"Press either ADD (REMOVE) from the portfolio ",
"tool area. The account file name ",
"will be added to (removed from) the portfolio ",
"list and the tree structure updated. NOTE ",
"THAT ADD OR DELETE ACT ONLY ON THE ",
"ACCOUNT CURRENTLY DISPLAYED IN THE ",
"TRANSACTION WINDOW.\n",
"\n",
"Press CLEAR to completely purge the ",
"portfolio tree. This is useful if ",
"there is an error in a loaded transaction ",
"file that corrupts the portfolio tree.\n",
"\n",
"Press ADD ALL to add all open accounts ",
"to the portfolio. This is useful if Xinvest ",
"is started with many account files on the ",
"command line. Xinvest will warn you if ",
"you attempt to load an account more than ",
"once.\n",
NULL,
"  Viewing Asset Allocation Contents\n",
"By adding an account to the portfolio ",
"the top level of the hierarchy will ",
"be displayed as both a text list ",
"and a pie chart. \n",
"\n",
"To enter a deeper level, ",
"double click on the name in ",
"the list window. The text and pie ",
"chart will shift to this new level. ",
"Each level reports the total value ",
"at that level and the percent ",
"composition at that level.\n",
"\n",
"To go up a level, double click on the '..' ",
"item in the list window. If there is no ",
"such item, you are at the top of the ",
"hierarchy.\n",
"\n",
"To return to the top of the heirarchy, ",
"select \"Root\" from the \"Display\" ",
"menu. Other selections from this ",
"menu include \"Accounts\" which shows ",
"portfolio percentage based on which ",
"account its in, and \"Flatten\", which ",
"flattens the heirarchy, showing all ",
"categories as if they were at the ",
"top level.\n",
NULL,
"  Selecting Colors\n",
"The user may specify the eight colors that ",
"are used to draw in the plot window. See ",
"\"Application Resources\" for how to select them.\n",
NULL,
"  Common Problems\n",
"A ending name in one account can ",
"not be a parent name in the same or ",
"another account. For instance, it ",
"is incorrect to have the following ",
"percent lines in a portfolio (one or ",
"more accounts):\n",
"\n",
"percent 45%  stock.us\n",
"percent 100% stock\n",
"\n",
"Xinvest stores combined data in ",
"these parent nodes which is corrupted ",
"in this case. Xinvest will detect ",
"and report these errors.\n",
NULL,
" Financial Calculator Tool\n",
"The financial calculator tool function provides ",
"solutions to a number of common financial ",
"equations. To use, simply select the financial ",
"calculator tool from the tool menu or button bar. ",
"Pick the equation to solve from the \"Function\" ",
"menu, type in the missing information ",
"in the text boxes, and select a ",
"compounding period from the \"Compounded\" ",
"menu. As data is added, it will show ",
"up in the display. When all of the ",
"required numbers have been entered, ",
"the result will be calculated and the ",
"display updated.\n",
"\n",
"Results are displayed in the plot window. ",
"Variables that have not been entered yet ",
"are displayed in a stippled pattern. ",
"Specified numbers are displayed in a ",
"lighter shade than other text (color ",
"displays only). The final result is displayed in ",
"a darker shade on color displays and reverse video ",
"on monochrome systems.\n",
NULL,
"  Future Value (Lump)\n",
"Future value calculates the value of ",
"a current sum that grows at a periodic ",
"rate for a given number of years at a ",
"selectable compounding rate. The ",
"equation is FV = PV * (1+RATE)**N, ",
"where N = YEARS*COMPOUNDING.\n",
"\n",
"For example, how much will 50,000 be ",
"worth in 10 years at 8% compounded daily? ",
"Select \"Future Value (Lump)\" from the ",
"function menu. Enter 50000, 8, and 10, ",
"into the text fields; select daily ",
"compounding from the compounding menu. ",
"The result, 111,267.29, is displayed. ",
NULL,
"  Future Value (Series)\n",
"Future value calculates the value of ",
"a series of equal payments at a ",
"given rate of return for a given number of ",
"years. The compounding menu specifies how ",
"often payments are made (monthly, weekly, etc).\n",
"\n",
"The equation is FV = ",
"SUM ( PAYMENT * (1+RATE)**N) ), where ",
"SUM is the summation from N = 0 (the ",
"last payment) to N=YEARS*COMPOUNDING ",
"(the first payment).\n",
"\n",
"For example, how much will monthly ",
"savings of 500 be worth in 10 years at ",
"8%? Select \"Future Value (Series)\" ",
"from the function menu. Enter 500, 8, ",
"and 10 into the text fields; select ",
"monthly compounding from the compounding ",
"menu. The result of 94,473.02 is ",
"displayed.\n",
NULL,
"  Periodic Payment\n",
"Periodic payment determines what the ",
"required periodic payment is to retire ",
"a present value at a given rate and ",
"compounding factor. This is useful ",
"for loan payment calculations for ",
"instance.\n",
"\n",
"The equation is PAYMENT = ",
"PV / ( (1.0 - (1 + RATE)**-N) / RATE), ",
"where N is YEARS*COMPOUNDING.\n",
"\n",
"For example, what are the monthly ",
"payments for a 15000 loan at 10.5% for ",
"4 years? Select \"Periodic Payment\" ",
"from function menu. Enter 15000, 10.5, ",
"and 4 into the text fields; select ",
"monthly compounding from the compound",
"ing menu. The result, 384.05, is dis",
"played.\n",
NULL,
"  Present Value\n",
"Present value determines the current ",
"value of a future sum, discounted by ",
"by the given rate and compounding factor, ",
"for the given number of years.\n",
"\n",
"The equation is PV = FV / (1 + RATE)**N, ",
"where N = YEARS*COMPOUNDING.\n",
"\n",
"For example, how much is 1,000,000 in 20 ",
"years worth now, given a 4% inflation ",
"rate, compounded yearly? Select ",
"\"Present Value\" from function menu. ",
"Enter 1000000, 4, and 20 into the text ",
"fields; select annually from the compounding ",
"menu. The result, 456386.95, is displayed.\n",
NULL,
"  Rate of Return\n",
"Rate of return calculates the required ",
"percentage rate to grow a present ",
"value to a future value at a given ",
"compounding rate and number of years,\n",
"\n",
"The equation is RATE = (FV/PV)**1/N - 1. ",
"N is YEARS*COMPOUNDING.\n",
"\n",
"For example, what rate is needed to ",
"grow 50,000 to 1,000,000 in 30 years ",
"compounded yearly? Select \"Rate\" from ",
"the function menu. Enter 50000, ",
"1000000, and 30 into the text fields; ",
"select annually from the compounding ",
"menu. The result, 10.50%, is displayed.\n",
NULL,
"Option Menu\n",
"The option menu is accessed by clicking on the \"Options\" ",
"item on the menu bar. Operations available are ",
"ZOOM, SHOW POINTS, and SHOW GRID. ",
"See \"Plot Options\" for a description of these ",
"options.\n",
NULL,
"Account Operations\n",
"Account operations are a means of managing ",
"multiple open transaction histories. ",
"Account functions can be selected from the ",
"\"Account\" menu. Operations available are ",
"PREVIOUS and NEXT account, APPLY CHANGES, ",
"or display a particular account. ",
"Previous and next account are also available ",
"from the file manager.\n",
NULL,
" Account Menu\n",
"The account menu is accessed by clicking on the \"Account\" ",
"item on the menu bar. Operations available are ",
"PREVIOUS and NEXT accounts, APPLY CHANGES, ",
"or display a particular account.\n",
"\n",
"Previous account displays the previous open account ",
"in the open account list. The open account ",
"list is maintained in the order in which ",
"transaction files were loaded. The list cycles ",
"from later to earlier entries before wrapping ",
"back to the latest account. This function is ",
"accessible from the FILE MANAGER and as the ",
"keyboard accelerator <Shift><Alt>Tab.\n",
"\n",
"Next account is similar to previous account, just ",
"traveling from older to newer accounts in the open ",
"account list. This function is ",
"also accessible from the FILE MANAGER and as the ",
"keyboard accelerator <Alt>Tab.\n",
"\n",
"Apply changes is used after making changes to a ",
"transaction file in the transaction window. This ",
"is necessary to check for errors and to update ",
"values used by other tools. This menu item is ",
"only active if unapplied changes are detected in ",
"the currently displayed account. Note that it is ",
"not necessary to save or apply changes in an account ",
"to display other accounts. Xinvest will remember ",
"which accounts have unsaved or unapplied changes.\n",
"\n",
"The remainder of the account menu is used to select ",
"among all open accounts by name. The name in the ",
"menu item is made from the TITLE directive or ",
"will be generated by Xinvest if there is no title. ",
"Up to 9 account names will be displayed (less, if there ",
"are less open accounts. Starting with the 10th and ",
"subsequent open accounts, a \"More\" menu item will appear ",
"as the last menu item. Selecting this item will popup ",
"a dialog with a list of all open accounts. Double clicking ",
"on any name in the dialog will set the account focus to ",
"the selected account.\n",
NULL,
"View Operations\n",
"View operations currently consist of only one function, ",
"view message log, which logs any error or warning messages ",
"generated since Xinvest was started.\n",
NULL,
" View Menu\n",
"The view menu is accessed by clicking on the \"View\" ",
"item on the menu bar. The only operation available is ",
"Message Log.\n",
"\n",
"View \"Message Log\" pops up a dialog ",
"containing a history of all Xinvest warning, error, or ",
"informational messages displayed since Xinvest was ",
"started. This is a handy way to review detected errors ",
"in transaction files. The message log contains enough ",
"information to pinpoint which account, if any, had a ",
"detected error. Note that not all error messages are a ",
"result of problems in account transaction files.\n",
NULL,
"Keyboard Shortcuts\n",
"Plot toggle y-axis zoom\t\t<Ctrl>z\t\n",
"Plot toggle show transaction points\t<Ctrl>p\n",
"Plot toggle show grid\t\t<Ctrl>g\n",
"\n",
"Edit copy current selection\t\t<Ctrl>c\n",
"Edit paste current selection\t\t<Ctrl>v\n",
"Edit cut current selection\t\t<Ctrl>x\n",
"\n",
"Account display previous open account\t<Shift><Alt>Tab\n",
"Account display next open account\t<Alt>Tab\n",
"\n",
"Note that the last two accelerators sometimes causes ",
"tab characters to be entered in the transaction ",
"window if that window has the keyboard focus. ",
"You may wish to override this accelerator with ",
"a different one if you find this annoying. See ",
"file 'Xinvest.ad'.\n",
NULL,
"Error Checks\n",
"Correct syntax in transaction files is ",
"checked at two different points. Most ",
"lines are checked when the file is ",
"loaded. \"Percent\" lines, however, ",
"are checked when the account is added ",
"to the portfolio in the asset allocation tool.\n",
"\n",
"Xinvest reports errors to a popup ",
"window and to a scrolling status ",
"dialog. All errors or warnings are ",
"retained for review in the message ",
"dialog. See VIEW OPERATIONS.\n",
"\n",
"Most transaction records are checked at ",
"file load time or when the \"apply changes\" ",
"menu item is selected (see ACCOUNT OPERATIONS). ",
"Errors detected at this time include:\n",
"\n",
"1. incorrect number of fields in title,\n",
"2. invalid transaction type,\n",
"3. incorrect number of fields for transaction type,\n",
"4. transaction dates not sorted earliest to latest.\n",
"\n",
"Asset allocation percent lines are checked at ",
"the time an account is added or removed ",
"from the portfolio. Note that no checks ",
"are performed when the CLEAR button is selected. ",
"Errors detected at this time include:\n",
"\n",
"1. no filename is associated with the account,\n",
"2. node name specified as both child and parent,\n",
"3. percentage is malformed or not a number.\n",
NULL,
"Session Management\n",
"Session management refers (as far as Xinvest is ",
"concerned) to a mechanism that allows an application ",
"to save its internal state before being terminated. \n",
"\n",
"Xinvest supports both the X11R5 and X11R6.1 ",
"session management protocols. For this to work, your ",
"window manager must support the protocol. \n",
"\n",
"You must set an environment variable to tell Xinvest ",
"where it should hide the saved session files. \n",
"\n",
"csh users: \n",
"setenv SM_SAVE_DIR dir\n",
"\n",
"sh users: \n",
"SM_SAVE_DIR=dir; export SM_SAVE_DIR\n",
"\n",
"'dir' is a full path to a valid, writable directory.\n",
"\n",
"To see if Xinvest thinks your window manager complies, ",
"look in the message log (see View Operations). ",
"The message log will contain an informational line ",
"describing the protocol used (if any). There will be ",
"no message if your window manager doesn't support ",
"session management.\n",
"\n",
NULL,
"Xquote Price Communication\n",
"Xinvest accepts automatic price quotes from Xquote. ",
"All that is required is a ticker tape symbol ",
"in Xinvest that matches one in Xquote (see Ticker ",
"Record). On each price update, Xquote will search for ",
"an Xinvest to send price updates to.\n",
"\n",
"To detect whether Xinvest has received a price ",
"quote, generate a return report and verify the ",
"last price used matches that present in Xquote.\n",
"\n",
"Return reports will use automatic price points ",
"in calculations if the current date is within ",
"the time frame selected for return calculations. ",
"This is true for all of the built-in time frames.\n",
NULL,
"Known Problems\n",
"1. Multiple transactions on one date ",
"will not plot correctly when displayed ",
"by date. Multiple points appear on ",
"that date. Haven't decided whether ",
"to combine those transaction records ",
"or detect in graphing routine.\n",
"\n",
NULL,
"Reporting Bugs\n",
"Send mail to Mark Buser ",
"(buser@micro.ti.com). Please be ",
"sure to include sufficient detail, including ",
"revisions of the OS, compiler, X, and anything ",
"else you think might help track down the problem.\n",
"\n",
NULL,
"Credits\n",
"Mark Buser\n",
"931 Greenfield Ave\n",
"Pittsburgh, PA  15217\n",
"(buser@micro.ti.com)\n",
"\n",
"Thanks to Amy for letting me use ",
"the computer when she would rather ",
"be playing Monkey Island.\n",
"\n",
"Xinvest total return calculations ",
"were inspired by nav.c, author ",
"unknown. I snarfed it off the net ",
"in the mid 80's and don't even have ",
"a copy of it anymore. Anybody?\n",
"\n",
"Xpm, developed by Arnaud Le Hors, ",
"certainly makes Motif look snappier.\n",
"\n",
"The O'Reilly books provided a lot of ",
"useful hints, and the Motif FAQ also ",
"helped on occasion.\n",
"\n",
"Xinvest was originally developed on a 486-66 ",
"running Linux 1.0.8, XFree 2.1.1, and ",
"Motif 1.2.\n",
"\n",
"If you like this program, let me ",
"know! If you really like it, ",
"donations are appreciated and will ",
"go to improving Xinvest.",
NULL,
"Copyright\n",
"Copyright \2511995-97 Mark Buser, All Rights Reserved.\n",
"\n",
"Permission is hereby granted to copy ",
"and freely distribute copies of this ",
"program for non-commercial purposes ",
"without fee, provided that this notice ",
"appears in all copies.\n",
"\n",
"All redistributions must be in their ",
"entirety as originally distributed. ",
"Feel free to modify Xinvest, but ",
"modified versions may not be distributed ",
"without prior consent of the author.\n",
"\n",
"This software is provided 'as-is' ",
"without any express or implied warranty. ",
"In no event will the author be held ",
"liable for any damages resulting from ",
"the use of this software.\n",
