/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#define  shadow_file
#include "shadow.h"
#include <math.h>



#define stipple_width 2
#define stipple_height 2

/********************************************************************************
 * constructor: initialize parameters
 * widgets are created in the first calls of draw() to save resources when
 * shadows are never needed
 ********************************************************************************/
shadow_t::shadow_t(Widget top) {
  flag_ = 0;
  toplevel_ = top;
  stipple_bits_[0] = 0x01;
  stipple_bits_[1] = 0x02;
}

shadow_t::~shadow_t(){}    /* destructor */

/********************************************************************************
 * draws a shadow with index num of given widget wid at xy-offset
 ********************************************************************************/
void shadow_t::draw(Widget wid, int num, int offset){
  int x_root, y_root, i;
  unsigned int w_root, h_root, bw_root, d_root;
  short x,y,w,h;
  Window root;
  static Cursor curs = 0;
  
  if(num >= NUM_SHADOWS || num < 0){
    fprintf(stderr, "not enough shadows!\n");
    return;
  }

  if(!flag_){                                                /* first call */
    
    for(i=0 ; i < NUM_SHADOWS ; i++)
      numflag_[i]=0;
    
    curs = XCreateFontCursor(XtDisplay(wid), XC_dot);     /* create cursor */
    val_.foreground = BlackPixelOfScreen(XtScreen(wid));
    val_.background = WhitePixelOfScreen(XtScreen(wid));
    
    gc_ = XCreateGC(XtDisplay(wid),                         
		    RootWindowOfScreen(XtScreen(wid)),
		    GCForeground|GCBackground, &val_);
    
    stipple_ = XCreateBitmapFromData(XtDisplay(wid),
				     RootWindowOfScreen(XtScreen(wid)),
				     stipple_bits_,
				     stipple_width,
				     stipple_height);
    
    flag_=1;
  }
  
  if(numflag_[num] == 0){
    shadow_[num] = XtCreatePopupShell("noop",
				     overrideShellWidgetClass,
				     toplevel_, NULL, 0);
    XtVaSetValues(shadow_[num], XtNborderWidth, 0, NULL);
    shadow_drw_[num] =
      XtVaCreateManagedWidget("", xmLabelWidgetClass, shadow_[num],
			      XmNforeground,
			      BlackPixelOfScreen(XtScreen(wid)),
			      XmNbackground,
			      BlackPixelOfScreen(XtScreen(wid)),
			      XmNwidth, 1, XmNheight, 1,
			      NULL);
    numflag_[num]=1;
  }

    
  XtVaGetValues(wid,
		XtNx, &x,
		XtNy, &y,
		XtNwidth, &w,
		XtNheight, &h,
		NULL);
  XGetGeometry(XtDisplay(wid),
	       RootWindowOfScreen(XtScreen(wid)),
	       &root,
	       &x_root, &y_root, &w_root, &h_root, &bw_root, &d_root);
  
  XtVaSetValues(shadow_[num], XtNx, w_root, XtNy, h_root, NULL);
  XtPopup(shadow_[num], XtGrabNone);
  XDefineCursor(XtDisplay(wid), XtWindow(shadow_[num]), curs);
  
  if( x + offset  >= (int)w_root || y + offset >= (int)h_root) return;
  
                        /* xgetimage only possible at visible parts of screen */
  if( x < 0 ) {         
    w = w - abs(x) + offset;
    x = 0 - offset;
    
  }
  if( y < 0 ) {
    h = h - abs(y) + offset;
    y = 0 - offset;
  }
  if( x + offset + w > (int)w_root ) w = w_root - x - offset ;
  if( y + offset + h > (int)h_root ) h = h_root - y - offset ;

 
  Pixmap pix =                                     /* create pixmap for shadow */
    XCreatePixmap(XtDisplay(wid),
		  RootWindowOfScreen(XtScreen(wid)),
		  w, h,
		  DefaultDepthOfScreen(XtScreen(wid)));
                                                      /* copy from root-window */
  XImage *image = XGetImage(XtDisplay(wid),   
			    RootWindowOfScreen(XtScreen(wid)),
			    x + offset, y + offset, w, h,
			    AllPlanes, ZPixmap);
  
  XPutImage(XtDisplay(wid),                             /* put image on pixmap */
	    pix,
	    gc_,
	    image, 0,0,0,0,w,h);
  
  val_.fill_style = FillStippled;
  val_.stipple = stipple_;
  
  XChangeGC(XtDisplay(wid), gc_, GCStipple|GCFillStyle, &val_);
  
  XFillRectangle(XtDisplay(wid),                   /* fill pixmap with stipple */
		 pix,
		 gc_,
		 0,0,w,h);
                                             /* set background-pixmap of label */  
  XtVaSetValues(shadow_drw_[num], XmNbackgroundPixmap, pix, NULL);
                                                               /* set position */
  XtVaSetValues(shadow_[num],
		XtNx, x + offset, XtNy, y + offset,
		XtNwidth, w , XtNheight, h , NULL);
  
  XFreePixmap(XtDisplay(wid), pix);
  XDestroyImage(image);
}

/********************************************************************************/
void shadow_t::del(int num){
  if(num >= NUM_SHADOWS || num < 0)
    return;
  if(numflag_[num]==1)
    XtPopdown(shadow_[num]);
}

