/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#define main_file
#include "main.h"
#include "adr.h"
#include "xresources.h"
#include "util.h"
#include "callbacks.h"
#include "shadow.h"
#include <Xm/Protocols.h>
#include <Xm/AtomMgr.h>

static XrmOptionDescRec options[]={
  {"-h",          "*help",      XrmoptionNoArg,  "True"},
  {"-autoP",      "*autoPopup", XrmoptionNoArg,  "True"},
  {"-dataF",      "*dataFile",  XrmoptionSepArg, ".rolo"},
  {"-shadow",     "*shadow",    XrmoptionNoArg,  "True"},
  {"-savekill", "*savekill",    XrmoptionNoArg,  "True"} 
};

static String fallback_resources[]={
  "*background: grey70",
  "*dataText.fontList: 7x14",
  "*Confirm*fontList: 7x14",
  "*info-text.labelString : xh-address\\n version 1.0\\n (c)1995 \\n by Klaus Hartenstein",
  NULL
};

/********************************************************************************/

main(int argc, char **argv)
{
  Widget
    dummy,
    form0,
    form00,
    form01,
    form10,
    frame,
    mainForm,
    rowc0;


  mainWindow.toplevel =
    XtAppInitialize(&(mainWindow.app_con),
		    "Xaddr",   
		    options, XtNumber(options),
		    (int *)&argc, (String *)argv,
		    fallback_resources,
		    NULL, 0);

  XtAddCallback(mainWindow.toplevel,
		XmNdestroyCallback, QuitCB, (XtPointer)1);
  
  XtVaSetValues(mainWindow.toplevel,
		XtNallowShellResize, True, NULL);

  LoadApplicationResources(mainWindow.toplevel);

  if(app_data.help){
    printf("usage: %s [ -shadow ] [ -h ] [ -dataF <filename> ] [ -savekill ]\n", argv[0]);
    exit(0);
  }
                                                 /* create popupshell for data */
  
  mainWindow.popup = XtCreatePopupShell("Xh-address",
					transientShellWidgetClass,
					mainWindow.toplevel,
					NULL, 0);
  
                                          /* ensure input focus for popupshell */
  XtAddEventHandler(mainWindow.popup,
		    EnterWindowMask, False,
		    (XtEventHandler)SetInputFocusEH,
		    (XtPointer)NULL);
                                               /* disable windowmanager access */  
  XtVaSetValues(mainWindow.popup,
		XtNoverrideRedirect, True,
		XtNborderWidth, 1,
		XmNkeyboardFocusPolicy, XmPOINTER,
		NULL);


  
  if(app_data.autoPopup){                                 /* manage auto popup */
    XtAddEventHandler(mainWindow.toplevel,
		      EnterWindowMask, False,
		      (XtEventHandler)EnterMainEH,
		      (XtPointer)NULL);
    XtAddEventHandler(mainWindow.popup,
		      LeaveWindowMask, False,
		      (XtEventHandler)LeaveMainEH,
		      (XtPointer)NULL);
  }

		    
  
  mainForm =                                            /* create main button */
    XtVaCreateManagedWidget("mainform", xmFormWidgetClass,
			    mainWindow.toplevel,
			    NULL);
  
  CreatePixmaps(mainForm, &pixmaps);
  
  dummy =
    XtVaCreateManagedWidget("", xmPushButtonWidgetClass, mainForm,
			    XmNlabelType, XmPIXMAP,
			    XmNindicatorOn, False,
			    XmNshadowThickness, 3,
			    XmNlabelPixmap, pixmaps.logo_pixmap,
			    XmNbackground,
			    BlackPixelOfScreen(XtScreen(mainWindow.toplevel)),
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNtopAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NULL);


  
  if(!app_data.autoPopup)
    XtAddCallback(dummy,
		  XmNactivateCallback, PopupDataCB, NULL);
  
  if(!app_data.autoPopup)                   /* right mouse button pops up info */
    XtAddEventHandler(dummy,
		      ButtonPressMask, False,
		      (XtEventHandler)ButtonpressEH,
		      (XtPointer)NULL);
  
  
   frame =
     XtVaCreateManagedWidget("frame", xmFrameWidgetClass, mainWindow.popup,
 			    XmNshadowType,      XmSHADOW_OUT,
 			    XmNshadowThickness, 4,
 			    XmNborderWidth,     2,
 			    NULL);
   rowc0 =
     XtVaCreateManagedWidget("rowc0", xmRowColumnWidgetClass, frame, NULL);
  
   form0 =
     XtVaCreateManagedWidget("form0", xmFormWidgetClass, rowc0, NULL);
  
                                     /* delete and new-buttons on the left side */
  
   form00 =
     XtVaCreateManagedWidget("form00", xmFormWidgetClass, form0,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNleftAttachment,   XmATTACH_FORM,
 			    NULL);
                                                                 /* exit button */  
   dummy =
     XtVaCreateManagedWidget("E", xmPushButtonWidgetClass, form00,
 			    XmNlabelType,        XmPIXMAP,
 			    XmNlabelPixmap,      pixmaps.exit_pixmap,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_POSITION,
 			    XmNrightPosition,    25,
 			    NULL);
   XtAddCallback(dummy,
		 XmNactivateCallback, ConfirmCB, (XtPointer)CONFIRM_EXIT);
  
                                                               /* delete button */  
   dummy =
     XtVaCreateManagedWidget("D", xmPushButtonWidgetClass, form00,
 			    XmNlabelType,        XmPIXMAP,
 			    XmNlabelPixmap,      pixmaps.delete_pixmap,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       dummy,
 			    XmNrightAttachment,  XmATTACH_POSITION,
 			    XmNrightPosition,    50,
 			    NULL);
   XtAddCallback(dummy,
		 XmNactivateCallback, ConfirmCB, (XtPointer)CONFIRM_DELETE);
  
                                                                 /* new button */  
   dummy =
     XtVaCreateManagedWidget("N", xmPushButtonWidgetClass, form00,
 			    XmNlabelType,        XmPIXMAP,
 			    XmNlabelPixmap,      pixmaps.new_pixmap,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       dummy,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_POSITION,
 			    XmNrightPosition,    75, 
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    NULL);
   XtAddCallback(dummy,
		 XmNactivateCallback, NewCB, (XtPointer)CONFIRM_DELETE);
  
                                                              /* save button */
   dummy =
     XtVaCreateManagedWidget("S", xmPushButtonWidgetClass, form00,
 			    XmNlabelType,        XmPIXMAP,
 			    XmNlabelPixmap,      pixmaps.save_pixmap,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       dummy,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    NULL);

   XtAddCallback(dummy,
		 XmNactivateCallback, ConfirmCB, (XtPointer)CONFIRM_SAVE);
  
                                       /* up and down-buttons on the right side */
  
   form01 =
     XtVaCreateManagedWidget("form01", xmFormWidgetClass, form0,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNresizable,        False,
 			    NULL);

                                                /* for record number and meter */
   mainWindow.number =
     XtVaCreateManagedWidget("   ", xmLabelWidgetClass, form01,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNleftAttachment,   XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_POSITION,
 			    XmNrightPosition,    50,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    NULL);

   XtAddEventHandler(mainWindow.number,
		     ExposureMask, False, RedrawRecMeterEH, NULL);


//   dummy = XtVaCreateManagedWidget("<>", xmScrollBarWidgetClass, form01,
// 				  XmNtopAttachment,    XmATTACH_FORM,
// 				  XmNleftAttachment,   XmATTACH_WIDGET,
// 				  XmNbottomAttachment, XmATTACH_FORM,
// 				  XmNsliderSize, 1,
// 				  XmNorientation, XmHORIZONTAL,
// 				  XmNleftWidget,       mainWindow.number,
// 				  XmNrightAttachment,  XmATTACH_FORM, NULL);

                                                       /* prev-record button */
   dummy =
     XtVaCreateManagedWidget("<", xmArrowButtonWidgetClass, form01,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       mainWindow.number,
 			    XmNrightAttachment,  XmATTACH_POSITION,
 			    XmNarrowDirection,   XmARROW_UP,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNrightPosition,    75,
 			    NULL);
   XtAddCallback(dummy, XmNactivateCallback,
 		(XtCallbackProc)PrevNextCB, (XtPointer)PREV);
  
                                                       /* next-record button */
   dummy =
     XtVaCreateManagedWidget(">", xmArrowButtonWidgetClass, form01,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       dummy,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNrightAttachment,  XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNarrowDirection,   XmARROW_DOWN,
 			    NULL);
   XtAddCallback(dummy, XmNactivateCallback,
 		(XtCallbackProc)PrevNextCB, (XtPointer)NEXT);
  
                                                  /* textedit for search-string */
  
   mainWindow.searchText =
     XtVaCreateManagedWidget("searchText",xmTextWidgetClass, form0,
 			    XmNleftAttachment,   XmATTACH_WIDGET,
 			    XmNleftWidget,       form00,
 			    XmNrightAttachment,  XmATTACH_WIDGET,
 			    XmNrightWidget,      form01,
 			    XmNtopAttachment,    XmATTACH_FORM,
 			    XmNbottomAttachment, XmATTACH_FORM,
 			    XmNwidth,            50,
 			    XmNhighlightOnEnter, True,
 			    NULL);
  
   XtAddCallback(mainWindow.searchText, XmNactivateCallback,
 		(XtCallbackProc)SearchCB, (XtPointer)SEARCH_FROM);
   XtAddCallback(mainWindow.searchText, XmNvalueChangedCallback,
 		(XtCallbackProc)SearchCB, (XtPointer)SEARCH_BEG);
  
                                                                /* data field */
  
   dummy =
     XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, rowc0,
			     XmNorientation, XmHORIZONTAL,
			     NULL);
  
   form10 =
     XtVaCreateManagedWidget("form10", xmFormWidgetClass, rowc0, NULL);
  
   dummy =
     XtVaCreateManagedWidget("scrolled", xmScrolledWindowWidgetClass,
 			    form10,
 			    XmNleftAttachment,         XmATTACH_FORM,
 			    XmNtopAttachment,          XmATTACH_FORM,
 			    XmNbottomAttachment,       XmATTACH_FORM,
 			    XmNrightAttachment,        XmATTACH_FORM,
 			    XmNscrollBarDisplayPolicy, XmAUTOMATIC,
 			    NULL);

  
   mainWindow.dataText =
     XtVaCreateManagedWidget("dataText", xmTextWidgetClass, dummy,
 			    XmNeditMode, XmMULTI_LINE_EDIT,
 			    XmNheight,   200,
 			    XmNwidth,    300,
 			    NULL);
  
  XtAddCallback(mainWindow.dataText, XmNvalueChangedCallback, DataChangedCB, NULL);
  
  book.load_addr(app_data.dataFile);                    /* load address data */
  shadow = new shadow_t(mainWindow.toplevel);           /* init shadows      */
  

  XtRealizeWidget(mainWindow.toplevel);
                                                       /* set WM_PROTOCOLS   */
                                                       /* > save before exit */
                                                       /* via wm-menu        */
  
  mainWindow.wm_atom = XInternAtom(XtDisplay(mainWindow.toplevel),
				   "WM_DELETE_WINDOW", False);
  
  XmAddWMProtocolCallback(mainWindow.toplevel,
			  mainWindow.wm_atom,
			  SaveCB, NULL);
  
  if(app_data.savekill)                 /* save when xconnection interrupted */
    XSetIOErrorHandler(IOErrorHandler); /* saves data on normal session end  */
                                        
  
  XtAppMainLoop(mainWindow.app_con);
  return 0;
}

