/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#define callbacks_file

#include "main.h"
#include "util.h"
#include "callbacks.h"
#include "adr.h"
#include "xresources.h"
#include "shadow.h"
#include "info.h"


static void DeleteCB(Widget, XtPointer, XtPointer);
static void Count(void);
static void Save(void);

static short enter = 0;
static int current_address = 0;

#define SHADOW_OFFSET 20
#define NO_REC "\n\n\n    ..EMPTY.."

/********************************************************************************
 * set input focus to popup window
 * some windowmanagers need this
 ********************************************************************************/

void SetInputFocusEH(Widget,
		     XtPointer,
		     XEvent *,
		     Boolean *)
{
  XSetInputFocus(XtDisplay(mainWindow.toplevel),
		 XtWindow(mainWindow.popup),
		 RevertToPointerRoot,
		 CurrentTime);
}


/********************************************************************************
 * handles leaveWindow events in toplevel window: unmanage dataField
 ********************************************************************************/
void LeaveMainEH(Widget,
		 XtPointer,
		 XEvent *,
		 Boolean *)
{
  if(enter){
    address_t *a = 0;
                                                   /* if data changed -> update */
    if((a = book.addr(current_address)) != 0)
      if(a->changed()){
	char *str = XmTextGetString(mainWindow.dataText);
	a->addr(str);
	XtFree(str);
      }
    XtPopdown(mainWindow.popup);
    if(app_data.shadow)
      shadow->del(0);
    enter = 0;
  }
}


/********************************************************************************
 * handles enterWindow events in toplevel window: manage dataField
 ********************************************************************************/
void EnterMainEH(Widget w,
		 XtPointer,
		 XEvent *,
		 Boolean *)
     
{

  if(!enter){
    SetPos(mainWindow.popup, mainWindow.toplevel);
    if(app_data.shadow)
      shadow->draw(mainWindow.popup,0,SHADOW_OFFSET);
    XtPopup(mainWindow.popup, XtGrabNone);

    XSetInputFocus(XtDisplay(mainWindow.toplevel),
		   XtWindow(mainWindow.popup),
		   RevertToPointerRoot,
		   CurrentTime);
    
    XWarpPointer(XtDisplay(w),
		   RootWindowOfScreen(XtScreen(w)),
		   XtWindow(mainWindow.searchText),
		   0,0,0,0,
		   70,10
		   );
                                             /* if data available - display it */
    if(book.num_addr() > 0)
      XmTextSetString(mainWindow.dataText, book.addr(current_address)->addr());
    
    do_events(mainWindow.toplevel, mainWindow.app_con);
    enter = 1;
  }
  Count();
}

/********************************************************************************
 * set position of popup-shell
 ********************************************************************************/
void SetPos(Widget pop, Widget top)
{
  static int first=1;
  unsigned short width, height, h;
  short x, y, yy;

  
  if(first==1){
    XtVaSetValues(pop, XtNx, WidthOfScreen(XtScreen(pop)),
		  XtNy, HeightOfScreen(XtScreen(pop)), NULL);
    first=0;
    XtPopup(pop, XtGrabNone);
    XDefineCursor(XtDisplay(mainWindow.toplevel),
		  XtWindow(mainWindow.popup),
		  XCreateFontCursor(XtDisplay(mainWindow.toplevel), XC_center_ptr));
    XtPopdown(pop);
  }
  
  XtVaGetValues(top,
		XtNx, &x,
		XtNy, &y,
		XtNheight, &h,
		NULL);
  yy=y;
  XtVaGetValues(pop,
		XtNwidth, &width,
		XtNheight, &height,
		NULL);

  /* ensure that window is not covered by screen boundaries */
  
  if((x + width) > WidthOfScreen(XtScreen(top)))
    x = WidthOfScreen(XtScreen(top)) - width - 1 ;
  if((y + height) > HeightOfScreen(XtScreen(top)))
    y = HeightOfScreen(XtScreen(top)) - height - 1;
  if(y < yy)
    y = yy - height - h - 15;
  if(x < 0)
    x = 0;

  
  
  XtVaSetValues(pop, XtNx, x, XtNy, y+h, NULL);

}
  
/********************************************************************************
 * switch to prev/next address record
 ********************************************************************************/
void PrevNextCB(Widget, XtPointer client_data, XtPointer)
{
  address_t *a = 0;
                                                  /* if data changed -> update */
  if((a = book.addr(current_address)) != 0)
    if(a->changed()){
      char *str = XmTextGetString(mainWindow.dataText);
      a->addr(str);
      XtFree(str);
    }
  
  switch((int)client_data){
  case PREV:
    a = book.prev(&current_address);
    break;
  case NEXT:
    a = book.next(&current_address);
    break;
  default:
    break;
  }
  
  if(a)
    XmTextSetString(mainWindow.dataText, a->addr());
  Count();
}

/********************************************************************************
 * search in all records for string in searchText.
 * client_data = SEARCH_BEG: search from beginning.
 * otherwise search from actual position
 ********************************************************************************/
void SearchCB(Widget w, XtPointer client_data, XtPointer)
{
  int i;
  char *str = XmTextGetString(mainWindow.searchText);
  address_t *a = 0;
                                                  /* if data changed -> update */
  if((a = book.addr(current_address)) != 0)
    if(a->changed()){
      char *dstr = XmTextGetString(mainWindow.dataText);
      a->addr(dstr);
      XtFree(dstr);
    }
  switch((int)client_data){
  case SEARCH_BEG:
    i = book.search(str);
    break;
  case SEARCH_FROM:
  default:
    i = book.search(str, current_address);
    break;
  }
  if(i >= 0){
    XmTextSetString(mainWindow.dataText, book.addr(i)->addr());
    current_address = i;
  }
  else
    XBell(XtDisplay(w), 100);
  Count();
  XtFree(str);
}

/********************************************************************************
 * pops up data window
 ********************************************************************************/
void PopupDataCB(Widget, XtPointer, XtPointer)
{
  static short flag=0;
  if(!flag){
    SetPos(mainWindow.popup, mainWindow.toplevel);
    if(app_data.shadow)
      shadow->draw(mainWindow.popup, 0, SHADOW_OFFSET);
    XtPopup(mainWindow.popup, XtGrabNone);
    flag=1;
                                             /* if data available - display it */
    if(book.num_addr() > 0)
      XmTextSetString(mainWindow.dataText, book.addr(current_address)->addr());
    else{
      XmTextSetString(mainWindow.dataText, NO_REC);
      XtVaSetValues(mainWindow.dataText, XmNsensitive, False, NULL);
    }
      
  }
  else{
    address_t *a = 0;
    if((a = book.addr(current_address)) != 0)
      if(a->changed()){
	char *str = XmTextGetString(mainWindow.dataText);
	a->addr(str);
	XtFree(str);
      }
    
    XtPopdown(mainWindow.popup);
    if(app_data.shadow)
      shadow->del(0);
    flag=0;
  }
  Count();
}

/********************************************************************************
 * set changed field of address when data changes
 ********************************************************************************/
void DataChangedCB(Widget, XtPointer, XtPointer)
{
  if(book.addr(current_address))
    book.addr(current_address)->changed(1);
}

/********************************************************************************
 * callback for corfirm actions  save, quit and delete
 ********************************************************************************/
void ConfirmCB(Widget, XtPointer client_data, XtPointer)
{
  static Widget shell=0;
  static Widget txt, ok, cancel, dont_save;
  
  if(!shell){                          /* if shell does not exist -> create it */
    
    Widget form, sep, dummy;
    
    shell = XtCreatePopupShell("Confirm",
			       transientShellWidgetClass,
			       mainWindow.toplevel, 
			       NULL, 0);
    XtVaSetValues(shell,
		  XmNallowShellResize, True,
		  XtNoverrideRedirect, True,
		  XtNborderWidth,1,
		  NULL);
    XtAddCallback(shell, XmNdestroyCallback, DestroyCB, (XtPointer)&shell);
    form = XtVaCreateManagedWidget("form", xmFormWidgetClass, shell,
				   XmNshadowThickness, 3,
				   NULL);
    dummy   = XtVaCreateManagedWidget(" ", xmLabelWidgetClass, form,
				      XmNalignment, XmALIGNMENT_CENTER,
				      XmNleftOffset, 10,
				      XmNtopOffset, 10,
				      XmNleftAttachment, XmATTACH_FORM,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNrightOffset, 10,
				      XmNlabelType, XmPIXMAP,
				      XmNlabelPixmap, pixmaps.question_pixmap,
				      NULL);
    txt   = XtVaCreateManagedWidget(" ", xmLabelWidgetClass, form,
				    XmNalignment, XmALIGNMENT_CENTER,
				    XmNleftOffset, 10,
				    XmNtopOffset, 10,
				    XmNleftAttachment, XmATTACH_WIDGET,
				    XmNleftWidget, dummy,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    XmNrightOffset, 10,
				    NULL);
    sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
				  XmNleftAttachment, XmATTACH_FORM, 
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopOffset, 10,
				  XmNtopWidget, dummy,
				  NULL);
    XtVaSetValues(txt,
		  XmNbottomAttachment, XmATTACH_WIDGET,
		  XmNbottomOffset, 10,
		  XmNbottomWidget, sep, NULL);
    
    ok = XtVaCreateManagedWidget("OK", xmPushButtonWidgetClass, form,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNleftOffset, 10,
				 XmNbottomOffset, 10,
				 XmNtopOffset, 10,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, sep,
				 NULL);
    
    cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, form,
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNbottomAttachment, XmATTACH_FORM,
				     XmNleftOffset, 10,
				     XmNtopOffset, 10,
				     XmNbottomOffset, 10,
				     XmNleftWidget, ok,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, sep,
				     NULL);
    XtAddCallback(cancel, XmNactivateCallback, PopdownCB, (XtPointer)shell);
    XtAddCallback(cancel, XmNactivateCallback, DelShadowCB, (XtPointer)1);
    
    dont_save = XtVaCreateWidget("No Save", xmPushButtonWidgetClass, form,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNleftOffset, 10,
				 XmNbottomOffset, 10,
				 XmNtopOffset, 10,
				 XmNleftAttachment, XmATTACH_WIDGET,
				 XmNleftWidget, cancel, 
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, sep,
				 NULL);
    XtAddCallback(dont_save, XmNactivateCallback, QuitCB, (XtPointer)0);
    
    XtVaSetValues(shell, XtNx, WidthOfScreen(XtScreen(shell)),
		  XtNy, HeightOfScreen(XtScreen(shell)), NULL);
    XtPopup(shell,XtGrabNone);
    XDefineCursor(XtDisplay(shell),
		  XtWindow(shell),
		  XCreateFontCursor(XtDisplay(shell), XC_left_ptr));
    XtPopdown(shell);
    
  }
  
  XmString str;
  short x_data, y_data, w_data, h_data;
  short w_shell, h_shell;

  
  XtRemoveAllCallbacks(ok, XmNactivateCallback);
  XtUnmanageChild(dont_save);
  
  switch((int)client_data){
  case CONFIRM_EXIT:
    str = XmStringCreateSimple("Really exit and save?");
    XtVaSetValues(txt, XmNlabelString, str, NULL);
    XmStringFree(str);
    XtManageChild(dont_save);
    XtAddCallback(ok, XmNactivateCallback, QuitCB, (XtPointer)1);
    break;
  case CONFIRM_SAVE:
    str = XmStringCreateSimple("Really save?");
    XtVaSetValues(txt, XmNlabelString, str, NULL);
    XmStringFree(str);
    XtAddCallback(ok, XmNactivateCallback, SaveCB, NULL);
    XtAddCallback(ok, XmNactivateCallback, PopdownCB, (XtPointer)shell);    
    XtAddCallback(ok, XmNactivateCallback, DelShadowCB, (XtPointer)1);    
    break;
  case CONFIRM_DELETE:
    str = XmStringCreateSimple("delete actual record?");
    XtVaSetValues(txt, XmNlabelString, str, NULL);
    XmStringFree(str);
    XtAddCallback(ok, XmNactivateCallback, DeleteCB, NULL);    
    XtAddCallback(ok, XmNactivateCallback, PopdownCB, (XtPointer)shell);    
    XtAddCallback(ok, XmNactivateCallback, DelShadowCB, (XtPointer)1);    
    break;
  default:
    break;
  }
  
                                                   /* set shell position */
  XtVaGetValues(mainWindow.popup,
		XmNx, &x_data,
		XmNy, &y_data,
		XmNwidth, &w_data,
		XmNheight, &h_data, NULL);
  XtVaGetValues(shell,
		XmNwidth, &w_shell,
		XmNheight, &h_shell, NULL);
  
  XtVaSetValues(shell,
		XtNx, (short)(x_data+(short)((w_data-w_shell)/2)),
		XtNy, (short)(y_data+(short)((h_data-h_shell)/2)),
		NULL);

  if(app_data.shadow)
    shadow->draw(shell, 1, (int)(SHADOW_OFFSET/2));
  XtPopup(shell, XtGrabExclusive);
  
//  XRaiseWindow(XtDisplay(shell), XtWindow(shell));
}

/********************************************************************************
 * sets widget variable to 0 to indicate that it's destroyed
 ********************************************************************************/
void DestroyCB(Widget, XtPointer client_data, XtPointer)
{
  Widget *wid = (Widget *)client_data;
  *wid = 0;
}

/********************************************************************************
 * quit-callback. if client_data=1 save data before exiting
 ********************************************************************************/
void QuitCB(Widget, XtPointer client_data, XtPointer)
{
  if((int)client_data)
    Save();
  exit(0);
}

/********************************************************************************
 * callback to save all records
 ********************************************************************************/
void SaveCB(Widget, XtPointer, XtPointer)
{
  Save();
}

/********************************************************************************
 * save all records in a file
 ********************************************************************************/
static void Save(void)
{
  address_t *a = 0;
  if((a = book.addr(current_address)) != 0){
    if(a->changed()){
      char *str = XmTextGetString(mainWindow.dataText);
      a->addr(str);
      XtFree(str);
    }   
  }
  book.save_addr(app_data.dataFile);
}  

/********************************************************************************
 * delete actually displayed record
 ********************************************************************************/
static void DeleteCB(Widget, XtPointer, XtPointer)
{
  book.kill_addr(&current_address);
  if((book.addr(current_address)))
    XmTextSetString(mainWindow.dataText,book.addr(current_address)->addr());
  else
    XmTextSetString(mainWindow.dataText,"");
  Count();
  if(book.num_addr() == 0){
    XtVaSetValues(mainWindow.dataText, XmNsensitive, False, NULL);
    XmTextSetString(mainWindow.dataText, NO_REC);
  }
    
}

/********************************************************************************
 * creates a new address record
 ********************************************************************************/
void NewCB(Widget, XtPointer, XtPointer)
{
  address_t *a = book.addr(current_address);
  
  if(book.num_addr() == 0)
    XtVaSetValues(mainWindow.dataText, XmNsensitive, True, NULL);
  
  if(a)
    if(a->changed())
      a->addr(XmTextGetString(mainWindow.dataText));
  book.add_addr(current_address, "");
  XmTextSetString(mainWindow.dataText,"");
  Count();
}

/********************************************************************************
 * pops down shell in client_data
 ********************************************************************************/
void PopdownCB(Widget, XtPointer client_data, XtPointer)
{
  if(client_data)
    XtPopdown((Widget)client_data);
}
/********************************************************************************
 * pops down shell in client_data
 ********************************************************************************/
void DelShadowCB(Widget, XtPointer client_data, XtPointer)
{
  if(app_data.shadow)
    shadow->del((int)client_data);
}

/********************************************************************************
 * show current record number in label widget
 ********************************************************************************/
static void Count(void)
{
  XmString str;
  char num[10];
  if(book.num_addr() == 0)
    sprintf(num, "-");
  else
    sprintf(num, "%d", current_address + 1);
  str = XmStringCreateSimple(num);
  XtVaSetValues(mainWindow.number, XmNlabelString, str, NULL);
  XmStringFree(str);
}

/********************************************************************************
 * draws a horizontal bar to indicate the number of the actual record
 ********************************************************************************/
void RedrawRecMeterEH(Widget w,
		      XtPointer,
		      XEvent *,
		      Boolean *)
{
  short width, height;
  float val;
  
  XtVaGetValues(w, XmNwidth, &width, XmNheight, &height, NULL);
  
  if(book.num_addr() != 0)
    val = ((float)(width-5) * ((float)current_address / (float)book.num_addr()));
  else
    val = (float)(width-5);
  
  if(val > width) val = (float)(width-5);

  XFillRectangle(XtDisplay(w),
		 XtWindow(w),
		 DefaultGCOfScreen(XtScreen(w)),
		 3, height-4, (short)val, 2);
  
  XDrawLine(XtDisplay(w),
	    XtWindow(w),
	    DefaultGCOfScreen(XtScreen(w)),
	    3, height-2,
	    3, height-5);
  XDrawLine(XtDisplay(w),
	    XtWindow(w),
	    DefaultGCOfScreen(XtScreen(w)),
	    width-3, height-2,
	    width-3, height-5);
  XDrawLine(XtDisplay(w),
	    XtWindow(w),
	    DefaultGCOfScreen(XtScreen(w)),
	    (short)(width/2), height-2,
	    (short)(width/2), height-5);
}

/********************************************************************************
 * called when system call X-IO error occurs (Server shutdown, kill client).
 * ensures saving at normal X-session termination.
 ********************************************************************************/
int IOErrorHandler(Display *)
{
  Save();
  exit(0);
  return(0); // centerline compiler needs this 
}


/********************************************************************************
 * eventhandler for button3-press events
 ********************************************************************************/
void ButtonpressEH(Widget ,
		 XtPointer,
		 XEvent *evt,
		 Boolean *)
{
  if(evt->xbutton.button == Button3)
    PopupInfo();
}
