/*---------------------------------------------------------------------------
  Module FmAwActions
  
  (c) Simon Marlow 1990-92
  (c) Albert Graef 1994

  Action procedures for widgets in the application window
---------------------------------------------------------------------------*/

#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Toggle.h>

#include "Am.h"

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

int findAppWidget(Widget w)
{
  int i;

  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].toggle == w)
      return i;
  return -1;
}

/*---------------------------------------------------------------------------*/

void appPopup(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  Display *dpy;
  Window root, child;
  int x, y, x_win, y_win;
  unsigned int mask;
  int i = findAppWidget(w);

  dpy = XtDisplay(aw.shell);

  XQueryPointer(dpy, XtWindow(w), &root, &child, &x, &y, 
		&x_win, &y_win, &mask);

  /* check whether icon was selected */
  if (child != None) {
    XTranslateCoordinates(dpy, XtWindow(w), child, x_win, y_win,
			  &x_win, &y_win, &child);
    if (child != None) w = XtWindowToWidget(dpy, child);
  }

  i = findAppWidget(w);
  if (i != -1) appSelect(w, event, params, num_params);

  if (i == -1) {
    if (aw.n_selections == 0)
      grayOut(app_popup_items[1]);
    else
      fillIn(app_popup_items[1]);

    XQueryPointer(dpy, DefaultRootWindow(dpy), &root, &child, &x, &y, 
		  &x_win, &y_win, &mask);
  
    XtVaSetValues(app_popup_widget, XtNx, (XtArgVal) x, XtNy, (XtArgVal) y,
		  NULL);
  
    XtPopupSpringLoaded(app_popup_widget);
  } else {
    XQueryPointer(dpy, DefaultRootWindow(dpy), &root, &child, &x, &y, 
		  &x_win, &y_win, &mask);
  
    XtVaSetValues(app_popup_widget1, XtNx, (XtArgVal) x, XtNy, (XtArgVal) y,
		  NULL);
  
    XtPopupSpringLoaded(app_popup_widget1);
  }
}  

/*---------------------------------------------------------------------------*/

void appMaybeHighlight(Widget w, XEvent *event, String *params, 
		       Cardinal *num_params)
{
  int i;

  if (!dragging)
    return;
  
  i = findAppWidget(w);
  if (*aw.apps[i].drop_action)
    XtCallActionProc(w, "highlight", event, NULL, 0);
}

/*---------------------------------------------------------------------------*/

void runApp(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  int i;
  char **argv;
  char directory[MAXPATHLEN];

  i = findAppWidget(w);
  strcpy(directory, aw.apps[i].directory);
  if (*directory)
    fnexpand(directory);
  else
    strcpy(directory, user.home);

  if (*aw.apps[i].push_action)
    if (!strcmp(aw.apps[i].push_action, "EDIT"))
      doEdit(directory, aw.apps[i].fname);
    else if (!strcmp(aw.apps[i].push_action, "OPEN")) {
      int l = strlen(directory);
      if (directory[l-1] != '/')
	directory[l++] = '/';
      strcpy(directory+l, aw.apps[i].fname);
      newFileWindow(directory, resources.default_display_type,
		    False);
    } else if (!strcmp(aw.apps[i].push_action, "LOAD")) {
      int j, l = strlen(directory);
      zzz();
      if (resources.auto_save && aw.modified)
	writeApplicationData(resources.app_file);
      strcpy(resources.app_file, directory);
      if (resources.app_file[l-1] != '/')
	resources.app_file[l++] = '/';
      strcpy(resources.app_file+l, aw.apps[i].fname);
      for(j=0; j<aw.n_apps; j++)
	freeApplicationResources(&aw.apps[j]);
      XTFREE(aw.apps);
      readApplicationData(resources.app_file);
      updateApplicationDisplay();
      wakeUp();
    } else {
      char *action = varPopup(aw.apps[i].icon_bm, aw.apps[i].push_action);
      if (!action) return;
      if (*aw.apps[i].fname)
	argv = makeArgv2(action, aw.apps[i].fname);
      else
	argv = makeArgv(action);
      executeApplication(user.shell, directory, argv);
      freeArgv(argv);
    }
}

/*---------------------------------------------------------------------------*/

void appEndMove(int i)
{
  char **argv;

  if (*aw.apps[i].drop_action) {
    char *action = varPopup(aw.apps[i].icon_bm, aw.apps[i].drop_action);
    if (!action) return;
    if (*aw.apps[i].fname) {
      int l;
      char path[MAXPATHLEN];
      strcpy(path, aw.apps[i].directory);
      if (*path)
	fnexpand(path);
      else
	strcpy(path, user.home);
      l = strlen(path);
      if (path[l-1] != '/')
	path[l++] = '/';
      strcpy(path+l, aw.apps[i].fname);
      argv = makeArgv2(action, path);
    } else
      argv = makeArgv(action);
    argv = expandArgv(argv);
    executeApplication(user.shell, move_info.fw->directory, argv);
    freeArgv(argv);
  }
}

/*---------------------------------------------------------------------------*/

void appEndMoveInBox(void)
{
  int i;

  for (i=0; i<move_info.fw->n_files; i++)
    if (move_info.fw->files[i]->selected) {
      if (S_ISDIR(move_info.fw->files[i]->stats.st_mode)) {
	installApplication(move_info.fw->files[i]->name,
			   move_info.fw->directory,
			   move_info.fw->files[i]->name,
			   "",
			   "OPEN",
			   "");
      } else if (move_info.fw->files[i]->stats.st_mode &
		 (S_IXUSR | S_IXGRP | S_IXOTH)) {
	char *push_action, *drop_action;
	push_action = move_info.fw->files[i]->name;
	drop_action = (char *)alloca(strlen(push_action)+4);
	strcpy(drop_action, push_action);
	strcat(drop_action, " $*");
	installApplication(move_info.fw->files[i]->name,
			   move_info.fw->directory,
			   "",
			   "",
			   push_action,
			   drop_action);
      } else if (move_info.fw->files[i]->type) {
	installApplication(move_info.fw->files[i]->name,
			   move_info.fw->directory,
			   move_info.fw->files[i]->name,
			   move_info.fw->files[i]->type->icon,
			   move_info.fw->files[i]->type->push_action,
			   move_info.fw->files[i]->type->drop_action);
      } else {
	installApplication(move_info.fw->files[i]->name,
			   move_info.fw->directory,
			   move_info.fw->files[i]->name,
			   "",
			   "EDIT",
			   "");
      }
    }
  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

void appSelect(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  int i, j;
  Pixel back, fore;
  
  j = findAppWidget(w);
  if (j == -1) {
    error("Internal error:", "widget not found in appSelect");
    return;
  }
  
  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
      XtVaGetValues(aw.apps[i].toggle, XtNbackground, &back, NULL);
      XtVaSetValues(aw.apps[i].toggle, XtNborder, (XtArgVal) back, NULL);
      aw.apps[i].selected = False;
    }

  XtVaGetValues(w, XtNforeground, &fore, NULL);
  XtVaSetValues(w, XtNborder, (XtArgVal) fore, NULL);
  
  aw.apps[j].selected = True;
  aw.n_selections = 1;
}

/*---------------------------------------------------------------------------*/

void appToggle(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  int i;
  Pixel pix;
  
  i = findAppWidget(w);
  if (i == -1) {
    error("Internal error:", "widget not found in appToggle");
    return;
  }
  
  XtVaGetValues(w, aw.apps[i].selected?XtNbackground:XtNforeground, &pix,
		NULL);
  XtVaSetValues(w, XtNborder, (XtArgVal) pix, NULL);
  
  aw.apps[i].selected = !aw.apps[i].selected;
  if (aw.apps[i].selected)
    aw.n_selections++;
  else
    aw.n_selections--;
}

