#!/usr/bin/nawk -f
#
# 1) get tkusage file from alcatel ( Xmosiac )
# 2) save as file 
# 3) run this script redirecting stdout to name.html
#       tkUsageFaq2html.awk tcl-faq-tk-usage > tk-usage.html
# 4) put html file back in hier
#       mv tk-usage.html ~hops/doc/xmosaic/tcl/tclFAQ/tk/tk-usage.html
# 5) go thru file and hand edit any code segs 




BEGIN   { #template = ARGV[1]    #"../<path>/<name>"
          #ARGV[1] = ""

            print "<HTML>\n"
            count = 0 
            defPrt = 0 
            fromCnt = 0
        }


# suck out bits of the mail header 

/^Subject:/ { 
                gsub("Subject:[ 	]*FAQ:[ 	]*comp.lang.tcl ","")
                print  "<TITLE>" $0 "</TITLE>\n"
                print "<H1>" 
                print "  " $0 
                print "</H1>"
            }

/^Version:/ {
                print "<PRE>"
                print maintainer
                print $0
            } 

/^From:/    {
                if ( fromCnt == 0 )   # Maintainer From: field
                {
                    gsub("From:[ 	]","Faq Maintainer: ")
                    maintainer = $0
                # add parsing to make email hyper link 
                
                fromCnt++
                }
            }


/^From:[ 	]*-/ {      # Questions and answers 
                printf("<A NAME=\"Question%d\">", fromCnt )
                fromCnt++
                gsub("From:[ 	]*-[^-]*-", "");
                print $0

                print "<H3> "
                inQ = 1

                getline         # pickup Subject: Line 
                gsub("Subject:[ 	]*-Q[^-]*-", "");
                print $0
                next
            }


/^Last-modified:/ {
                print $0
                print "</PRE>"
                defPrt = 1
                next
            }        

# empty lines 
/^[ 	]*$/ {
                if ( inQ == 1 )     # End of Question 
                {
                    print "</H3> </A>"
                    print 
                    inQ = 0
                }
                else        # blank line 
                {
                    print
                    printf("<P>")
                    next
                }
             }   

/^-------*/ { 
                print "<HR>"
                next
            }


# start list of questions 
/^Index/ {
                print $0
                print "<UL>"
                next
            }


# Questions - make a link 
/Q[0-9]/    { 
                state = 1
                    # now search for trailing '?'
                count++
                printf("    <LI> <A HREF=\"#Question%d\">\n", count)
            }

$0 ~ /\?\ *$/ && state == 1  {
             state = 0
             print $0
             print "    </A>"
             next
            }

# Otherwise just print it */
defPrt == 1     { print $0 }

END     {   if ( state == 1 ) 
            {
                count++
                print "    </A>"
            }
        }



