.TH xephem 1X
.SH Name
xephem \- an interactive astronomical ephemeris for X
.SH Syntax
\fBxephem\fP
.SH Description
.na
.nh
.PP
.B Xephem
version 2.7
is an interactive astronomical ephemeris program for X Windows
systems. It ...
.IP o
computes heliocentric, geocentric and topocentric information for
celestial objects;
.IP o
has built-in support for all planets; the moons of Jupiter, Saturn and
Earth; and Mars' central meridian longitude;
.IP o
supports user-defined objects in heliocentric or Earth orbit;
.IP o
comes with sample databases of over 20,000 objects in the release kit;
.IP o
can access the Hubble Guide Star Catalog from CD-ROM using
.I gscdbd;
.IP o
can quickly locate all pairs of objects which are closer than a specified
maximum;
.IP o
displays data in configurable tabular forms and in several detailed
graphical formats;
.IP o
can plot and list all data fields to disk files;
.IP o
can be programmed to search for arbitrary circumstances;
.IP o
can serve as the control point for robot telescopes in real-time via
named streams pipes (UNIX fifos).
.SH Getting Started
.PP
.B Xephem
contains extensive context-sensitive on-line help. Virtually none of
that help is duplicated here so go ahead and run
.B xephem
to learn more.
In order for
.B xephem
to find this help text the resource 
.I XEphem.HELPFILE
must
be set properly. If you are running
.B xephem
from the source directory of the
distribution kit this should be set to
.I auxil/xephem.hlp.

When you first run.
.B xephem
you may hear a beep.
This means
.B xephem
has added a message to the message box menu.
This menu is not shown by default.
Whether the message box is displayed may be toggled by using the
.I Messages
entry in the
.I File
pulldown menu off the
.I Main menu.
Whether
.B xephem
beeps when it adds a message may be toggled using the
.I Message Bell
option in the
.I Preferences
pulldown menu.
.SH Quick Menu Tour
.PP
The
.I Help
pulldown at the top right of the main menu provides access to several
categories of assistance applicable to the overall operation of
.B xephem.
Those unfamiliar with
.B xephem
might begin by reading the 
.I Introduction
help section first and reading the additional help information in the
order in which it is listed in the pulldown. 
.I Examples
for several useful operations are now included as well.

The
.I Main menu
of
.B xephem
provides control and display of three basic services: observing circumstances,
looping, and access to additional displays.

Observing circumstances includes location, time and atmospheric conditions
(used for the refraction model). Looping refers to the ability to set up
.B xephem
so that it automatically increments time at a desired step size and rate.

Additional displays provide all of the tabular and graphical information
available, and always refer to the circumstances defined in the main menu.
These additional displays are activated from the 
.I Views
pulldown.

.B Xephem
has information about the Solar system built in and can be accessed without the
need to access an external database. 
.B Xephem
can read files of additional objects into memory as well. Database files
are read in using the
.I Data Base
button in the
.I Objects
pulldown or via the DBFIFO fifo (see the Help for the Data Base menu for more
details on formats and the fifo). All of the information about each object in
memory may be inspected and manipulated in detail and assigned to so-called
`user defined objects' X and Y using the
.I ObjX, ObjY
button in the same pulldown.

All of the data that 
.B xephem
presents in numeric form may be written to a file and later plotted; written
to a file as a tabular listing; or used to formulate an arbitrary
mathematical expression that may be solved for a maximum, minimum or zero.
These facilities are accessed from the
.I Control
pulldown.

Several options related to performance and display formatting may be controlled
from the
.I Preferences
pulldown.

The
.I Files
pulldown in the main menu allows one to reset the main menu from the initial
resource settings; toggle whether the general messages menu is displayed; and
quit the program.
.SH X Resources
.PP
.B Xephem
has many X resources, some of which you will soon want to tune to your
taste and circumstances; many others may be left unchanged. Look through the
.I XEphem.ad
sample distribution for full details. If no resources are available
.B
xephem
contains internal fallback resources that are suitable for a
black-and-white X terminal.

Of course, in addition to all the custom resources,
.B xephem
supports
the usual Xt command line arguments such as -display, -xrm, -synchronous, -fg
and -bg.

The application class of
.B xephem
is
.I XEphem.

A list of widgets in
.B xephem
would be enormous. If you really want such
a list, build
.B xephem
to use the
.I editres
protocol then inspect the widget hierarchy using the standard X tool
.I editres.
The necessary code to support the editres protocol is already in
.I xephem.c
surrounded by #ifdef WANT_EDITRES.
.SH Time zones
.PP
If __STDC__ was defined by the compiler when
.B xephem
was compiled and at runtime
the gmtime() ANSI C function returns non-NULL, then
.B xephem
will attempt to
support time zone control. The time zone name and offset is obtained from the
operating system whenever the "Now" option is used from the various Main menu
time fields or resources or at each time step if Auto Time Zone mode is in
effect. Otherwise,
.B xephem
never attempts to automatically change the
time zone name or offset. In any case, the time zone offset and name may always
be set manually at any time from the Main menu, or they may be initialized from
the XEphem.TZName and XEphem.TZone resources, respectively.
.SH Files and Fifos
.PP
.B Xephem
can use and create several files and communicate via several fifos.
The following table lists the name of the defining resource, the default value
and a short description of each. Full details for each may be found in the
appropriate run-time Help available from within
.B xephem.
Also look in the sample application defaults file, 
.I XEphem.ad,
for examples of settings these and many other resources. The initial default
settings define everything relative to the source tree directory of the
.B xephem
distribution kit. Many file names may begin with tilde (~) to refer to
the user's HOME directory.
.na
.nf

X Resource Name          Default                Usage
---------------          -------                -----
List*Filename.value      work/ephem.lst         Listing file
Plot*Filename.value      work/ephem.plt         Plot file
DBFIFO                   fifos/xephem_db_fifo   auto database input
DBdirectory              edb                    database directory
DBinitialFiles           basic.edb              db files auto loaded
DBpattern                *.edb                  datebase file pattern
HELPFILE                 auxil/xephem.hlp       Help text
SITESFILE                auxil/xephem_sites     Earth view sites
SKYINFIFO                fifos/xephem_in_fifo   Sky View aim input
SKYLOCFIFO               fifos/xephem_loc_fifo  Sky View Button2 report
SKYOUTFIFO               fifos/xephem_out_fifo  Sky View re-aim output
.SH Author
.PP
Elwood Downey, ecdowney@noao.edu. Although they graciously provide me with
email and other services, neither I nor
.B xephem
are associated in any way with
the National Optical Astronomical Observatory.
.SH References
.PP
.B Ephem
is the ancestor of
.B xephem.
It is suitable for "dumb" 24x80 character displays,
including VMS and DOS as well as UNIX.
The latest version may be found on at
.I ftp://iraf.noao.edu/contrib/xephem/ephem.
.PP
The latest version of
.B Xephem
is maintained at
.I ftp://iraf.noao.edu/contrib/xephem.
Source code, the SAO catalog
and several sample executables are also available near that address.
A WWW page is also available at
.I http://iraf.noao.edu/~ecdowney/xephem.
.PP
The online Help entry
.I on Credits
lists some of the many texts, individuals and organizations that have
contributed to
.B xephem.
