/* file2c.c -- convert a file into C code
 *
 * file2c name <infile >outfile.c
 *
 * file2c is a simple filter that reads a file in Xresource format
 * and writes C code of the form:
 *
 * static char *name = "\
 * <first line of input>\n\
 * <second line of input>\n\
 * ...
 * <last line of input>\n\
 * ";
 *
 * That is, it transforms the input file into a C string.  Special
 * characters in the input are escaped as necessary.  name is
 * specified as the sole command line argument.
 */
#include <stdio.h>
#include <ctype.h>
#include "config.h"

typedef	char	*String;
typedef	int	Bool;

#ifdef	__STDC__
void	write_c_char(int, FILE *);
#else
void	write_c_char();
#endif

char	*PROGNAME;
char	*name;
int	debug = FALSE;
int	indent = 0;

int
main(argc, argv)
int	argc;
char	*argv[];
{
    register int	c;

    PROGNAME = *argv++; argc--;
    if (1 != argc)
	error1("usage: %s name <infile >outfile.c", PROGNAME);
    name = *argv++; argc--;
    printf("/* Generated by %s */\n", PROGNAME);
    printf("static char *%s = \"\\\n", name);
    while(EOF != (c = getchar())) {
	write_c_char(c, stdin);
    }
    printf("\";\n");
    exit(NOERR);
}

void
write_c_char(c, xdp)
int	c;
FILE	*xdp;
{
    switch(c) {
    case '\n':
	printf("\\n\\\n");
	break;

    case '\a':
	putchar('\\');
	putchar('a');
	break;

    case '\b':
	putchar('\\');
	putchar('b');
	break;

    case '\f':
	putchar('\\');
	putchar('f');
	break;

    case '\r':
	putchar('\\');
	putchar('r');
	break;

    case '\t':
	putchar('\\');
	putchar('t');
	break;

    case '\v':
	putchar('\\');
	putchar('v');
	break;

    case '\"':
	putchar('\\');
	putchar('\"');
	break;

    case '\'':
	putchar('\\');
	putchar('\'');
	break;

    case ' ':
	putchar(' ');
	break;

    case '\\':
	putchar('\\');
	putchar('\\');
	break;

    default:
	if (isgraph(c))
	    putchar(c);
	else
	    printf("\\x%x", 0xff & c);
	break;
    }
}
