/* conversion.h -- constants for some miscellaneous type converters	*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

#include "filter.h"

#define	XtRDouble "Double"
/*
 * TIME is an integer type corresponding to position in a data file.
 * Values typed in by the user are converted to TIMEs with the
 * conversions factors t_gain and t_multiplier.  Time is the same
 * thing, except converted to floating point.
 */
#define	XtRTIME "TIME"
#define	XtRTime "Time"
/*
 * Freq is a floating point type.  It scales with 1/(t_gain *
 * t_multiplier).
 */
#define	XtRFreq "Freq"
/*
 * VOLTAGE is an integer type corresponding to values from a data
 * file.  Voltage is the same thing converted to floating point.  For
 * all existing filters Voltage is equivalent to FILTER_VAL.
 */
#define	XtRVOLTAGE "VOLTAGE"
#define	XtRVoltage "Voltage"

#define	XtRFilterChain "FilterChain"
#define	XtRMarkList "MarkList"

/*
 * Xt uses these types, but StringDefs.h doesn't define them.
 */
#define	XtRHDimension "HorizontalDimension"
#define	XtRVDimension "VerticalDimension"

#ifdef	__STDC__
void	add_converters(FILTER *);
void	chg_converters(FILTER *);
String	save_string(String);
String	store_string(String);
void	clear_strings(void);
#else	/* __STDC__ */
void	add_converters();
void	chg_converters();
String	save_string();
String	store_string();
void	clear_strings();
#endif	/* __STDC__ */
