/*-------------------------------------------------------------------------*/
/* xcircuit.h 								   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/*      written by Tim Edwards, 8/20/93    				   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Definition shortcuts 						   */
/*-------------------------------------------------------------------------*/

#define XtnSetArg(a,b)  	XtSetArg(wargs[n], a, b); n++
#define abs(a)			((a) < 0 ? -(a) : (a))
#define sign(a)			((a) <= 0 ? -1 : 1)
#define max(a,b)		((a) < (b) ? (b) : (a))
#define min(a,b)		((a) < (b) ? (a) : (b))
#define Number(a)		(void *)((unsigned short) a)
#define ROT_UNIT (360 / RSTEPS) /* degrees per xcircuit rotational unit */

/*-------------------------------------------------------------------------*/
/* Lengthier define constructs						   */
/*-------------------------------------------------------------------------*/

#define objectdata      areastruct.topobject->thisobject
#define PLIST_INCR(a) \
	a->plist = (genericptr *) realloc (a->plist, \
	(a->parts + 1) * sizeof(genericptr))
#define SELECTTYPE(a)   (*(objectdata->plist + *a))->type
#define SELTOCOLOR(a)	(*(objectdata->plist + *a))->color
#define ENDPART		objectdata->plist + objectdata->parts
#define CONDLASTPART(a) ENDPART - (eventmode == a ? 1 : 0)
#define LASTPART        ENDPART - 1

/* conversions from generic to specific types */
/* specifically, from type (generic *) to type (polyptr), etc. */

#define TOPOLY(a)	(*((polyptr *)a))
#define TOLABEL(a)	(*((labelptr *)a))
#define TOOBJINST(a)	(*((objinstptr *)a))
#define TOARC(a)	(*((arcptr *)a))
#define TOSPLINE(a)	(*((splineptr *)a)) 
#define TOPATH(a)	(*((pathptr *)a))

/* conversions from a selection to a specific type */

#define SELTOPOLY(a)	TOPOLY(objectdata->plist + (*a))
#define SELTOLABEL(a)	TOLABEL(objectdata->plist + (*a))
#define SELTOOBJINST(a)	TOOBJINST(objectdata->plist + (*a))
#define SELTOARC(a)	TOARC(objectdata->plist + (*a))
#define SELTOSPLINE(a)	TOSPLINE(objectdata->plist + (*a))
#define SELTOPATH(a)	TOPATH(objectdata->plist + (*a))

/* creation of new elements */

#define NEW_POLY(a,b) \
	PLIST_INCR(b); \
	a = (polyptr *)b->plist + b->parts; \
	*a = (polyptr) malloc(sizeof(polygon)); \
	(*a)->type = POLYGON
#define NEW_LABEL(a,b) \
	PLIST_INCR(b); \
	a = (labelptr *)b->plist + b->parts; \
	*a = (labelptr) malloc(sizeof(label)); \
	(*a)->type = LABEL
#define NEW_OBJINST(a,b) \
	PLIST_INCR(b); \
	a = (objinstptr *)b->plist + b->parts; \
	*a = (objinstptr) malloc(sizeof(objinst)); \
	(*a)->type = OBJECT
#define NEW_ARC(a,b) \
	PLIST_INCR(b); \
	a = (arcptr *)b->plist + b->parts; \
	*a = (arcptr) malloc(sizeof(arc)); \
	(*a)->type = ARC
#define NEW_SPLINE(a,b) \
	PLIST_INCR(b); \
	a = (splineptr *)b->plist + b->parts; \
	*a = (splineptr) malloc(sizeof(spline)); \
	(*a)->type = SPLINE
#define NEW_PATH(a,b) \
	PLIST_INCR(b); \
	a = (pathptr *)b->plist + b->parts; \
	*a = (pathptr) malloc(sizeof(path)); \
	(*a)->type = PATH
		   
/*-------------------------------------------------------------------------*/

typedef unsigned char		uchar;

typedef struct {
   float x, y;
} XfPoint;

typedef struct {
   long x, y;
} XlPoint;

/*-------------------------------------------------------------------------*/
/* Implementation-specific definitions 					   */
/*-------------------------------------------------------------------------*/

#define LIBS	    2 /* number of library pages 			*/
#define PAGES      10 /* default number of top-level pages 		*/
#define FONTS	   14 /* default number of predefined fonts 		*/
#define SCALEFAC  1.5 /* zoom in/out scaling multiplier 		*/
#define SUBSCALE 0.67 /* ratio of subscript size to normal script size 	*/
#define SBARSIZE   13 /* Pixel size of the scrollbar 			*/
#define RSTEPS     72 /* Number of allowed rotation positions 		*/
#define SPLINESEGS 20 /* Number of points per spline approximation 	*/
#define DELBUFSIZE 10 /* Number of delete events to save for undeleting */
#define MINAUTOSCALE 0.75 /* Won't automatically scale closer than this */

#define TOPLEVEL	0
#define SINGLE		1

#define INTSEGS		(SPLINESEGS - 2)
#define LASTSEG		(SPLINESEGS - 3)

#define TEXTHEIGHT 28 /* Height of xcircuit vectored font at nominal size */
#define HALFHEIGHT 14 /* Half of TEXTHEIGHT */

/*-----------------------------------------------------------------------*/

#define INVRFAC 57.295779       /* 180 / pi */

/*-----------------------------------------------------------------------*/
/* Coordinate scales:  Example:  If a 48-unit grid spacing is equivalent */
/*   to 1/4 inch, then:							 */
/*     (48 xcircunits * INCHSCALE) / 72 = 0.25 inches			 */
/*   where 72 is the number of PostScript units per inch		 */
/*-----------------------------------------------------------------------*/

#define CMSCALE 0.35433071  /* Scale of .5 cm to PostScript units */
#define INCHSCALE 0.375     /* Scale of .25 inches to PostScript units */

/*-------------------------------------------------------------------------*/
/* Event mode definitions (state of drawing area)			   */
/*-------------------------------------------------------------------------*/

#define NORMAL_MODE 	0
#define PRESS_MODE 	1
#define POPUP_MODE	2
#define DELETE_MODE 	3
#define COPY_MODE 	4 
#define COPY2_MODE 	5 
#define PUSH_MODE 	6 
#define EDIT_MODE	7 
#define SELAREA_MODE	8 
#define SELAREA2_MODE   9 
#define DESEL_MODE	10
#define PAN_MODE 	11
#define CATPAN_MODE 	12
#define CATALOG_MODE 	13
#define CATTEXT_MODE	14
#define TEXT0_MODE 	15
#define TEXT2_MODE 	16
#define TEXT3_MODE 	17
#define WIRE_MODE 	18
#define BOX0_MODE 	19
#define BOX_MODE 	20
#define EBOX_MODE	21
#define ARC0_MODE	22
#define ARC_MODE	23
#define EARC_MODE	24
#define SPLINE0_MODE	25
#define SPLINE_MODE	26
#define ESPLINE_MODE	27

/*-------------------------------------------------------------------------*/
/* Text justification styles						   */
/*-------------------------------------------------------------------------*/

#define NOTLEFT		1
#define RIGHT		2
#define NOTBOTTOM	4
#define TOP		8

/*-------------------------------------------------------------------------*/
/* Text script styles						   	   */
/*-------------------------------------------------------------------------*/

#define TEXT_ESC	27  /* escape character for defining text controls */
#define CONTROL_START	32  /* first character used by controls */
#define SUBSCRIPT	32
#define SUPERSCRIPT	33
#define NORMALSCRIPT	34
#define UNDERLINE	35
#define OVERLINE	36
#define NOLINE		37
#define BACKSPACE	38

#define FONT_START	100   /* character of first inline font designator */

/*-------------------------------------------------------------------------*/
/* Reset modes								   */
/*-------------------------------------------------------------------------*/

#define SAVE		1
#define DESTROY		2

/*-------------------------------------------------------------------------*/
/* Coordinate display types						   */
/*-------------------------------------------------------------------------*/

#define DEC_INCH	0
#define FRAC_INCH	1
#define CM		2

/*-------------------------------------------------------------------------*/
/* Library types							   */
/*-------------------------------------------------------------------------*/

#define USERLIB		0
#define LIBRARY		1

/*-------------------------------------------------------------------------*/
/* Box styles								   */
/*-------------------------------------------------------------------------*/

#define NORMAL 0
#define UNCLOSED 1
#define DASHED 2
#define DOTTED 4
#define NOBORDER 8
#define FILLED 16
#define STIP0 32
#define STIP1 64
#define STIP2 128
#define FILLSOLID 224  /* = 32 + 64 + 128 */
#define OPAQUE 256

/*-------------------------------------------------------------------------*/
/* Box edit styles							   */
/*-------------------------------------------------------------------------*/

#define MANHATTAN 1
#define RHOMBOIDX 2
#define RHOMBOIDY 4

/*-------------------------------------------------------------------------*/
/* Arc creation and edit styles						   */
/*-------------------------------------------------------------------------*/

#define CENTER 1
#define RADIAL 2

/*-------------------------------------------------------------------------*/
/* Delete/undelete draw-mode styles					   */
/*-------------------------------------------------------------------------*/

#define ERASE 1
#define DRAW  1

/*-------------------------------------------------------------------------*/
/* Color scheme styles (other than NORMAL)				   */
/*-------------------------------------------------------------------------*/

#define INVERSE		1

/*-------------------------------------------------------------------------*/
/* Cursor definitions 							   */
/*-------------------------------------------------------------------------*/

#define NUM_CURSORS	8

#define ARROW 		appcursors[0]
#define CROSS 		appcursors[1]
#define SCISSORS 	appcursors[2]
#define COPYCURSOR	appcursors[3]
#define EDCURSOR	appcursors[4]
#define TEXTPTR 	appcursors[5]
#define CIRCLE		appcursors[6]
#define QUESTION	appcursors[7]

/*-------------------------------------------------------------------------*/
/* selection-mechanism structures					   */
/*-------------------------------------------------------------------------*/

typedef XPoint* pointlist;
typedef XfPoint* fpointlist;

/*-------------------------------------------------------------------------*/
/* select types */
/*-------------------------------------------------------------------------*/

#define	OBJECT	1
#define LABEL	2
#define POLYGON	4
#define ARC	8
#define SPLINE  16
#define PATH	32
#define ANY	63  /* for selection mechanism only */

/*-------------------------------------------------------------------------*/
/* Vector-drawn font character structure				   */
/*-------------------------------------------------------------------------*/

#define MAXSEGS 29	/* Maximum number of segments per character part */

typedef struct {
   short        width;
   short        parts;
   short        number[3];
   pointlist    points[3];
} alpha, *alphaptr;

/*--------------------------------------------------------------------------*/
/* structures of all the main elements which can be displayed & manipulated */
/*--------------------------------------------------------------------------*/

typedef struct _object *objectptr;

typedef struct {
   uchar	type;		/* type is LABEL, POLYGON, etc., from below */
   short	color;
} generic, *genericptr;		/* (convenience function for retypecasting) */

typedef struct {
   uchar	type;
   short	color;
   XPoint	position;
   short	rotation;
   float	scale;
   objectptr	thisobject;
} objinst, *objinstptr;

typedef struct {
   uchar	type;
   short	color;
   XPoint	position;
   short	rotation;
   float	scale;
   short	justify;
   uchar	*string;
} label, *labelptr;

typedef struct {
   uchar	type;
   short	color;
   short	style;
   float	width;
   short	number;
   pointlist	points;
} polygon, *polyptr;

typedef struct {
   uchar	type;
   short	color;
   short	style;
   float	width;
   XPoint	ctrl[4];
   /* the following are for rendering only */
   XfPoint	points[INTSEGS];
} spline, *splineptr;

typedef struct {
   uchar	type;
   short	color;
   short	style;
   float	width;
   short	radius; 	/* x-axis radius */
   short	yaxis;		/* y-axis radius */
   float	angle1;
   float	angle2;
   XPoint	position;
   /* the following are for rendering only */
   short	number;
   XfPoint	points[RSTEPS + 1];
} arc, *arcptr;

typedef struct {
   uchar	type;
   short	color;
   short	style;
   float	width;
   short	parts;
   genericptr	*plist;		/* to be retypecast to polygon, arc, or spline */
} path, *pathptr;

typedef struct _object {
   char		name[80];
   XPoint	lowerleft;	/* bounding box */
   Dimension	width, height;  /* information  */
   short	parts;
   genericptr	*plist;		/* to be retypecast to label, polygon, etc. */
#ifdef SCHEM
   objectptr	schematic;	/* schematic page support */
#endif
} object;

/*--------------------------------------------------------------------------*/
/* Transformation matrices						    */
/*--------------------------------------------------------------------------*/

typedef struct {
   float a, b, c, d, e, f;
} Matrix;

/*-------------------------------------------------------------------------*/
/* Some convenience functions for matrix manipulation			   */
/*-------------------------------------------------------------------------*/

#define DCTM  &areastruct.MatStack[areastruct.MatStackDepth - 1]
#define DCTM2 &areastruct.MatStack[areastruct.MatStackDepth - 2]
#define UPopCTM() areastruct.MatStackDepth--

/*-------------------------------------------------------------------------*/
/* button tap/press definitions 					   */
/*-------------------------------------------------------------------------*/

#define PRESSTIME	150	/* milliseconds of push to be a "press" */

/*-------------------------------------------------------------------------*/
/* structures for managing the popup prompt widgets 			   */
/*-------------------------------------------------------------------------*/

typedef struct {
   Widget	button;
   int		foreground;
   void		(*buttoncall)();
   void		*dataptr;
} buttonsave;

typedef struct {
   Widget	popup;
   Widget	textw;
   void		(*setvalue)();
   buttonsave	*buttonptr;
   Boolean	fileprompt;
} popupstruct;

typedef struct {
   Widget	textw;
   void		(*setvalue)();
   void		*dataptr;
} propstruct;

/*-------------------------------------------------------------------------*/
/* Initial Resource Management						   */
/*-------------------------------------------------------------------------*/

typedef struct {
   /* color scheme 1 */
   Pixel	fg, bg;
   Pixel	gridpix, snappix, selectpix, axespix;
   Pixel	buttonpix, querypix;
   Pixel	auxpix, barpix;

   /* color scheme 2 */

   Pixel	fg2, bg2;
   Pixel	gridpix2, snappix2, selectpix2, axespix2;
   Pixel	buttonpix2, querypix2;
   Pixel	auxpix2, barpix2;

   int		width, height;
   XFontStruct	*xcfont;
} ApplicationData, *ApplicationDataPtr;

/*-------------------------------------------------------------------------*/
/* Macros for GC color and function handling				   */
/*-------------------------------------------------------------------------*/

#define XTopSetForeground(a) if (a == DEFAULTCOLOR) XSetForeground(dpy, \
	areastruct.gc, FOREGROUND); else XSetForeground(dpy, areastruct.gc, a)

#define XSetXORFg(a,b) if (a == DEFAULTCOLOR) XSetForeground(dpy, \
	areastruct.gc, FOREGROUND ^ b); else XSetForeground(dpy, areastruct.gc,\
	a ^ b)

#define XcSetFunction(z) XSetFunction(dpy, areastruct.gc, z); \
	areastruct.gctype = z

#define XcSetForeground(z) XTopSetForeground(z); areastruct.gccolor = \
	((z) == DEFAULTCOLOR) ? FOREGROUND : (z)

#define XcSetXORFg(y,z) XSetXORFg(y,z); areastruct.gccolor = \
	((y) == DEFAULTCOLOR) ? (FOREGROUND ^ z) : (y ^ z)

/*-------------------------------------------------------------------------*/
/* Structure for maintaining list of colors				   */
/*-------------------------------------------------------------------------*/

typedef struct {
   Widget	cbutton;
   XColor	color;
} colorindex;

/*-------------------------------------------------------------------------*/
/* the main globally-accessible data structure				   */
/* This structure holds all the critical data needed by the drawing window */
/*-------------------------------------------------------------------------*/

typedef struct {

   /* widgets and X11 parameters */
   Widget	area;
   Widget	scrollbarh, scrollbarv;
   GC 		gc;
   int		gccolor, gctype;
   XFontStruct  *textstruct;
   XtIntervalId time_id;

   /* global page parameters */
   short	width, height;
   short	page, pages;
   float	*vscale;	/* pointer to proper scale */
   XPoint	*lowerleft;

   /* per-drawing-page parameters */
   char		**filename;	/* file to save as */
   float	*wirewidth;
   float	*outscale;
   float	*viewscale;
   short	*orient;
   short	*pmode;
   short	*coordstyle;
   XPoint	*drawingscale;
   XPoint	*pcorner;
   XPoint	*pagesize;	/* size of page to print on */

   /* option defaults */
   float	textscale;
   short	psfont;
   short	justify;
   short	style;
   short	color;
   Boolean	manhatn;
   Boolean	boxedit;
   Boolean	snapto;
   short	snapspace;
   Boolean	gridon;
   short	gridspace;
   Boolean	axeson;
   Boolean	invert;

   /* buffers, pages, and associated variables */
   XPoint	save, origin;
   short	selects;
   short	*selectlist;
   objinstptr	topobject;
   objinstptr	*hierarchy;
   short	hlevels;
   short	builtins, userobjs, deletes;
   objectptr	*library, *userlib, *delbuffer, editstack, *pagelist;
   objectptr	libtop[LIBS];
   float	tempvscale, libvscale;
   XPoint	temppcorner, libpcorner;
   Matrix	*MatStack;
   short	MatStackDepth;
   short	editcycle;
} Clientdata, *Clientptr;

/*-------------------------------------------------------------------------*/
