/*-------------------------------------------------------------------------*/
/* menudefs.h								   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Menu Definitions for hierarchical pulldown menus                        */
/*-------------------------------------------------------------------------*/

typedef struct _menustruct *menuptr;

typedef struct _menustruct {
        char *name;
        menuptr submenu;
        short size;
        void (*func)();
        void *passeddata;
} menustruct;

/*-------------------------------------------------------------------------*/
/* Functions declared externally to the menu structures			   */
/* (A list of every function called from the menu buttons)		   */
/*-------------------------------------------------------------------------*/

extern Clientdata areastruct;
extern object	areaobject;

extern void DoNothing(), toggle(), getint(), getfloat(), quit();
extern void getstr(), drawarea(), zoomin(), zoomout(), centerpan();
extern void startdelete(), startcatalog(), drawuser(), placedot();
extern void startbox(), startcopy(), starttext(), getfile();
extern void zoomview(), saveas(), startarc(), sethjust(), setvjust();
extern void getfill(), getset(), getopaque(), join();
extern void addnewfont(), setfont(), fontstyle(), newpagemenu();
extern void getline(), startpush(), popobject(), resetbutton(), gettsize();
extern void selectsave(), subscript(), dooutput(), undelete(), getosize();
extern void getwirewidth(), getwwidth(), getlib(), savelib(), getuserlib();
extern void startdesel(), starthelp(), getdscale(), startspline();
extern void getgridtype(), zoombox(), startedit(), startman(), boxedit(); 
extern void inversecolor(), addnewcolor(), setcolor();
#ifdef MATLAB_3X
extern void getmat3();
#endif
#ifdef LGF
extern void getlgf();
#endif

/*-------------------------------------------------------------------------*/
/* Hierarchical menus must be listed in bottom-up order			   */
/*-------------------------------------------------------------------------*/
/* Note:  underscore (_) before name denotes a color to paint the button.  */
/*	  colon (:) before name denotes a stipple, defined by the data	   */
/*		    passed to getfill().				   */
/*-------------------------------------------------------------------------*/

#define submenu(a)	a, (sizeof (a) / sizeof(menustruct)), DoNothing, NULL
#define action(b,c)	NULL, 0, b, c
#define setaction(b,c)	NULL, 1, b, c
#define noaction	NULL, 0, DoNothing, NULL

/* Things commented out here are reminders of future implementations. */

menustruct Fonts[] = {
	{"Add New Font", action(addnewfont, NULL)},
	{" ", noaction},
        {"Times Roman", action(setfont, Number(0))},
	{"Helvetica", setaction(setfont, Number(4))},
	{"Courier", action(setfont, Number(8))},
	{"Symbol", action(setfont, Number(12))}
};

/* Note the unorthodox passing of integer constants through type pointer */

menustruct FontStyles[] = {
	{"Normal", setaction(fontstyle, Number(0))},
	{"Italic", action(fontstyle, Number(1))},
	{"Bold", action(fontstyle, Number(2))},
	{"BoldItalic", action(fontstyle, Number(3))},
	{" ", noaction},
	{"Subscript", action(subscript, Number(SUBSCRIPT))},
	{"Superscript", action(subscript, Number(SUPERSCRIPT))},
	{"Normalscript", action(subscript, Number(NORMALSCRIPT))},
	{" ", noaction},
	{"Underline", action(subscript, Number(UNDERLINE))},
	{"Overline", action(subscript, Number(OVERLINE))},
	{"No line", action(subscript, Number(NOLINE))},
};

menustruct Justifs[] = {
	{"Left Justified", setaction(sethjust, Number(NORMAL))},
	{"Center Justified", action(sethjust, Number(NOTLEFT))},
	{"Right Justified", action(sethjust, Number(NOTLEFT | RIGHT))},
	{" ", noaction},
	{"Top Justified", action(setvjust, Number(NOTBOTTOM | TOP))},
	{"Middle Justified", action(setvjust, Number(NOTBOTTOM))},
	{"Bottom Justified", setaction(setvjust, Number(NORMAL))},
};
	
menustruct BoxEditStyles[] = {
	{"Manhattan Box Edit", setaction(boxedit, Number(MANHATTAN))},
	{"Rhomboid X", action(boxedit, Number(RHOMBOIDX))},
	{"Rhomboid Y", action(boxedit, Number(RHOMBOIDY))},
	{"Normal", action(boxedit, Number(NORMAL))},
};

menustruct GridStyles[] = {
	{"Decimal Inches", action(getgridtype, Number(DEC_INCH))},
	{"Fractional Inches", setaction(getgridtype, Number(FRAC_INCH))},
	{"Centimeters", action(getgridtype, Number(CM))},
	{" ", noaction},
	{"Drawing Scale", action(getdscale, NULL)},
};

menustruct Pages[] = {
	{"Add New Page", action(newpagemenu, Number(255))},
	{" ", noaction},
	{"Page 1", action(newpagemenu, Number(0))},
	{"Page 2", action(newpagemenu, Number(1))},
	{"Page 3", action(newpagemenu, Number(2))},
	{"Page 4", action(newpagemenu, Number(3))},
	{"Page 5", action(newpagemenu, Number(4))},
	{"Page 6", action(newpagemenu, Number(5))},
	{"Page 7", action(newpagemenu, Number(6))},
	{"Page 8", action(newpagemenu, Number(7))},
	{"Page 9", action(newpagemenu, Number(8))},
	{"Page 10", action(newpagemenu, Number(9))}
};

menustruct BorderStyles[] = {
	{"Linewidth", action(getwwidth, NULL)},
	{" ", noaction},
	{"Solid", setaction(getline, Number(NORMAL))},
	{"Dashed", action(getline, Number(DASHED))},
	{"Dotted", action(getline, Number(DOTTED))},
	{"Unbordered", action(getline, Number(NOBORDER))},
	{" ", noaction},
	{"Closed", action(getset, Number(UNCLOSED))}, 
};

menustruct Colors[] = {
	{"Add New Color", action(addnewcolor, NULL)},
	{" ", noaction},
	{"Inherit Color", setaction(setcolor, Number(1))},
	{"_Black", action(setcolor, NULL)},
	{"_Gray40", action(setcolor, NULL)},
	{"_Gray60", action(setcolor, NULL)},
	{"_Gray80", action(setcolor, NULL)},
	{"_White", action(setcolor, NULL)},
	{"_Red", action(setcolor, NULL)},
	{"_Blue", action(setcolor, NULL)},
	{"_Green", action(setcolor, NULL)},
	{"_Yellow", action(setcolor, NULL)},
	{"_Purple", action(setcolor, NULL)},
	{"_Brown", action(setcolor, NULL)},
	{"_Pink", action(setcolor, NULL)},
	{"_Orange", action(setcolor, NULL)},
	{"_Tan", action(setcolor, NULL)},
	{"_Cyan", action(setcolor, NULL)},
	{"_Magenta", action(setcolor, NULL)},
};

menustruct Stipples[] = {
	{":Black",  action(getfill, Number(FILLED | FILLSOLID))},
	{":Gray12", action(getfill, Number(FILLED | STIP2 | STIP1))},
	{":Gray25", action(getfill, Number(FILLED | STIP2 | STIP0))},
	{":Gray37", action(getfill, Number(FILLED | STIP2))},
	{":Gray50", action(getfill, Number(FILLED | STIP0 | STIP1))},
	{":Gray62", action(getfill, Number(FILLED | STIP1))},
	{":Gray75", action(getfill, Number(FILLED | STIP0))},
	{":Gray87", action(getfill, Number(FILLED))},
	{":White", setaction(getfill, Number(FILLSOLID))},
	{" ", noaction},
	{"Opaque", action(getopaque, Number(OPAQUE))},
};

menustruct TextMenu[] = {
	{"Text Size", action(gettsize, &areastruct.textscale)},
	{"Font", submenu(Fonts)},
	{"Style", submenu(FontStyles)},
	{"Justification (keypad)", submenu(Justifs)},
	{" ", noaction},
	{"Make Label (t)", action(starttext, NULL)},
};

menustruct PolyMenu[] = {
	{"Border", submenu(BorderStyles)},
	{"Fill", submenu(Stipples)},
	{"Color", submenu(Colors)},
	{" ", noaction},
	{"Object size", action(getosize, NULL)},
	{"Manhattan Draw", action(toggle, &areastruct.manhatn)},
	{"Polygon Edit", submenu(BoxEditStyles)},
};


menustruct GridMenu[] = {
	{"Grid", setaction(toggle, &areastruct.gridon)},
	{"Axes", setaction(toggle, &areastruct.axeson)},
	{"Grid spacing", action(getint, &areastruct.gridspace)},
	{"Grid type/display", submenu(GridStyles)},
};

menustruct SnapMenu[] = {
	{"Snap-to", setaction(toggle, &areastruct.snapto)},
        {"Snap spacing", action(getint, &areastruct.snapspace)},
};

menustruct WindowMenu[] = {
	{"Zoom In (Z)", action(zoomin, Number(0))},
	{"Zoom Out (z)", action(zoomout, NULL)},
	{"Zoom Box", action(zoombox, NULL)},
	{"Full View (v)", action(zoomview, Number(1))},
	{"Center Pan (p)",action(centerpan, NULL)},
	{" ", noaction},
	{"Show Library (l)", action(startcatalog, Number(LIBRARY))},
	{"Show User Library (L)", action(startcatalog, Number(USERLIB))},
	{"Goto Page", submenu(Pages)}
};

menustruct QuitMenu[] = {
	{"No Kidding", action(quit, NULL)}
};

menustruct FileMenu[] = {
	{"Read Xcircuit PS", action(getfile, Number(0))},
	{"Import Xcircuit PS", action(getfile, Number(1))},
	{"Write Xcircuit PS", action(dooutput, NULL)},
	{" ", noaction},

/*---------------------------------------------------*/
/* handlers for various input formats		     */

#ifdef LGF
	{"Read LGF", action(getlgf, NULL)},
#endif
#ifdef MATLAB_3X
	{"Read Matlab3.X PS", action(getmat3, NULL)},
#endif
/*---------------------------------------------------*/

	{" ", noaction},
	{"Add To Library", action(getlib, NULL)},
	{"Load User Library", action(getuserlib, NULL)},
	{"Save User Library", action(savelib, NULL)},
	{" ", noaction},
        {"Clear Page", action(resetbutton, NULL)},
	{" ", noaction},
	{"Quit", submenu(QuitMenu)},
};

menustruct OptionMenu[] = {
	{"Alt Colors", action(inversecolor, &areastruct.invert)},
	{"Grid", submenu(GridMenu)},
	{"Snap-to", submenu(SnapMenu)},
	{"Linewidth", action(getwirewidth, &areastruct.wirewidth)},
	{"Elements", submenu(PolyMenu)},
	{" ", noaction},
	{"Help!", action(starthelp, NULL)},
};

menustruct EditMenu[] = {
	{"Delete (d)", action(startdelete, NULL)},
	{"Undelete (u)", action(undelete, Number(DRAW))},
	{"Copy (c)", action(startcopy, NULL)},
	{"Edit (e)", action(startedit, NULL)},
	{"Deselect (x)", action(startdesel, NULL)},
	{"Refresh ( )", action(drawarea, NULL)},
/*	{"Array", noaction}, */
	{"Push selected (>)", action(startpush, NULL)},
	{"Pop hierarchy (<)", action(popobject, Number(0))},
	{" ", noaction},
	{"Make User Object (m)", action(selectsave, NULL)},
	{"Make Arc (a)", action(startarc, NULL)},
	{"Make Box (b)", action(startbox, NULL)},
	{"Make Spline (s)", action(startspline, NULL)},
	{"Join (j)", action(join, NULL)},
};

menustruct TopButtons[] = {
	{"File", submenu(FileMenu)},
	{"Edit", submenu(EditMenu)},
	{"Text", submenu(TextMenu)},
	{"Options", submenu(OptionMenu)},
	{"Window", submenu(WindowMenu)},
};

#undef submenu
#undef action
#undef noaction

/*-------------------------------------------------------------------------*/
