.\" $XConsortium: xbiff.man,v 1.22 94/04/17 20:43:28 gildea Exp $
.\" Copyright (c) 1988  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.TH XBIFF++ 1 "Release 6" "X Version 11"
.SH NAME
xbiff++ \- multimedia mailbox monitor
.SH SYNOPSIS
.B xbiff++
[ \-\fItoolkitoption\fP ... ] [ \fI\-option\fP ... ]
.SH DESCRIPTION
The
.I xbiff++
program displays a little image of a mailbox.  When there is no
new mail, the flag on the mailbox is down.  When mail arrives,
the flag goes up and the mailbox beeps (or optionally plays a
sound on machines running the AudioFile server, HP workstations
with the Audio server, and Sun SPARCstations or HP workstations with
/dev/audio).
It is also possible to have a 
different image displayed depending on who the mail is from (a
picture of their face, for example.)  New mail is defined as messages
without a "Status:" line in the message header.
By default, pressing the left mouse button in the image forces
\fIxbiff++\fP to remember the current size of the mail file as
being the ``empty'' size and to lower the flag. Pressing the
right button causes \fIxbiff++\fP to review all new mail (and play
any sounds which are appropriate). 
.SH OPTIONS
.I Xbiff++
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on the standard error.
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which \fIxbiff++\fP
should update its display.  If the mailbox is obscured and then exposed,
it will be updated immediately.  The default is 30 seconds.
.TP 8
.B \-file \fIfilename\fP
This option specifies the name of the file which should be monitored.  By
default, it watches /usr/spool/mail/\fIusername\fP, where \fIusername\fP
is your login name.
.TP 8
.B \-volume \fIpercentage\fP
This option specifies how loud the bell should be rung or a sound
should be played when new mail comes in.
.TP 8
.B \-shape
This option indicates that the mailbox window should be shaped if masks for
the empty or full images are given.
.TP 8
.B \-soundBindings \fIbinding-list\fP
This option specifies sounds to be played for new messages
whose headers match the given patterns. See the following
description of the soundBindings and faceBindings resources
for the format of the binding-list.
(Note: sounds other than a simple beep only work on machines running the
 AudioFile server, HP Audio server and Suns or HPs with /dev/audio.)
.TP 8
.B \-sound \fIfilename\fP
This option specifies a sound to be played when new mail arrives
and the message header doesn't match one of the given bindings.
(Note: sounds other than a simple beep only work on machines running the
 AudioFile server, HP Audio server and Suns or HPs with /dev/audio.)
.TP 8
.B \-noMailSound \fIfilename\fP
This option specifies a sound to be played when reviewing new
mail and none has arrived.
.TP 8
.B \-faceBindings \fIbinding-list\fP
This option specifies the bitmaps or pixmaps to be shown for new messages
whose headers match the given patterns. See the following
description of the soundBindings and faceBindings resources
for the format of the binding-list.
.TP 8
.B \-face \fIfilename\fP
This option specifies a bitmap to be displayed when new mail arrives
and the message header doesn't match one of the given bindings.
.TP 8
.B \-autoResize
This option says that the \fIxbiff++\fP window should automatically
be resized to be the same size as the bitmap it is currently displaying.
.B \-noAutoResize
The inverse of the \fB\-autoResize\fP option.
.TP 8
.B \-noCaseSensitive
This option says that any uppercase characters in header lines should be 
converted to the lowercase equivalent before being compared to any patterns.
.B \-caseInsensitive
The same as the \fB\-caseSensitive\fP option.
.B \-caseSensitive
The inverse of the \fB\-noCaseSensitive\fP option.
.TP 8
.B \-debug
This option says that a trace of \fIxbiff++\fP operations should be printed
to stderr, to assist in debugging problems with pattern-matching.
.TP 8
.B \-soundPath
This option specifies a colon-separated list of directories which contain
sound files.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xbiff++:
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the mailbox window.
The mailbox is 48 pixels wide and 48 pixels high and will be centered in
the window.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for the foreground of the window.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH X DEFAULTS
The application class name is XBiff.
This program uses the 
.I SSMailbox
widget.
It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B file (\fPclass\fB File)
Specifies the name of the file to monitor.  The default is to watch
/usr/spool/mail/\fIusername\fP, where \fIusername\fP is your login name.
.TP 8
.B checkCommand (\fPclass\fB CheckCommand)
Specifies a shell command to be executed to check for new mail rather than
scanning \fBfile\fP for new messages.  The specified string value is used as the
argument to a \fIsystem\fP(3) call and may therefore contain i/o redirection.
The exit status of the command should indicate the number of
unread messages pending.
By default, no shell command is provided.

This can be pretty useful; with an appropriate shell script, this can be used
to make \fBxbiff++\fP tell you things like, for example, when all of your jobs
have left the print queue, or when a particular user logs on.
.TP 8
.B onceOnly (\fPclass\fB Boolean)
Specifies that the bell is only rung the first time new mail is found
and is not rung again until at least one interval has passed with
no mail waiting.  The window will continue to indicate the presence
of new mail until it has been retrieved.  The default is false.
.TP 8
.B width (\fPclass\fB Width)
Specifies the default width of the mailbox.
.TP 8
.B height (\fPclass\fB Height)
Specifies the default height of the mailbox.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the mail should be checked.
The default is 30.
.TP 8
.B sound (\fPclass\fB Sound)
Specifies the sound to be played for each new message which
doesn't match one of the current sound bindings (see the
soundBindings resource). The value should be the name of the file
for the sound.
.TP 8
.B noMailSound (\fPclass\fB NoMailSound)
Specifies the sound to be played when reviewing new mail and no
new mail has arrived.
The value should be the name of the file
for the sound.
.TP 8
.B useLED (\fPclass\fB Boolean)
If true, then when there is new mail in your inbox, one of the keyboard LEDs
will be lit up.  That LED will be off when there is no new mail.
.B whichLED (\fPclass\fB Integer)
If \fBuseLED\fB is true, then this is the number of the LED to use.
.TP 8
.B soundBindings (\fPclass\fB SoundBindings)
Specifies bindings of specific sound files to patterns which are
matched to lines in the headers of new messages. Currently only
the "From:", "Cc:", "To:", and "Subject:" lines are matched. The value of this
resource is a string which is a comma separated list of bindings.
Each binding is a pattern-sound pair, separated by a vertical bar
("|"). An example binding string is:
.br
.ti +3
"To:.*SunUsers|/usr/sounds/Flourish6.au,From:.*root|/usr/sounds/evil.au."
.br
Note that a "." is used before a wildcard "*". This is required
since the regular expression package used defines "*" to mean
zero or more occurences of the previous regular expression.
.TP 8
.B faceBindings (\fPclass\fB FaceBindings)
Specifies bindings of specific \fBbitmap\fP files to patterns 
which are matched to lines in the headers of new messages.  This is identical
in format to the soundBindings resource.  Only the file corresponding to
the first regexp which matches the message will be shown, so put the 
expressions which you wish to be favored earlier in your bindings.  For
example, if you want a bitmap to be shown for a particular user, and another
bitmap to be shown for mail to a particular mailing list of which you are a
memeber, decide which of the two bitmaps you want to see when both are true,
and place that pattern earlier in your file.

As with many other applications, the directories listed in
the \fB*BitmapFilePath\fP resource will be searched for files when the
file name is not fully qualified.  This resource is a string of 
colon-seperated directories, just like the \fBPATH\fP environment variable.
.TP 8
.B caseSensitive (\fPclass\fB CaseSensitive)
Specifies whether the pattern matching of the soundBindings and faceBindings 
against the message headers should consider the case of characters.  The 
default is ``true'' (which is probably a bad default).
.TP 8
.B volume (\fPclass\fB Volume)
Specifies how loud the bell should be rung or a sound should be played.
The default is 50 percent.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the foreground.
The default is ``black'' since the core default for background is ``white.''
This does not apply when a color image is being displayed.
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background should be reversed.
This doesn't apply when a color image is being displayed.
.TP 8
.B flip (\fPclass\fB Flip)
Specifies whether or not the image that is shown when mail has arrived
should be inverted.  The default is ``true.''  This only applies to the
fullPixmap - if a bitmap from the faceBindings is displayed, it will never
be inverted.
.TP 8
.B fullPixmap (\fPclass\fB Pixmap)
Specifies a bitmap to be shown when new mail has arrived; this bitmap is
used only if the most recent new mail does not match a pattern in the
faceBindings resource.  If you are using faceBindings, this is effectively
the ``unknown sender'' bitmap.
The default is flagup.
.TP 8
.B emptyPixmap (\fPclass\fB Pixmap)
Specifies a bitmap to be shown when no new mail is present.
The default is flagdown.
.TP 8
.B shapeWindow (\fPclass\fB ShapeWindow)
Specifies whether or not the mailbox window should be shaped to the
given fullPixmapMask and emptyPixmapMask.  This has no effect on bitmaps
selected with faceBindings, as there is no way to specify a mask along with
a faceBinding.
The default is false.
.TP 8
.B fullPixmapMask (\fPclass\fB PixmapMask)
Specifies a mask for the bitmap to be shown when new mail has arrived.
This is used only when the fullPixmap is being shown, not when a bitmap
from the faceBindings is being shown.  If the \fBfullPixmap\fP is a color
image, this should still be a bitmap of the appropriate shape.
The default is none.
.TP 8
.B emptyPixmapMask (\fPclass\fB PixmapMask)
Specifies a mask for the bitmap to be shown when no new mail is present.
The default is none.
.TP 8
.B autoResize (\fPclass\fB Boolean)
If true, the \fBxbiff++\fP window will automatically be resized to be the
same size as the bitmap it is displaying.  
.SH ACTIONS
The \fIMailbox\fP widget provides the following actions for use in event
translations:
.TP 8
.B check()
This action causes the widget to check for new mail and display the flag
appropriately.
.TP 8
.B unset()
This action causes the widget to lower the flag until new mail comes in.
.TP 8
.B set()
This action causes the widget to raise the flag until the user resets it.
.TP 8
.B review()
This action causes the widget to review all unread messages. This
includes playing sounds for these messages.
.PP
The default translation is 
.sp
.nf
        <Btn1Down>:  unset()
        <Btn3Down>:  review()
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
the default host and display number.
.TP 8
.B XENVIRONMENT
the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B SOUND_PATH
a list of colon-separated directory names which should be searched
for sound files
.SH "SEE ALSO"
X(1),
xrdb(1),
stat(2)
.SH BUGS
It should be possible to specify a volume for each sound, instead of all
sounds being played at the same volume.  soundBindings should be able to
contain something like "to:.*pattern|/a/b/c/soundfile.au(65)" to play the
specified file at 65 percent.  This number should be multiplied against
the global volume parameter.

Since the soundBindings and faceBindings resources use "|" to separate the
patterns and values, there is no way to use the regexp meaning of "|".

When more than one message is in the mailbox before \fIxbiff++\fP is started, 
and when more than one message is in the mailbox when the user clicks right 
to rescan, the face corresponding to the first message is shown instead of 
the face corresponding to the last one.

We should handle compressed \fB.xbm\fP files.

We should support the \fBUSENIX Face Saver\fP file format, possibly others.

It would be nice if there was an option to have it display a count
of how many messages are in the mailbox, perhaps in the name of
the window, so that it could be shown in a titlebar.

The \fBcheckCommand\fB could be more useful: xbiff should run it with popen()
and parse its output, so that a script can be crafted to show the face of the
user whose job is at the front of the print queue, or the user consuming the
most cpu.

It would be nice if the Review command would display a face for each message,
side by side (so that the entire contents of the mailbox could be seen at
once.)

.SH AUTHOR
Jim Fulton, MIT X Consortium
.br
Additional hacks by Ralph Swick, DEC/MIT Project Athena
.br
Sound hacks by Mike Wagner, Siemens Corporate Research 
<wagner@cadillac.siemens.com>.
.br
Face and color hacks by Jamie Zawinski <jwz@lucid.com>.
.br
Regular expression package from Henry Spencer.
.br
SPARCstation sound playing by Jef Poskanzer with SunOS 4.1 patches from Greg Earle.
.br
AudioFile code adapted from aplay by Dave Glowacki.
HP Audio nd HP /dev/audio code added by Dave Glowacki.
