#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

/* always want this on for xbiff++ */
#define EXTERNAL_VAR

#ifdef EXTERNAL_VAR
extern const char *sound_path;
#endif

#ifndef SOUND_PATH
#define SOUND_PATH	"/usr/sww/lib/sounds/au"
#endif

#ifndef __STDC__
#define const
#endif

const char *
findSoundFile(filename)
const char *filename;
{
  int colon;
  char *next, *spath = NULL;
  static char *default_path = NULL;
  static char fullname[1024];
  struct stat statbuf;

  /* see if this is a valid path */
  if (stat(filename, &statbuf) == 0)
    return(filename);

#ifdef EXTERNAL_VAR
  /* try the global variable first */
  if (!spath && sound_path)
    spath = sound_path;
#endif

  /* now try the SOUND_PATH envvar */
  if (!spath)
    spath = getenv("SOUND_PATH");

  /* finally try the hard-coded path */
  if (!spath) {

    /* create a modifiable version of the hard-coded path */
    if (default_path == NULL) {

      /* create a list of default paths */
      spath = SOUND_PATH;
      default_path = (char *)malloc(strlen(spath)+1);
      if (default_path)
	strcpy(default_path, spath);
    }

    /* use hard-coded path */
    spath = default_path;
  }

  while (spath) {

    next = strchr(spath, ':');
    colon = (next && *next == ':');
    if (colon)
      *next = 0;
    sprintf(fullname, "%s/%s", spath, filename);
    if (colon)
      *next++ = ':';
    if (stat(fullname, &statbuf) == 0)
      return(fullname);
    spath = next;
  }

  return(NULL);
}
