/********************************************************************\
 * PopBox.h -- wrapper for the ComboBox                             *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1997 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
\********************************************************************/

#ifndef __XACC_POP_H__
#define __XACC_POP_H__

#include <Xm/Xm.h>

#include "config.h"

#include "Data.h"

/** STRUCTS *********************************************************/
typedef struct _PopBox PopBox;

/** PROTOTYPES ******************************************************/

PopBox * popBox (Widget, int width, int drop_down_width);
void freePopBox (PopBox *);
void SetPopBox (PopBox *, int, int);
void AddPopBoxMenuItem (PopBox *, char *);

PopBox * actionBox (Widget, int width, int drop_down_width);
PopBox * xferBox (Widget, AccountGroup *, int width, int drop_down_width);

/** GLOBALS *********************************************************/

#endif
