/********************************************************************\
 * AccountMenu.h -- the account menu for xacc (X-Accountant)        *
 *                  (general utility)                               *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1997 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
 *   Author: Rob Clark                                              *
 * Internet: rclark@cs.hmc.edu                                      *
 *  Address: 609 8th Street                                         *
 *           Huntington Beach, CA 92648-4632                        *
\********************************************************************/

#ifndef __XACC_ACCOUNT_MENU_H__
#define __XACC_ACCOUNT_MENU_H__

#include <Xm/Xm.h>

#include "config.h"

#include "Account.h"
#include "Data.h"

typedef struct _accountMenu  AccountMenu;

extern AccountMenu *xaccBuildAccountMenu        (AccountGroup *grp, 
                                                 Widget parent,
                                                 char * label);
extern void         xaccFreeAccountMenu         (AccountMenu  *menu);

extern Widget       xaccGetAccountMenuWidget    (AccountMenu  *menu);
extern Account     *xaccGetAccountMenuSelection (AccountMenu  *menu);
extern void         xaccAccountMenuAddCallback  (AccountMenu  *menu, 
                                                 XtCallbackProc callback,
                                                 XtPointer client_data);


#endif /* __XACC_ACCOUNT_MENU_H__ */

/* ********************** END OF FILE *************************/
