/* xa.h -- main header file for xa */

#define XA_H_ID "$Id: xa.h,v 1.13 1996/05/04 20:02:29 richards Exp $"

/*
 * $Log: xa.h,v $
 * Revision 1.13  1996/05/04 20:02:29  richards
 * moved FAST_MODE macro from here to config.h
 *
 * Revision 1.12  1996/04/19 22:24:23  richards
 * various minor changes to declarations, etc.
 *
 * Revision 1.11  1996/04/05 16:37:38  richards
 * minor changes, including dmalloc support
 *
 * Revision 1.10  1996/03/16 17:10:15  richards
 * renamed xrastool to xa
 * fixed indenting
 * renamed copyright.h to COPYRIGHT.h
 * added CanvasCursor() global
 *
 * Revision 1.9  1996/03/14 22:14:40  richards
 * fixed some #include's
 * added length field to IMAGE_T structure
 * added UseFastQuant and TotalImageMem globals
 * other minor changes
 *
 * Revision 1.8  1996/03/08 21:06:30  richards
 * put user-configurable parameters in new header file config.h
 * fixed some typedef's, etc.
 * added/removed/replaced some global declarations
 *
 * Revision 1.7  1996/02/08 01:49:08  richards
 * removed INNER_CANVAS_BORDER
 * changed minimum dimensions from 64x64 to 80x80
 * rearranged order of some global variables (Cf. params.c)
 * added AllowManualSizing()
 *
 * Revision 1.6  1996/01/30 20:33:34  richards
 * removed #include <xview/cms.h> and added #include <xview/notify.h>
 * added a bunch of helpful color macros
 * added UNDEF_SCALING flag for use in ApplyColorScaling() in subpanel.c
 * added COLOR_T and COLORCELL_T
 * replaced access_time with last_change in Image structure
 * added RawQuery and WaitingForImages flags
 * replaced MakeCms() with InitColors() and InstallCms() with StoreColors()
 * added GetLastChange(), DynamicLoad(), and a few Sun gcc declarations
 *
 * Revision 1.5  1996/01/27 22:41:59  richards
 * changed some comment formats
 * added version.h with VERSION macro
 * added DFLT_FAST_TIMER_SCALE and DFLT_FAST_TIMER_VALUE macros
 * added BACK_KEY macro
 * added more extern's for Sun gcc
 *
 * Revision 1.4  1996/01/25 15:51:41  richards
 * added malloc.h and time.h
 * redefined ERROR as -1 for compatibility with get_file_type()
 * added GAMMA #define
 * added access time field to image structure
 * replaced pixmap field with pixmap/ximage union in image structure
 * fixed type of a few global parameters (int to Bool)
 * added Raw, RawWidth, RawHeight, UsePixmaps global parameters
 * removed TmpXImage global
 * replaced SetFixedSizeItem() declaration with SetSizeItem()
 *
 * Revision 1.3  1996/01/21 21:36:25  richards
 * prototyping, added NewCmap, Sun gcc verbosity fix
 *
 * Revision 1.2  1996/01/18 18:17:57  richards
 * several changes
 *
 * Revision 1.1  1996/01/18 16:56:55  richards
 * Initial revision
 *
 */

#include "COPYRIGHT.h" /* Please read this */
#include "version.h"
#include "config.h"

/* Other header files to include */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <time.h>        /* for time_t */

#include <X11/Xlib.h>

#if defined(ALPHA) || defined(SUN)
#  define SUNOS41 /* To get around a bug in XView base.h */
#endif

#include <xview/xview.h>
#include <xview/panel.h> /* for Panel */

/* Global definitions */

#define NUM_BACKDROPS 9 /* In bitmaps subdirectory */

#define MAX_STR_LEN    256 /* Don't make this any smaller! */

#define MAX_NUM_COLORS 256 /* Don't make this any bigger! */

#ifndef MAXPATHLEN
#  define MAXPATHLEN 1024 /* May be in sys/param.h (BSD), sys/limit.h (SYSV) */
#endif

/* Return values */

#define OK 0
#define ERROR (-1)

/* Handy "types" */

#ifndef Bool
#  define Bool int
#endif

#ifndef TRUE
#  define TRUE 1
#endif

#ifndef FALSE
#  define FALSE 0
#endif

typedef u_char byte;

/* Macros */

#define SQ(x) ((x) * (x))

#define PLURAL(n) ((n) != 1 ? "s" : "")

#define NO_IMAGES (NumImages == 0)

#define UNDEF_IMAGE (Current >= NumImages) /* Safer than checking for NULL */

/* Useful color handling macros */

#define SAME_COLOR(c1, c2)\
  ((c1).r == (c2).r && (c1).g == (c2).g && (c1).b == (c2).b)

#define COPY_COLOR(c1, c2) {\
  (c2).r = (c1).r;\
  (c2).g = (c1).g;\
  (c2).b = (c1).b;\
}

#define SET_GRAY(c, v) {(c).r = (c).g = (c).b = (v);}

#define SET_COLOR(c, R, G, B) {(c).r = (R); (c).g = (G); (c).b = (B);}

#define COLOR_INTEN(c) (SQ((c).r) + SQ((c).g) + SQ((c).b))

#define COLOR_DIST(c1, c2)\
  (SQ((c1).r - (c2).r) + SQ((c1).g - (c2).g) + SQ((c1).b - (c2).b))

/* Definitions for use with main parameters */

#define NO_COMPRESS   0
#define PAIR_COMPRESS 1
#define HIST_COMPRESS 2

#define SRC 0
#define OR  1
#define AND 2
#define XOR 3
#define ERA 4
#define NEG 5

#define FORCE_SIZE -1

#define AUTO  0
#define FULL  1
#define FIXED 2

#define TIMER_US  0
#define TIMER_MS  1
#define TIMER_SEC 2

#define MIN_TIMER_VALUE 1
#define MAX_TIMER_VALUE 999

#define FWD 0
#define REV 1

#define LOOP      0
#define LOOP_BACK 1
#define ONE_WAY   2

#define NO_SCROLLING 1        /* Scrolling should be before resizing */
#define NO_RESIZING  (1 << 1)
#define NO_MOVING    (1 << 2)
#define NO_SCALING   (1 << 3)
#define NO_UPDATES   (1 << 4)
#define NO_BACKDROPS (1 << 5)
#define LOCK_COLORS  (1 << 6)
#define CENTERING    (1 << 7)
#define LIVE_CURSOR  (1 << 8)

#define UNDEF_SCALING (-1) /* Must not be a valid scaling option */

#define BW      0
#define GRAY    1
#define COLOR   2
#define GAMMA	3
#define CUTOFF  4
#define CONTOUR 5
#define RANDOM  6

#define MULT 0
#define DIV  1

/* Miscellaneous */

#define PRIVATE_COLORMAP (CompressOption == NO_COMPRESS)
#define OWN_COLORMAP     (PRIVATE_COLORMAP || NumColorsToCopy > 0)

/* Definition of image data type */

typedef byte DATA_T; /* Assumes 8 bit pixels */

/* Definition of color and colorcell types */

typedef byte COLOR_T; /* Assumes 8 bit primary colors */

typedef struct {
  COLOR_T r, g, b;
} COLORCELL_T;

/* Definition of image structure */

typedef struct {
  char *filename;
  time_t last_change;
  int num_colors;
  COLORCELL_T *colors;
  Bool compressed;
  int w, h;
  u_long l;
  int d;
  DATA_T *data;	/* Temporary storage */
  union { /* Use one or the other, never both... */
    Pixmap pixmap;
    XImage *ximage;
  } mem;
} IMAGE_T;

/* Main parameters, in order of appearance (defaults set in params.c) */

extern Bool NewCmap;          /* TRUE, FALSE */
extern Bool OneCmap;          /* TRUE, FALSE */
extern Bool UseFastQuant;     /* TRUE, FALSE */
extern Bool ShowSubPanel;     /* TRUE, FALSE */
extern Bool Blinking;         /* TRUE, FALSE */
extern Bool Cycling;          /* TRUE, FALSE */
extern int  Options;          /* see MakeSubWindow() */
extern Bool Raw;	      /* TRUE, FALSE */
extern Bool RawQuery;         /* TRUE, FALSE */
extern Bool UsePixmaps;	      /* TRUE, FALSE */
extern Bool VisualLoad;       /* TRUE, FALSE */
extern Bool OneAtATime;       /* TRUE, FALSE */
extern Bool Verbose;          /* TRUE, FALSE */
extern int  Current;          /* Index of current image */
extern int  CompressOption;   /* NO_COMPRESS, HIST_COMPRESS, PAIR_COMPRESS */
extern int  NumColorsToCopy;  /* No. colors to copy from standard colormap */
extern int  Logical;          /* SRC, OR, AND, XOR, ERA, NEG */
extern int  FixedWidth;       /* Image width for AUTO or FIXED sizing */
extern int  FixedHeight;      /* Image height for AUTO or FIXED sizing */
extern int  Sizing;           /* AUTO, FULL, FIXED */
extern int  TimerScale;       /* TIMER_US, TIMER_MS, TIMER_SEC */
extern int  TimerValue;       /* Timer value between MIN and MAX_TIMER_VALUE */
extern int  Direction;        /* FWD, REV */
extern int  CycleOption;      /* LOOP, LOOP_BACK, ONE_WAY */
extern int  BackdropIndex;    /* Index of current backdrop */
extern int  Scaling;          /* BW,GRAY,COLOR,GAMMA,CUTOFF,CONTOUR,RANDOM */
extern int  RedSliderValue;   /* Between 0 and 100 */
extern int  RedSliderScale;   /* MULT, DIV */
extern int  GreenSliderValue; /* Between 0 and 100 */
extern int  GreenSliderScale; /* MULT, DIV */
extern int  BlueSliderValue;  /* Between 0 and 100 */
extern int  BlueSliderScale;  /* MULT, DIV */
extern int  RawWidth;	      /* Fixed image width of any raw files */
extern int  RawHeight;	      /* Fixed image height of any raw files */

/* Other global parameters */

extern Bool   NukeCanvas;       /* TRUE, FALSE */
extern Bool   ForceFirstResize; /* TRUE, FALSE */
extern Bool   StartCycling;     /* TRUE, FALSE */
extern u_long TotalImageMem;    /* Total image memory allocation in bytes */

/* Global description of display/screen (xa.c) */

extern Display *MainDisplay;
extern int MainScreen, ScreenWidth, ScreenHeight, ScreenDepth;
extern Visual *MainVisual;
extern GC MainGC;

/* Other global variables, in file order */

extern Frame BaseFrame;
extern Frame CanvasFrame;
extern Xv_window CanvasWindow;
extern int ScrollMargin;
extern Window CanvasXID;
extern Pixmap Backdrop[NUM_BACKDROPS];
extern GC BackdropGC;
extern Colormap XaColormap;
extern int NumAllocPixels;
extern u_long AllocPixels[MAX_NUM_COLORS];
extern XImage **OldXImagePtr;
extern Panel MainPanel;
extern Bool LoadingDelayedImages;
extern int NumImages;
extern struct itimerval Timer;
extern int NumLockedColors;
extern COLORCELL_T *LockedColors;
extern Frame SubFrame;
extern Panel SubPanel;
extern COLORCELL_T ScaledColors[MAX_NUM_COLORS];
extern int NumDelayedFiles;
extern char **DelayedFilenames;
extern Bool Preprocessing;
extern IMAGE_T *Image[MAX_NUM_IMAGES];

/* Global functions, in file order */

extern void MakeBaseFrame(void);
extern void MakeCanvas(void);
extern void SetScrollbars(int toggle_on);
extern void ShowNewImage(void);
extern void MakeBackdropImages(void);
extern void PaintBackground(void);
extern void AllowManualSizing(Bool flag);
extern void Busy(Bool flag);
extern void InitColors(void);
extern void CompressColors(IMAGE_T *image);
extern void StoreColors(COLORCELL_T colors[], int num_colors);
extern void CopyColors(int n, COLORCELL_T *src, COLORCELL_T *dst);
extern void Reduce24to8(IMAGE_T *image, COLOR_T *rgb);
extern int  LoadData(int num_files, char *filename[], int index);
extern time_t GetLastChange(char *filename);
extern void MakeMainPanel(void);
extern Notify_value DynamicLoad(Notify_client client, Notify_event event,
				Notify_arg arg, Notify_event_type type);
extern void KeyPressed(char c);
extern void UpdateLabels(void);
extern void SetSizeItem(int sizing);
extern void TimerOn(void);
extern void TimerOff(void);
extern void MoveCursorAndCaret(void);
extern void ToggleSizingExposure(int flag);
extern void ReadCmdLine(int argc, char **argv, int *files_start);
extern void Initialize(void);
extern void Quant(IMAGE_T **image, int num_images, COLOR_T *rgb);
extern void SetLogical(void);
extern void SetTimer(void);
extern void SetOptions(int change);
extern void SetBackdrop(void);
extern void SetColorSliderDefaults(void);
extern void SetScaling(void);
extern void MakeSubWindow(void);
extern void UpdateOptionsItem(void);
extern void ToggleScalingExposure(int flag);
extern void ToggleBackdropsExposure(int flag);
extern void ApplyColorScaling(Bool sliders_changed);
extern void SetColorSliders(void);
extern int  ReadGIF(FILE *fp, IMAGE_T *image, Bool save_data,
		    Bool save_colormap);
extern void PointToItem(Frame frame, Rect *item_rect);
extern void Warning(char *msg);
extern void Error(char *msg);

#ifndef HAVE_BASENAME
extern char *basename(char *path);
#endif

/* Following is to keep gcc -Wall happy */

#ifdef __GNUC__

extern int gethostname(char *address, int address_len);
extern pid_t getpid(void);
extern void srand48(long seedval);

#ifdef ALPHA
extern int unlink(const char *path);
#endif /* ALPHA */

#ifdef SUN
extern char _filbuf(FILE *);
extern int fclose(FILE *stream);
extern int fgetc(FILE *stream);
extern int fprintf();
extern int fread(void *ptr, int size, int nitems, FILE *stream);
extern int fscanf();
extern int fseek(FILE *stream, long int offset, int whence);
extern long lrand48();
extern char *mktemp(char *template);
extern int printf();
extern void rewind(FILE *stream);
extern int scanf();
extern void setbuf(FILE *stream, void *buf);
extern int system(char *string);
extern time_t time(time_t *tloc);
#endif /* SUN */

#endif /* __GNUC__ */

/*#include <dmalloc.h>*/ /* Uncomment for dmalloc support */

/*** xa.h ***/
