/*
 * xtutil.c
 */

#include <assert.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>

#include "xtutil.h"

/* Return the top level shell given a widget.  Save the result after
   the first call */
Widget
TopLevel(Widget widget)
{
  Widget parent;
  static Widget top_level = NULL;
  Boolean at_top_level = False;

  if (!top_level)
    {
      if (XtIsTopLevelShell(widget))
	top_level = widget;
      else
	while (1)
	  {
	    parent = XtParent(widget);

	    if (XtIsTopLevelShell(parent))
	      {
		top_level = widget;
		break;
	      }
	    widget = parent;
	  }
    }

  return top_level;
}

/* An XmNpopupCallback for centering dialog boxes relative to TopLevel() */
void
CenterDialogOnce(Widget dialog, XtPointer client_data, XtPointer call_data)
{
  Dimension twidth, theight;
  Position tc_x, tc_y;
  Position tx, ty;
  Dimension width, height;
  
  XtVaGetValues(TopLevel(dialog),
		XmNx, &tx, XmNy, &ty,
		XmNwidth, &twidth, XmNheight, &theight,
		NULL);

  /* find the center position of the parent, the dialog will also
     have this center */
  tc_x = tx + twidth/2; tc_y = ty + theight/2;

  XtVaGetValues(dialog,
		XmNwidth, &width, XmNheight, &height,
		NULL);

  XtVaSetValues(dialog,
		XmNx, (Position) (tc_x - width/2),
		XmNy, (Position) (tc_y - height/2),
		NULL);

  XtRemoveCallback(dialog, XmNpopupCallback, CenterDialogOnce, NULL);
}

/* Convert a color name to a Pixel value */
Pixel
ColorNameToPixel(Widget w, char *color_name)
{
  unsigned long pixel = 0;
  XrmValue from, to;

  from.addr = color_name;
  from.size = strlen(color_name);
  to.addr = NULL;
  to.size = 0;
  if (!XtConvertAndStore(w, XtRString, &from, XtRPixel, &to))
    XtWarning("ColorNameToPixel(): String to Pixel conversion error");
  else
    pixel =  *(Pixel *) to.addr;

  return pixel;
}

/* Convert a font name to a Font */
Font
FontNameToFont(Widget w, char *font_name)
{
  Font font = 0;
  XrmValue from, to;

  from.addr = font_name;
  from.size = strlen(font_name);
  to.addr = NULL;		/* initialize or core dump! */
  to.size = 0;
  if (!XtConvertAndStore(w, XtRString, &from, XtRFont, &to))
    XtWarning("FontNameToFont(): String to Font conversion error");
  else
    font = *(Font *) to.addr;

  return font;
}
