/* Map Widget - a geographic drawing area for Motif
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <assert.h>
#include <unistd.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "Map.h"

#define MAXLINE 256
#define ARRAY_SIZE 10

static int line_count = 0;

#if 0
XmMapGPoint *
ReadGPointArrayFromFile(fp)
{
  /* read from the current point in the file reading point pairs until
     we encounter `end' */
  XmMapGPoint *gp = (XmMapGPoint *) XtMalloc(10 * sizeof(XmMapGPoint));
  int array_size = XtNumber(gp);

  while (fgets(line, MAXLINE - 1, fp) != NULL)
    {
      char *token;
      token = strtok(line, delim);
      gp[i++].lat = atof(token);
      token = strtok(line, delim);
      gp[i].lon = atof(token);
    }

  XtFree((char *) gp);
}
#endif

void
MapEvalFile(Widget w, String fname)
{
#if 0
  FILE *fp;
  char line[MAXLINE];
  char err_msg[MAXLINE];

  fp = fopen(fname, "r");
  if (fp == NULL)
    {
      sprintf(err_msg, "Map: open failed for file `%s'\n", fname);
      XtWarning(err_msg);
      return;
    }

  while (fgets(line, MAXLINE - 1, fp) != NULL)
    {
      const char delim = " ";
      char *token;

      line_count++;

      token = strtok(line, delim);
      if (token == NULL)
	continue;
      else if (!strncmp(token, "#", 1))
	continue;
      else if (!strcmp(token, "map-draw-lines"))
	{
	  /* start out with a small array and expand it if necessary */
	  XmMapGPoint *gp = XtMalloc(ARRAY_SIZE * sizeof(XmMapGPoint));
	  int n = 0;

	  if (fgets(line, MAXLINE - 1, fp) != NULL)
	    {
	      token = strtok(line, delim);
	      if (!strcmp(token, "end"))
		{
		  /* MapDrawLines(map, */
		  XtFree((char *) xp);
		}
	      if (n == (expand_num * ARRAY_SIZE - 1))
		{
		  gp = XtRealloc(2 * XtNumber(gp));
		  
		  token = strtok(line, delim);
		  gp[n].lat = atof(token);
		  token = strtok(NULL, delim);
		  gp[n].lon = atof(token);
		}
	    }

	}
    }

  fclose(fp);
#endif
}
