/*
 * MapDraw.h - internal map drawing
 */

#ifndef _MapDraw_h
#define _MapDraw_h

#include "Map.h"

/* Destroys the current pixmap and creates a new one of size core.width
   and core.height */
extern void MapCreatePixmap(MapWidget mw);

/* Destroys the current graphics context and creates a new one */
extern void MapCreateGC(MapWidget mw);

/* Changes any GC values that are different from inValues of type inMask */
extern void MapChangeGC(Display* dpy, GC gc, XtGCMask inMask,
			XGCValues* inValues);

/* Sets the font in the drawing GC so we can draw strings on the map */
extern void MapSetFont(MapWidget mw);

/* Creates a shared memory image of the correct size */
extern void MapCreateShmImage(MapWidget mw);

/* Copies the pixmap to the basemap image */
extern void MapSetBasemapImage(MapWidget mw);

/* Copies the basemap image to the pixmap (and window if refresh is on) */
extern void MapGetBasemapImage(MapWidget mw);

/* Draws npts points onto the pixmap (and window if refresh is on) using the
   current GC */
extern void MapDrawPoints(MapWidget mw, GC gc, const XmMapGPoint* gpts,
			  Cardinal npts);

/* Draws npts strings at gpts onto the pixmap (and window if refresh is on)
   using the current GC */
extern void MapDrawStrings(MapWidget map, GC gc, const XmMapGPoint* gpts,
			   String *s, Cardinal npts);

/* Draws npts markers of type "markerType" and size "markerSize" onto the
   pixmap (and window if refresh is on) using the current GC */
extern void MapDrawMarkers(MapWidget map, GC gc, const XmMapGPoint* gpts,
			   Cardinal npts, XmMarkerType markerType,
			   Cardinal markerSize);

/* Draws connected lines onto the pixmap (and window if refresh is on) using
   the current GC. Properly handles if the line crosses the 180 degree
   longitude line */
extern void MapDrawLines(MapWidget map, GC gc, const XmMapGPoint* gpts,
			 Cardinal npts);

/* Draws a filled polygon onto the pixmap (and window if refresh is on) using
   the current GC. Does not handle if the polygon crosses the 180 degree
   longitude line */
extern void MapFillPolygon(MapWidget map, GC gc, const XmMapGPoint* gpts,
			   Cardinal npts);

#endif /* _MapDraw_h */
