/*
 * Map.h
 */

#ifndef _Map_h
#define _Map_h

#include <X11/Intrinsic.h>

#ifdef __cplusplus
extern "C" {
#endif

/* resource names */
#define XmNprojection		"projection"
#define XmNcenterLon            "centerLon"

#define XmNmajorGridSize	"majorGridSize"
#define XmNminorGridSize	"minorGridSize"

#define XmNdrawGrid		"drawGrid"
#define XmNdrawCoastline	"drawCoastline"
#define XmNdrawLakes		"drawLakes"
#define XmNdrawRivers		"drawRivers"
#define XmNdrawBoundaries	"drawBoundaries"

#define XmNgridColor		"gridColor"
#define XmNoceanColor		"oceanColor"
#define XmNlandColor	        "landColor"
#define XmNcoastlineColor	"coastlineColor"
#define XmNlakeColor		"lakeColor"
#define XmNriverColor		"riverColor"
#define XmNboundaryColor        "boundaryColor"
#define XmNzoomBoxColor         "zoomBoxColor"

#define XmNmapDir		"mapDir"
#define XmNcoastlinesFile	"coastlinesFile"
#define XmNlakesFile		"lakesFile"
#define XmNriversFile		"riversFile"
#define XmNBoundariesFile	"BoundariesFile"

#define XmNuseShm		"useShm"

#define XmNbeforeResetCallback	"beforeResetCallback"
#define XmNafterResetCallback	"afterResetCallback"

/* resource class names */
#define XmCProjection		"Projection"

#define XmCMajorGridSize	"MajorGridSize"
#define XmCMinorGridSize	"MinorGridSize"
#define XmCCenterLon            "CenterLon"

#define XmCDrawGrid		"DrawGrid"
#define XmCDrawCoastline	"DrawCoastline"
#define XmCDrawLakes		"DrawLakes"
#define XmCDrawRivers		"DrawRivers"
#define XmCDrawBoundaries	"DrawBoundaries"

#define XmCGridColor		"GridColor"
#define XmCOceanColor		"OceanColor"
#define XmCLandColor	        "LandColor"
#define XmCCoastlineColor	"CoastlineColor"
#define XmCLakeColor		"LakeColor"
#define XmCRiverColor		"RiverColor"
#define XmCBoundaryColor	"BoundaryColor"
#define XmCZoomBoxColor         "ZoomBoxColor"

#define XmCMapDir		"MapDir"
#define XmCCoastlinesFile	"CoastlinesFile"
#define XmCLakesFile		"LakesFile"
#define XmCRiversFile		"RiversFile"
#define XmCBoundariesFile	"BoundariesFile"

#define XmCUseShm		"UseShm"

/* XmNprojection has a new enumerated representation type,
   XmRMapProjection.  The enumeration definition and string convertion
   routine are in MapResCvt.[ch] */
/* a new representation type for the projection */
#define XmRMapProjection       "MapProjection"
#define XmRMapMarkerType       "MapMarkerType"

/* enumeration type for markerType resource */
typedef enum {
  XmCIRCLE = 0, XmSQUARE, XmTRIANGLE
} XmMarkerType;

/* the enumeration type for the projection resource */
typedef enum {
  XmCYL_EQDIST_PROJECTION = 0,	/* Equaldistance Cylindrical */
  XmECKERT_VI_PROJECTION,	/* Eckert VI */
  XmHAMMER_PROJECTION,		/* Hammer-Aitoff Equal-Area */
  XmMERCATOR_PROJECTION,
  XmMILLER_PROJECTION,		/* Miller Cylindrical */
  XmMOLLWEIDE_PROJECTION,	/* Mollweide Equal-Area */
  XmORTHOGRAPHIC_PROJECTION,
  XmSINUSOIDAL_PROJECTION,	/* Sinusoidal Equal-Area */
} XmProjection;

/* Class record constants */
extern WidgetClass xmMapWidgetClass;

typedef struct _MapClassRec *MapWidgetClass;
typedef struct _MapRec      *MapWidget;

/*fast subclass define */
#ifndef XmIsMap
#define XmIsMap(w) XtIsSubclass(w, xmMapWidgetClass)
#endif /* XmIsMap */

/* these types are used in the transformations between lat,lon and y,x */
typedef struct {		/* geographic point */
  float lat, lon;		/* always in degrees */
} XmMapGPoint;

/* Refreshes the window with what is in the pixmap */
extern void XmMapRefresh(Widget w);

/* Turns refresh off so that drawing changes only occur to the pixmap and
   not the window */
extern void XmMapRefreshOff(Widget w);

/* Turns refresh on so that drawing changes occur to both the pixmap and
   the window. Also refreshes the window with what is currently in the
   pixmap */
extern void XmMapRefreshOn(Widget w);

/* Resets the map to the default basemap and sets it as the current image */
extern void XmMapReset(Widget w);

/* Sets the current image to what is in the pixmap */
extern void XmMapFreeze(Widget w);

/* Clears the map with the current map image */
extern void XmMapClear(Widget w);

/* Resets the map to the full size */
extern void XmMapUnzoom(Widget w);

/* Draws npts points at gpts with drawingColor */
extern void XmMapDrawPoints(Widget w, XmMapGPoint *gpts, Cardinal npts);

/* Draws npts strings at gpts with drawingColor */
extern void XmMapDrawStrings(Widget w, XmMapGPoint *gpts, String *s,
			     Cardinal npts);

/* Draws npts markers of markerType and markerSize at gpts with drawingColor */
extern void XmMapDrawMarkers(Widget w, XmMapGPoint *gpts, Cardinal npts,
			     XmMarkerType marker_type, Cardinal marker_size);

/* Draws npts lines between gpts points with drawingColor, lineWidth,
   and lineStyle */
extern void XmMapDrawLines(Widget w, XmMapGPoint *gpts, Cardinal npts);

/* polygon fill function */
extern void XmMapFillPolygon(Widget w, XmMapGPoint *gpts, Cardinal npts);

/* Translates a XmMapGPoint coordinate to a XPoint coordinate. Returns FALSE
   if the XPoint is not visible */
extern Boolean XmMapGPointToXPoint(Widget w, const XmMapGPoint *gpt,
				   XPoint* xp);

/* Translates a XPoint coordinate to a XmMapGPoint coordinate. Returns FALSE
   if the translation could not be made */
extern Boolean XmMapXPointToGPoint(Widget w, const XPoint* xp,
				   XmMapGPoint *gpt);

/* Destroy shared memory by hand if necessary */
extern void XmMapDestroyShm(Widget map);

/* Evaluate a Guile scheme file for drawing */
extern void XmMapEvalGuileFile(Widget w, String fname);

extern void XmMapEvalFile(Widget w, String fname);

/* return the drawing GC member of MapRec for use in drawing */
extern GC XmMapGC(Widget map);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _Map_h */
