/*
# X-BASED VECTOR GLOBE PROJECTION
#
#	vgp.h
#
###
#
#  Copyright (c) 1994	Frederick (Rick) A Niles, niles@axp745.gsfc.nasa.gov
#
#			All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/
#define PI            3.14159265359
#define ONE_DEGREE    (180.0/PI)
#define INC           50
#define GLOBEPTS      200
#define IDEN_MAT      {1,0,0,0,1,0,0,0,1}
#define MAXSIZE       10000
#define INIT_SPEED    100
#define MAX_SHORT     32768
#define MAX_SCREEN     2000

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <Xm/Scale.h>

typedef struct {
  double  x;
  double  y;
} DPoint;
/*
 * Assorted information needed to generate and draw the image.
 */
typedef struct {
  int          depth, ncolors;
  GC           gc;
  Pixmap       pix;
  Dimension    width, height;
  double        xyplane[INC][3], xzplane[INC][3], yzplane[INC][3];
  double        rotation[3];
  double        T[3][3], start_T[3][3];
  double        vector[MAXSIZE][3];
  double        zoom;
  DPoint       pan;
  XPoint       start, last;
  long          vec_c;
  long          ana_c;
  Widget       drawing;
  int          ana_delay;
  XtIntervalId iid;
  char         label[80];
} image_data, *image_data_ptr;


typedef struct {
  XPoint  *points;
  int     npoints;
  int     color;
} point_block, *point_block_ptr;

/******************************************/
/******* Function Declarations ************/
/******************************************/

/******* vgp.c ***************************/
int      main        (int, char *[]);
void     init_data   (Widget, image_data_ptr);
void     resize      (Widget, image_data_ptr, caddr_t);
void     full_size   (Widget, image_data_ptr);
void     create_image(Widget, image_data_ptr);
void     draw_to     (Widget, image_data_ptr, Drawable,
		      point_block_ptr *, int);
void     scale_label (image_data_ptr);
Widget   make_slider (Widget, image_data_ptr, char *, void *);
void     slider_moved(Widget, image_data_ptr, XmScaleCallbackStruct *);

XtPointer keybd_event         (Widget, image_data_ptr, XEvent *);
XtPointer start_rubber_band   (Widget, image_data_ptr, XEvent *);
XtPointer track_button1_motion(Widget, image_data_ptr, XEvent *);
XtPointer track_rubber_band   (Widget, image_data_ptr, XEvent *);
XtPointer track_pan_motion    (Widget, image_data_ptr, XEvent *);
XtPointer end_rubber_band     (Widget, image_data_ptr, XEvent *);

void     restart_anim(Widget, image_data_ptr, XmAnyCallbackStruct *);
XtTimerCallbackProc do_animation(image_data_ptr, XtIntervalId *);

FILE    *get_input(int, char*[], image_data_ptr);

/******* rotation.c *********************/
void     create3DSphere    (image_data_ptr);
void     create_rot_matrix (image_data_ptr);
void     screen_to_3D(int, int, double, DPoint, double [3][3], double [3]);
void     TD_to_screen(double [3][3], double, DPoint, double *, 
		      int *, XPoint [], int);
void     move_sphere(image_data_ptr);


/******* Xstuff.c ********************/
void     set_window_size(Widget, image_data_ptr);
void     xor_mode(image_data_ptr, int);
void     clear_pixmap(Widget, image_data_ptr);
void     draw_block_of_lines(Widget, image_data_ptr, Drawable,
			     XPoint [], short);
void     redisplay(Widget, image_data_ptr,
		   XmDrawingAreaCallbackStruct *);
void     draw_rectangle(Widget, image_data_ptr);

/******** math.c *******************/
int      min(int, int);
int      max(int, int);
void     norm_vec(double []);
double   vdot     (double [], double []);
void     vcross   (double [], double [], double []);
void     mtrn(double *, double *, int, int);
void     mmult(double *, double *, double *,
	       short, short, short);
void     create_euler_trans(double [], double, double,
			    double [3][3]);


