/*--------------------------------*-C-*---------------------------------*
 * File:	xset.h
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't try
 * to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * <nation@rocket.sanders.lockheed.com>
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _XSETUP_H
#define _XSETUP_H

#ifdef KANJI
#  define TERM_NAME	"kterm"
#  define APL_CLASS	"XTerm"	/* class name */
#  define APL_NAME	"kxvt"	/* normal name */
#  define APL_SUBCLASS	"KXvt"	/* also check resources under this name */
#else
#  define TERM_NAME	"xterm"
#  define APL_CLASS	"XTerm"	/* class name */
#  define APL_NAME	"rxvt"	/* normal name */
#  define APL_SUBCLASS	"RXvt"	/* also check resources under this name */
#endif

#include "sbar.h"		/* for sbar_t */

#define NEW_NAMES	0	/* don't change these values, they must */
#define NEW_ICON_NAME	1	/* match the normal XTerm convention for */
#define NEW_TITLE_NAME	2	/* interactive name setting */

extern Display		*Xdisplay;
extern XFontStruct	*Xfont;		/* main font structure */
#ifdef KANJI
extern XFontStruct	*Kanjifont;	/* Kanji font structure */
#endif
extern GC		Xgc, Xrvgc;	/* GC for drawing text */
extern int		Xdepth;

extern unsigned char console;
extern unsigned char login_shell;
#ifndef META_ESCAPE
extern unsigned char meta_char;
#endif
#ifdef MAPALERT
extern unsigned char map_alert;
extern KeySym ks_alert;
#endif
#ifdef VISUAL_BELL
extern unsigned char visual_bell;
#endif
extern char *rs_title;		/* window name for titles etc. */
extern char *rs_iconName;	/* name to display in the icon */
extern char *rs_geometry;
extern char *display_name;

#define COLORFG		0
#define COLORBG		1

#define COLOR0		2	/* 0 = black	*/
#define COLOR1		3	/* 1 = red	*/
#define COLOR2		4	/* 2 = green	*/
#define COLOR3		5	/* 3 = yellow	*/
#define COLOR4		6	/* 4 = blue	*/
#define COLOR5		7	/* 5 = magenta	*/
#define COLOR6		8	/* 6 = cyan	*/
#define COLOR7		9	/* 7 = white	*/

#define BOLD0		10	/* 0 = bright black	*/
#define BOLD1		11	/* 1 = bright red	*/
#define BOLD2		12	/* 2 = bright green	*/
#define BOLD3		13	/* 3 = bright yellow	*/
#define BOLD4		14	/* 4 = bright blue	*/
#define BOLD5		15	/* 5 = bright magenta	*/
#define BOLD6		16	/* 6 = bright cyan	*/
#define BOLD7		17	/* 7 = bright white	*/

#define RESTORE_FG	39	/* restore default fg color */
#define RESTORE_BG	49	/* restore default bg color */

#ifdef NO_COLOR
#  define NCOLORS	2
#  undef COLOR0
#  undef BOLD0
#else
#  ifdef USE_FAKE_BOLD
#    undef BOLD0
#    define NCOLORS	10	/* bg, fg, [0-7] */
#  else
#    define NCOLORS	18	/* bg, fg, [0-7], bold 1[0-7] */
# endif
#endif

extern char *rs_color [NCOLORS];
extern unsigned long pixel_colors [NCOLORS];

#ifndef NFONTS
# define NFONTS		5
#endif

#if (NFONTS > 1)
extern KeySym ks_bigfont;
extern KeySym ks_smallfont;
#endif

extern char *rs_font [NFONTS];
#ifdef KANJI
extern char *rs_kfont [NFONTS];
#endif

#ifdef PRINTPIPE
extern char *rs_print_pipe;
extern KeySym ks_printscreen;
#endif
#ifndef NO_MULTIPLE_CLICK
extern char *rs_cutchars;
#endif

extern KeySym ks_pageup;
extern KeySym ks_pagedown;
#ifdef GREEK_SUPPORT
extern KeySym ks_greektoggle;
#endif

#ifdef __cplusplus
extern "C" {
#endif
   extern char *my_basename (const char *string);
   extern void	String2Keysym (KeySym *keysym, char *string);
   extern void	init_display (int argc, char *argv[], char *cmd);
   extern void	resize_window (void);
   extern void	xterm_seq (int op, char *str);
   extern void	print_error (const char *fmt, ...);
   extern void	new_font (int dirn);
   extern void	set_width (unsigned int ncol);
#ifdef __cplusplus
}
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
