/*--------------------------------*-C-*---------------------------------*
 * File:	sbar.c
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't
 * try to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "rxvt.h"
#include <X11/Xlib.h>
#include "xsetup.h"

/*----------------------------------------------------------------------*
 * local variables
 */
#ifdef SCROLLBAR_NONE
void sbar_init (Window win, XGCValues *gcv) {}
#else	/* SCROLLBAR_NONE */

/* compile-time selectable scrollbar widths */

#if (SBAR_WIDTH == 8)
/*----------------------------------------------------------------------*
 * 8 bits
 */
#define stipple_width 8
#define stipple_height 2
static unsigned char stipple_bits[] = {
   0x2a, 0x14};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 8
#define up_height 8
static char up_bits[] = {
   0x00, 0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x00};
#define dn_width 8
#define dn_height 8
static char dn_bits[] = {
   0x00, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00};
#else
#define up_width 8
#define up_height 8
static char up_bits[] = {
   0x00, 0x08, 0x1c, 0x3e, 0x08, 0x08, 0x08, 0x00};
#define dn_width 8
#define dn_height 8
static char dn_bits[] = {
   0x00, 0x08, 0x08, 0x08, 0x3e, 0x1c, 0x08, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#elif (SBAR_WIDTH == 10)
/*----------------------------------------------------------------------*
 * 10 bits
 */
#define stipple_width 10
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x00, 0x54, 0x00};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 10
#define up_height 10
static char up_bits[] = {
   0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00, 0x7c, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00};
#define dn_width 10
#define dn_height 10
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x38, 0x00,
   0x38, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00};
#else
#define up_width 10
#define up_height 10
static char up_bits[] = {
   0x00, 0x00, 0x10, 0x00, 0x38, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0x38, 0x00,
   0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00};
#define dn_width 10
#define dn_height 10
static char dn_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0xfe, 0x00,
   0x7c, 0x00, 0x38, 0x00, 0x10, 0x00, 0x00, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#elif (SBAR_WIDTH == 12)
/*----------------------------------------------------------------------*
 * 12 bits
 */
#define stipple_width 12
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x02, 0x54, 0x01};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 12
#define up_height 12
static char up_bits[] = {
   0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x00, 0x70, 0x00, 0xf8, 0x00,
   0xf8, 0x00, 0xfc, 0x01, 0xfc, 0x01, 0xfe, 0x03, 0xfe, 0x03, 0x00, 0x00};
#define dn_width 12
#define dn_height 12
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x03, 0xfe, 0x03, 0xfc, 0x01, 0xfc, 0x01, 0xf8, 0x00,
   0xf8, 0x00, 0x70, 0x00, 0x70, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00};
#else
#define up_width 12
#define up_height 12
static char up_bits[] = {
   0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa8, 0x00, 0x54, 0x01, 0xaa, 0x02,
   0x54, 0x01, 0x22, 0x02, 0x50, 0x00, 0x20, 0x00, 0x50, 0x00, 0x00, 0x00};
#define dn_width 12
#define dn_height 12
static char dn_bits[] = {
   0x00, 0x00, 0x50, 0x00, 0x20, 0x00, 0x50, 0x00, 0x22, 0x02, 0x54, 0x01,
   0xaa, 0x02, 0x54, 0x01, 0xa8, 0x00, 0x50, 0x00, 0x20, 0x00, 0x00, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#elif (SBAR_WIDTH == 14)
/*----------------------------------------------------------------------*
 * 14 bits
 */
#define stipple_width 14
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x0a, 0x54, 0x05};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 14
#define up_height 14
static char up_bits[] = {
   0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xf0, 0x01,
   0xf0, 0x01, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x07, 0xfc, 0x07, 0xfe, 0x0f,
   0xfe, 0x0f, 0x00, 0x00};
#define dn_width 14
#define dn_height 14
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x0f, 0xfe, 0x0f, 0xfc, 0x07, 0xfc, 0x07, 0xf8, 0x03,
   0xf8, 0x03, 0xf0, 0x01, 0xf0, 0x01, 0xe0, 0x00, 0xe0, 0x00, 0x40, 0x00,
   0x40, 0x00, 0x00, 0x00};
#else
#define up_width 14
#define up_height 14
static char up_bits[] = {
   0x00, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x50, 0x01, 0xa8, 0x02, 0x54, 0x05,
   0xaa, 0x0a, 0x44, 0x04, 0xa2, 0x08, 0x40, 0x00, 0xa0, 0x00, 0x40, 0x00,
   0xa0, 0x00, 0x00, 0x00};
#define dn_width 14
#define dn_height 14
static char dn_bits[] = {
   0x00, 0x00, 0xa0, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x40, 0x00, 0xa2, 0x08,
   0x44, 0x04, 0xaa, 0x0a, 0x54, 0x05, 0xa8, 0x02, 0x50, 0x01, 0xa0, 0x00,
   0x40, 0x00, 0x00, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#elif (SBAR_WIDTH == 15)
/*----------------------------------------------------------------------*
 * 15 bits
 */
#define stipple_width 15
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x0a, 0x54, 0x15};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 15
#define up_height 15
static char up_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xe0, 0x01, 0xe0, 0x01,
   0xf0, 0x03, 0xf0, 0x03, 0xf8, 0x07, 0xf8, 0x07, 0xfc, 0x0f, 0xfc, 0x0f,
   0xfe, 0x1f, 0xfe, 0x1f, 0x00, 0x00};
#define dn_width 15
#define dn_height 15
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x1f, 0xfe, 0x1f, 0xfc, 0x0f, 0xfc, 0x0f, 0xf8, 0x07,
   0xf8, 0x07, 0xf0, 0x03, 0xf0, 0x03, 0xe0, 0x01, 0xe0, 0x01, 0xc0, 0x00,
   0xc0, 0x00, 0x00, 0x00, 0x00, 0x00};
#else
#define up_width 15
#define up_height 15
static char up_bits[] = {
   0x00, 0x00, 0xc0, 0x00, 0xe0, 0x01, 0xf0, 0x03, 0xf8, 0x07, 0xdc, 0x0e,
   0xce, 0x1c, 0xc6, 0x18, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
   0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00};
#define dn_width 15
#define dn_height 15
static char dn_bits[] = {
   0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
   0xc0, 0x00, 0xc6, 0x18, 0xce, 0x1c, 0xdc, 0x0e, 0xf8, 0x07, 0xf0, 0x03,
   0xe0, 0x01, 0xc0, 0x00, 0x00, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#elif (SBAR_WIDTH == 16)
/*----------------------------------------------------------------------*
 * 16 bits
 */
#define stipple_width 16
#define stipple_height 2
static char stipple_bits[] = {
   0xaa, 0x2a, 0x54, 0x15};

#ifndef SCROLLBAR_XTERM
#ifdef SOLID_ARROWS
#define up_width 16
#define up_height 16
static char up_bits[] = {
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0xe0, 0x03,
   0xe0, 0x03, 0xf0, 0x07, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0f, 0xfc, 0x1f,
   0xfc, 0x1f, 0xfe, 0x3f, 0xfe, 0x3f, 0x00, 0x00};
#define dn_width 16
#define dn_height 16
static char dn_bits[] = {
   0x00, 0x00, 0xfe, 0x3f, 0xfe, 0x3f, 0xfc, 0x1f, 0xfc, 0x1f, 0xf8, 0x0f,
   0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x07, 0xe0, 0x03, 0xe0, 0x03, 0xc0, 0x01,
   0xc0, 0x01, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00};
#else
#define up_width 16
#define up_height 16
static char up_bits[] = {
   0x00, 0x00, 0x80, 0x00, 0x40, 0x01, 0xa0, 0x02, 0x50, 0x05, 0xa8, 0x0a,
   0x54, 0x15, 0x8a, 0x28, 0x44, 0x11, 0x82, 0x20, 0x40, 0x01, 0x80, 0x00,
   0x40, 0x01, 0x80, 0x00, 0x40, 0x01, 0x00, 0x00};
#define dn_width 16
#define dn_height 16
static char dn_bits[] = {
   0x00, 0x00, 0x40, 0x01, 0x80, 0x00, 0x40, 0x01, 0x80, 0x00, 0x40, 0x01,
   0x82, 0x20, 0x44, 0x11, 0x8a, 0x28, 0x54, 0x15, 0xa8, 0x0a, 0x50, 0x05,
   0xa0, 0x02, 0x40, 0x01, 0x80, 0x00, 0x00, 0x00};
#endif
#endif	/* ! SCROLLBAR_XTERM */

#endif	/* End Of Extensive Else-If */
/*----------------------------------------------------------------------*/

/* check dimensions */
#if (SBAR_WIDTH != stipple_width)
Error, check stipple width
#endif
#ifndef SCROLLBAR_XTERM
#if (stipple_width != up_width) || (stipple_width != dn_width)
Error, check arrow widths
#endif
#if (up_width != up_height)||(dn_width != dn_height)||(up_width != dn_width)
Error, arrows dimensions must be equal.
#endif
#endif	/* ! SCROLLBAR_XTERM */

/*----------------------------------------------------------------------*/

/*
 * Initialize scrollbar data structures - called just once,
 * gcv already contains foreground, background, font
 */
void
sbar_init (Window win, XGCValues *gcv)
{
   gcv->fill_style = FillOpaqueStippled;

#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_NONE) return;
   if (sbar.type == SBAR_ARROWS)
#endif
     {
#ifndef SCROLLBAR_XTERM
	gcv->stipple = XCreateBitmapFromData (Xdisplay, sbar.up.win,
					      up_bits,
					      up_width,
					      up_height);
	if (!gcv->stipple)
	  {
	     print_error ("can't create bitmap");
	     exit (EXIT_FAILURE);
	  }
	sbar.up.gc = XCreateGC (Xdisplay, win,
				GCForeground|GCBackground|GCFont|
				GCFillStyle|GCStipple,
				gcv);

	gcv->stipple = XCreateBitmapFromData (Xdisplay, sbar.dn.win,
					      dn_bits,
					      dn_width,
					      dn_height);
	if (!gcv->stipple)
	  {
	     print_error ("can't create bitmap");
	     exit (EXIT_FAILURE);
	  }
	sbar.dn.gc = XCreateGC (Xdisplay, win,
				GCForeground|GCBackground|GCFont|
				GCFillStyle|GCStipple,
				gcv);
#endif	/* ! SCROLLBAR_XTERM */
     }

   gcv->stipple = XCreateBitmapFromData (Xdisplay,
					 sbar.sb.win,
					 stipple_bits,
					 stipple_width,
					 stipple_height);
   if (!gcv->stipple)
     {
	print_error ("can't create bitmap");
	exit (EXIT_FAILURE);
     }
   sbar.sb.gc = XCreateGC (Xdisplay, win,
			   GCForeground|GCBackground|GCFont|
			   GCFillStyle|GCStipple,
			   gcv);
   sbar_show (100, 0, 100);
   sbar_down_reset ();
   sbar_up_reset ();
}

/*
 * Redraw scrollbar to show area from
 * low to (low+high) proportional to len
 */
void
sbar_show (int len, int low, int high)
{
   static int olen, otop, obot;		/* old values */
   static int dlen, dtop, dbot;		/* drawn values */
   int y, top, bot;

#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_NONE) return;
#endif

   if (len > 0)
     {
	olen = len;
	otop = (len - (low + high));
	obot = (len - low);
     }

   if ((len >= 0) && (dlen == olen) && (dtop == otop) && (dbot == obot))
     return;

   dlen = olen;
   dtop = otop;
   dbot = obot;

   top = (sbar.h * dtop) / dlen - 1;
   bot = (sbar.h * dbot) / dlen;

   y = 0;
#ifndef SCROLLBAR_XTERM
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     y = sbar.w;
#endif

   if (top > 0)
     XClearArea (Xdisplay, sbar.sb.win,
		 0, y,
		 sbar.w, (top - 1),
		 False);

   if (bot < sbar.h)
     XClearArea (Xdisplay, sbar.sb.win,
		 0, y + bot,
		 sbar.w, (sbar.h - bot),
		 False);

   if (bot > top)
     XFillRectangle (Xdisplay, sbar.sb.win, sbar.sb.gc,
		     0, (y + top),
		     sbar.w, (bot - top));
}

/*
 * Redraw the scrollbar up arrow
 */
void
sbar_up_reset (void)
{
#ifndef SCROLLBAR_XTERM
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     XFillRectangle (Xdisplay, sbar.up.win, sbar.up.gc,
		     0, 0,
		     sbar.w, sbar.w);
#endif
}

/*
 * Redraw the scrollbar down arrow
 */
void
sbar_down_reset (void)
{
#ifndef SCROLLBAR_XTERM
#ifdef SCROLLBAR_ANY
   if (sbar.type == SBAR_ARROWS)
#endif
     XFillRectangle (Xdisplay, sbar.dn.win, sbar.dn.gc,
		     0, 0, sbar.w, sbar.w);
#endif
}

#endif	/* SCROLLBAR_NONE */
/*----------------------- end-of-file (C source) -----------------------*/
