/*--------------------------------*-C-*---------------------------------*
 * File:	netdisp.c
 *
 * support for resolving the actual IP number of the host for remote
 * DISPLAYs.  When the display is local (i.e. :0), we add support for
 * sending the first non-loopback interface IP number as the DISPLAY
 * instead of just sending the incorrect ":0".  This way telnet/rlogin
 * shells can actually get the correct information into DISPLAY for
 * xclients.
 *
 * Copyright 1996	Chuck Blake <cblake@BBN.COM>
 *
 * You can do what you like with this source code as long as you don't try
 * to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "rxvt.h"

/* compile an empty file if this option is disabled. */
#ifdef DISPLAY_ENV_AND_ANSWER_IS_IP

#include <ctype.h>
#include <errno.h>
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* On Solaris link with -lsocket and -lnsl */
#include <sys/types.h>
#include <sys/socket.h>

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if defined (__sun__) && defined (__svr4__)
# include <sys/sockio.h>
# include <sys/byteorder.h>
#endif
#ifdef HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <net/if_arp.h>

/* strerror() */
#if defined (sun) && !defined (SVR4) && !defined (strerror)
extern char *sys_errlist[];
extern int sys_nerr;
#define strerror(n) (((n) >= 0 && (n) < sys_nerr) ? sys_errlist[n] : "error")
#endif

static char *
if_to_addrstr (int skfd, char *ifname)
{
   struct ifreq ifr;
   static char buf [16];
   unsigned long addr;

   strcpy (ifr.ifr_name, ifname);
   if (ioctl (skfd, SIOCGIFADDR, &ifr) < 0)
     {
	buf [0] = '\0';
     }
   else
     {
	struct sockaddr_in *p_addr;
	p_addr = (struct sockaddr_in *) &(ifr.ifr_addr);
	addr = htonl ((unsigned long) p_addr->sin_addr.s_addr);

	/* format the address */
	sprintf (buf, "%d.%d.%d.%d",
		 (int) ((addr >> 24) & 0xFF),
		 (int) ((addr >> 16) & 0xFF),
		 (int) ((addr >> 8 ) & 0xFF),
		 (int) ( addr        & 0xFF));
     }
   return buf;
}

char *
network_display (char * display)
{
   char buf [1024], *ip_quad, *colon, *rval = NULL;
   struct ifconf ifc;
   struct ifreq *ifr;
   int i, n, skfd;

   if (display [0] != ':' && strncmp (display, "unix:", 5) != 0)
     return display;		/* nothing to do */

   colon = strchr (display, ':');	/* find ptr to ':' */

   if ((skfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
      perror ("socket");
      return NULL;
   }
   ifc.ifc_len = sizeof(buf);		/* Get names of all ifaces */
   ifc.ifc_buf = buf;
   if (ioctl (skfd, SIOCGIFCONF, &ifc) < 0) {
      fprintf (stderr, "SIOCGIFCONF: %s\n", strerror (errno));
      return NULL;
   }
   ifr = ifc.ifc_req;
   n = ifc.ifc_len / sizeof(struct ifreq);

   for (i = 0; i < n; ++i, ++ifr) {
      ip_quad = if_to_addrstr (skfd, ifr->ifr_name);
      if (strcmp (ip_quad, "127.0.0.1") && strcmp (ip_quad, "0.0.0.0"))
	break;
   }
   close (skfd);

   if (strlen (ip_quad))
     {
	rval = malloc (strlen (ip_quad) + strlen (colon) + 1);
	if (rval != NULL)
	  sprintf (rval, "%s%s", ip_quad, colon);
     }
   return rval;
}
#endif /* DISPLAY_ENV_AND_ANSWER_IS_IP */
/*----------------------- end-of-file (C source) -----------------------*/
