/*--------------------------------*-C-*---------------------------------*
 * File:	keys.h
 *
 * Compile-time selection of key values.
 * Please leave the top (default) section intact and then undef/define
 * below as you like.
 * ----------------------------------------------------------------------
 * Copyright 1995 mj olesen <olesen@me.QueensU.CA> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _KEYS_H
#define _KEYS_H

/* key-strings */
#define KS_FIND		"\033[1~"	/* Find */
#define KS_INSERT	"\033[2~"	/* Insert */
#define KS_EXECUTE	"\033[3~"	/* Execute */
#define KS_SELECT	"\033[4~"	/* Select */
#define KS_PRIOR	"\033[5~"	/* Page Up */
#define KS_NEXT		"\033[6~"	/* Page Down */

/* if only these keys were standardized <sigh> */
#ifdef LINUX_KEYS
# define KS_HOME	KS_FIND		/* Home */
# define KS_END		KS_SELECT	/* End */
#else
# define KS_HOME	"\033[7~"	/* Home */
# define KS_END		"\033[8~"	/* End */
#endif

#define KS_DELETE	KS_EXECUTE	/* Delete */

/* transmit different information for shift/ctrl cursor keys */
#define CURSOR_SHIFT
#define CURSOR_CTRL

/*----------------------------------------------------------------------*
 * user modifiable section
 */

/* choose one of these three as the Hotkey
 * If you choose `shift', you'll want better bindings for mapAlert
 */
#define HOTKEY meta
/*#define HOTKEY ctrl*/
/*#define HOTKEY shift*/

/* undef and define new key-string values, as desired */

/*#undef KS_DELETE*/
/*#define KS_DELETE	"\177"*/

/*#undef CURSOR_SHIFT*/
/*#undef CURSOR_CTRL*/

#ifdef __sun__
# undef KS_DELETE
# define KS_DELETE	"\177"
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
