/*--------------------------------*-C-*---------------------------------*
 * File:	feature.h
 *
 * Compile-time configuration.
 * Additional compile-time configuration in "defaults.h" and "keys.h"
 * ----------------------------------------------------------------------
 * Copyright 1995,1996
 * mj olesen <olesen@me.QueensU.CA> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _FEATURE_H
#define _FEATURE_H

/*----------------------------------------------------------------------*
 * debugging:
 *
 * #define DEBUG_SCREEN
 *	to do self-check for internal screen corruption
 *
 * #define DEBUG_MALLOC
 *	to do self-check on out-of-bound memory usage
 *
 * #define DEBUG_CMD
 *	to output some data structures of command.c
 *	(eg. key-buffer contents, command line, tty permissions) on stderr
 *
 * #define DEBUG_SELECTION
 *	to use XK_Print to dump information about the current selection
 *
 * #define NDEBUG
 *	to disable whatever assert() macros are used in the code
 *----------------------------------------------------------------------*/
/* #define DEBUG_SCREEN */
/* #define DEBUG_MALLOC */
/* #define DEBUG_CMD */
/* #define DEBUG_SELECTION */
#define NDEBUG

/*----------------------------------------------------------------------*
 * #define PRINTPIPE  "lpr"
 *	to define a printer pipe which will be used for emulation of an
 *	attached vt100 printer
 *----------------------------------------------------------------------*/
/* #define PRINTPIPE	"lpr" */

/*----------------------------------------------------------------------*
 * screen:
 *
 * #define NO_COLOR
 *	to avoid using colors at all - monochrome only
 *
 * #define DOS_VGA_COLORS
 *	to use colors supposed resembling VGA colors
 *
 * #define USE_FAKE_BOLD
 *	to simulate bold foreground by writing fatter characters and
 *	suppress use of BLINK attribute for high intensity background.
 *
 * #define MAX_REFRESH_PERIOD <num>
 *	to limit the number of screenfulls between screen refreshes
 *	during hard & fast scrolling [default 10]
 *
 * #define REFRESH_RESOURCE
 *	to experiment with the refresh period using the
 *	-refresh option and refreshPeriod resource
 *
 * #define NO_SECONDARY_SCREEN
 *	to disable the secondary screen (ESC[?47h / ESC [?47l)
 *
 * ---------------------------------------------------------------------*
 * #define USE_XCOPYAREA
 *
 *	to use XCopyArea (in place of re-draws) to speed up rxvt.  I've
 *	been told this helps with some graphics adapters like the
 *	PC's et4000.
 *	OK, it's good on monochrome Sun-3's that I've tried too.
 *	- RN
 *
 *	NB: this seems to make rxvt look worse and slower too.  It also
 *	destroys information about autowrapped lines (NEW_WRAPTYPE) that
 *	is used by the selection mechanism.
 *	/mjo
 *----------------------------------------------------------------------*/
/* #define NO_COLOR */
/* #define DOS_VGA_COLORS */
/* #define USE_FAKE_BOLD */
/* #define MAX_REFRESH_PERIOD	10 */
/* #define REFRESH_RESOURCE */
/* #define NO_SECONDARY_SCREEN */
/* #define USE_XCOPYAREA */

/*----------------------------------------------------------------------*
 * resources:
 *
 * #define REAL_RESOURCES
 *	to use XGetDefaults()
 *
 * #define FAKE_RESOURCES
 *	to use a substitute for using XGetDefaults().
 *	If all you want to do is put rxvt defaults in ~/.Xdefaults file,
 *	use this, and save 60-160KBytes memory!
 *	[default]
 *
 * #define NO_RESOURCES
 *	to blow off the Xdefaults altogether
 *
 * #define KEYSYM_RESOURCE
 *	to utilize the keysym resource which allows you to define
 *	strings associated with various KeySyms (0xFF00 - 0xFFFF).
 *	Only works with FAKE_RESOURCES.
 *
 * #define XAPPLOADDIR	"/usr/lib/X11/app-defaults"
 *	to define where to find installed application defaults for rxvt
 *	Only used with FAKE_RESOURCES
 *----------------------------------------------------------------------*/
/* #define REAL_RESOURCES */
/* #define FAKE_RESOURCES */
/* #define NO_RESOURCES */
#define KEYSYM_RESOURCE
#ifndef XAPPLOADDIR
/* #define XAPPLOADDIR	"/usr/lib/X11/app-defaults" */
#endif

/*----------------------------------------------------------------------*
 * #define RXVT_GRAPHICS
 *	to use Rob Nation's own graphics mode
 *----------------------------------------------------------------------*/
/* #define RXVT_GRAPHICS */

/*----------------------------------------------------------------------*
 * mouse/selection:
 *
 * #define NO_MOUSE_REPORT
 *	to disable the XTerm mouse report protocol
 *
 * #define NO_MULTIPLE_CLICK
 *	to disable the double/triple click selection support
 *	Integrated by A. Haritsis <ah@doc.ic.ac.uk>
 *	based on code by Edward. Der-Hua Liu, Taiwan
 *
 * #define MULTICLICK_TIME <num>
 *	set delay between multiple click events [default 500]
 *
 * #define SELECTION_REPLACE_NEWLINE
 *	to replace occurrences of newline characters with a carriage return
 *	character for a requested selection.  Seems to be used for Sun.
 *----------------------------------------------------------------------*/
/* #define NO_MOUSE_REPORT */
/* #define NO_MULTIPLE_CLICK */
/* #define MULTICLICK_TIME 500 */
/* #define SELECTION_REPLACE_NEWLINE */

/*----------------------------------------------------------------------*
 * scrollbar:
 *
 * #define SCROLLBAR_XTERM
 *	to only permit the XTerm-style scrollbar (without arrows)
 *
 * #define SCROLLBAR_ARROWS
 *	to only permit the native scrollbar with arrows
 *
 * #define SCROLLBAR_NONE
 *	to remove the scrollbar entirely
 *
 * #define SCROLLBAR_ANY
 *	to have the type of scrollbar run-time selectable
 *
 * If none is defined, SCROLLBAR_XTERM will be automatically defined
 *
 * ---------------------------------------------------------------------*
 * #define SBAR_RIGHT
 *	to have the scrollbar on the right side of the window
 *
 * #define SBAR_WIDTH	<width>
 *	to choose the scrollbar width (values: 8,10,12,14,15,16)
 *	leave undefined to get the default choice [default 12]
 *
 *	a width of 15 should yield a window the same width as xterm
 *
 * #define SOLID_ARROWS
 *	to have (old-style) solid triangular-block arrows
 *----------------------------------------------------------------------*/
/* #define SCROLLBAR_XTERM */
/* #define SCROLLBAR_ARROWS */
/* #define SCROLLBAR_NONE */
/* #define SCROLLBAR_ANY */
/* #define SBAR_RIGHT */
/* #define SBAR_WIDTH 12 */

/*----------------------------------------------------------------------*
 * bell:
 *
 * #define VISUAL_BELL
 *	to enable a visual bell when a bell is received
 *
 * #define MAPALERT
 *	to enable automatic de-iconify when a bell is received
 *----------------------------------------------------------------------*/
#define VISUAL_BELL
/* #define MAPALERT */

/*----------------------------------------------------------------------*
 * keys handling:
 *
 * #define META_ESCAPE
 *	to have Meta (Alt) ALWAYS provide an Escape prefix (most popular)
 *
 * #define WITH_7BIT_MODE
 *	to enable use of 7-bit output, instead of default 8-bit output
 *----------------------------------------------------------------------*/
#define META_ESCAPE
/* #define WITH_7BIT_MODE */

/*----------------------------------------------------------------------*
 * fonts:
 *
 * #define NFONTS 1
 *	to disable multiple fonts (and font toggling)
 *
 * ---------------------------------------------------------------------*
 * #define GREEK_SUPPORT
 *	to include support for the Greek Elot-928 & IBM-437 keyboard
 *	by A. Haritsis <ah@doc.ic.ac.uk>
 *
 * Please read instructions in README.greek
 *	- toggle via keysym: Mode_switch
 *	- redefine via X resource: greektoggle_key
 * ---------------------------------------------------------------------*
 * #define KANJI
 *	to compile with Kanji support
 *	after compilation, rename executable as `kxvt' (or `pxvt')
 *----------------------------------------------------------------------*/
/* #define NFONTS 1 */
/* #define GREEK_SUPPORT */
/* #define KANJI */

/*----------------------------------------------------------------------*
 * #define ENABLE_DISPLAY_ANSWER
 *	to have ESC[7n transmit the display name.  This has been cited
 *	as a potential security hole.
 *
 * #define DISPLAY_ENV_AND_ANSWER_IS_IP
 *	to have DISPLAY and ESC[7n transmit display with an IP number
 *
 * #define ESCZ_RXVT_ANSWER
 *	to have the ESC Z transmit ;2C instead of default ;2c
 *----------------------------------------------------------------------*/
/* #define ENABLE_DISPLAY_ANSWER */
/* #define DISPLAY_ENV_AND_ANSWER_IS_IP */
/* #define ESCZ_RXVT_ANSWER */

/*----------------------------------------------------------------------*
 * utmp:
 *
 * #define UTMP_SUPPORT
 *	for utmp support to update `/etc/utmp' to show rxvt logins.
 *
 * For this to work, there are a few options:
 *	1) make `/etc/utmp' world-writeable
 *	2) Rxvt setuid root (potential security hole - do at your own risk)
 *		suu
 *		chown root.root rxvt
 *		chmod a+s rxvt
 *	3) Rxvt setuid/setgid to match the user/group that owns `/etc/utmp'
 *
 * #define USE_SYSV_UTMP
 * #define USE_BSD_UTMP
 *	to select which style of utmp logging to use
 *	[this should be automated in the future]
 *
 * #define UTMP_FILENAME "/var/adm/utmp"	(Irix, dec alpha)
 * #define UTMP_FILENAME "/var/run/utmp"	(FreeBSD, NetBSD 0.9)
 *	to define where the utmp file is located if it isn't /etc/utmp
 *
 * #define TTYTAB_FILENAME "/etc/ttys"		(FreeBSD, NetBSD 0.9)
 *	for BSD-type systems, to define where the tty table is located
 *	if it isn't /etc/ttytab
 *----------------------------------------------------------------------*/
/* #define UTMP_SUPPORT */
#ifdef UTMP_SUPPORT
/* #define USE_SYSV_UTMP */
/* #define USE_BSD_UTMP */
#ifndef UTMP_FILENAME
/* #  define UTMP_FILENAME	"/var/adm/utmp" */
/* #  define UTMP_FILENAME	"/var/adm/utmp" */
#endif
#ifndef TTYTAB_FILENAME
/* #  define TTYTAB_FILENAME "/etc/ttys" */
#endif
#endif

/*----------------------------------------------------------------------*
 * end of user configuration section -- sort out conflicts
 *----------------------------------------------------------------------*/
/* FREEBSD is also BSD */
#if defined (FREEBSD) && !defined (BSD)
#  define BSD
#endif

#ifdef DOS_VGA_COLORS
#  undef NO_COLOR
#  undef USE_FAKE_BOLD
#endif
#ifdef NO_COLOR
#  undef RXVT_GRAPHICS
#endif

#ifdef NO_RESOURCES
#  undef REAL_RESOURCES
#  undef FAKE_RESOURCES
#else
#  ifdef REAL_RESOURCES
#    undef FAKE_RESOURCES
#  else
#    ifndef FAKE_RESOURCES
#      define FAKE_RESOURCES
#    endif
#  endif
#endif
#ifndef FAKE_RESOURCES
#  undef KEYSYM_RESOURCE
#endif

#ifdef SCROLLBAR_NONE
#  undef SCROLLBAR_ARROWS
#  undef SCROLLBAR_XTERM
#  undef SCROLLBAR_ANY
#else
#  ifndef SCROLLBAR_ANY
#    ifdef SCROLLBAR_XTERM
#      ifdef SCROLLBAR_ARROWS
#	 define SCROLLBAR_ANY
#      endif
#    else
#      ifndef SCROLLBAR_ARROWS
#        define SCROLLBAR_XTERM
#      endif
#    endif
#  endif
#  ifdef SCROLLBAR_ANY
#    undef SCROLLBAR_ARROWS
#    undef SCROLLBAR_XTERM
#  endif
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
