static char rcsid[] = "$Id: resources.c,v 1.8 1995/07/03 09:25:11 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* resource handlers for rtc . using my own converter since Motif 1.1 doesn't have a standard converter

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>


#if NeedFunctionPrototypes
Boolean CvtStringToMsgLevel( Display *dsp, XrmValue *args, Cardinal *nargs, XrmValue *from, XrmValue *to, XtPointer data)
#else
Boolean CvtStringToMsgLevel(dsp,args,nargs,from,to,data)
Display	*dsp;
XrmValue	*args;
Cardinal	*nargs;
XrmValue	*from;
XrmValue	*to;
XtPointer	data;
#endif
{
      static ErrorType result;
      
      if ( *nargs != 0 )
	    XtWarning("String to MsgLevel conversion doesn't require any args");
      
      if ( ! strncasecmp(from->addr, "E", 1 ) ) /* error */
	  result = Error;
      else if ( ! strncasecmp(from->addr, "W", 1)) /* warning */
	    result = Warning;
      else if ( ! strncasecmp(from->addr, "I", 1)) /* info */
	    result = Info;
      else if ( ! strncasecmp(from->addr, "D", 1)) /* diag */
	    result = Diagnostics;
      else {
	    XtDisplayStringConversionWarning(dsp,from->addr,RMsgLevel);
	    return False;
      }
      
      to->size = sizeof( ErrorType );
      *(to->addr) = (long) result ;
      
      return ( True );
      
	    
}

#if NeedFunctionPrototypes
Boolean CvtStringToMsgStyle( Display *dsp, XrmValue *args, Cardinal *nargs, XrmValue *from, XrmValue *to, XtPointer data)
#else
Boolean CvtStringToMsgStyle(dsp,args,nargs,from,to,data)
Display	*dsp;
XrmValue	*args;
Cardinal	*nargs;
XrmValue	*from;
XrmValue	*to;
XtPointer	data;
#endif
{
      static MsgStyle result;
      
      if ( *nargs != 0 )
	    XtWarning("String to MsgStyle conversion doesn't require any args");
      
      if ( ! strncasecmp(from->addr, "S", 1 ) )
	  result = StatusArea;
      else if ( ! strncasecmp(from->addr, "D", 1))
	    result = Dialogs;
      else if ( ! strncasecmp(from->addr, "C", 1))
	    result = Console;
      else {
	    XtDisplayStringConversionWarning(dsp,from->addr,RMsgStyle);
	    return False;
      }
      
      to->size = sizeof( MsgStyle );
      *(to->addr) = (long) result ;
      
      return ( True );
      
	    
}

#if NeedFunctionPrototypes
Boolean CvtStringToUserType( Display *dsp, XrmValue *args, Cardinal *nargs, XrmValue *from, XrmValue *to, XtPointer data)
#else
Boolean CvtStringToUserType(dsp,args,nargs,from,to,data)
Display	*dsp;
XrmValue	*args;
Cardinal	*nargs;
XrmValue	*from;
XrmValue	*to;
XtPointer	data;
#endif
{
      static UserType result;
      
      if ( *nargs != 0 )
	    XtWarning("String to UserType conversion doesn't require any args");
      
      if ( ! strncasecmp(from->addr, "B", 1 ) )
	  result = Beginner;
      else if ( ! strncasecmp(from->addr, "E", 1))
	    result = Expert;
      else {
	    XtDisplayStringConversionWarning(dsp,from->addr,RUserType);
	    return False;
      }
      
      to->size = sizeof( UserType );
      *(to->addr) = (long) result ;
      
      return ( True );
      
	    
}
