static char rcsid[] = "$Id: parse.c,v 1.5 1995/07/03 09:25:09 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* parse.c for rtc --- reads description file

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>
#include <rtc-parseP.h>

int line_num;
FILE	*fp;


#ifdef NeddFunctionPrototypes
void RtcReadDescriptionFile(RTCMaster *master, char *filename)
#else
void RtcReadDescriptionFile(master, filename)
RTCMaster	*master;
char		*filename;
#endif
{

      char	line[MAX_LINE_LEN];
      char	keyword[32];
      int		i;
      RTCObject	*object;
      int	found;
      ObjectReturnType 	object_type;
      static RTCObject *parent = NULL;

      
#ifdef X_NOT_STDC_ENV
      extern int	errno
#endif      

/* reset line_num everytime a file is read */
	  line_num = 1;


      if ( ! strcmp(filename,"-") )
	    fp = (FILE *) stdin;
      else 
	    fp = fopen(filename,"r");
      

      if ( fp == NULL ) {
	    sprintf(line,"rtc --- %s",filename);
	    perror(line);
	    return;
      }
      else {

	    while ( fgets(line,MAX_LINE_LEN,fp) ) { 

		  line_num++;
		  i=0;
		  found = False;
		  
		  if ( sscanf(line,"%s",keyword) < 1 )
			continue ;

		  while( function_lookup[i].keyword != NULL && ! found ) {
	    
			if ( ! strncasecmp(function_lookup[i].keyword,keyword,strlen(function_lookup[i].keyword))) {
		  
			      if ( function_lookup[i].real_object == -1 ) 
				    RtcMsg(master,Error,"%s used at line %d (functionality not compiled in)\n",keyword,line_num);
			      else {
			
				    if ( function_lookup[i].real_object ) {
			      
					  object = (RTCObject *) XtMalloc( sizeof( RTCObject ) );
			      
					  memcpy(object,&function_lookup[i].object,sizeof(RTCObject));  
			      
					  if ( master->objects == NULL )
						master->objects = (RTCObject ** ) XtMalloc( sizeof(RTCObject *) * (master->num_objects+1));
					  else
						master->objects = (RTCObject ** ) XtRealloc( ( void *) master->objects, 
											    sizeof(RTCObject *) * (master->num_objects+1));
			      
					  master->objects[master->num_objects] = object;
			      
					  object->master = master;
			      
					  master->num_objects++;
			      
				    }
				    else {
					  object = NULL;
				    }
			
			
/* call the object specific function to parse the rest of the line */
				    if ( function_lookup[i].object.parse ) {
					  object_type = function_lookup[i].object.parse(master,parent,object,line);
				    
					  switch ( object_type ) {
					     case Parent:
						parent = object;
						break;
					  
					     case Reset:
						parent = NULL; 
						break;
		
					     case ReParent:
						parent = (RTCObject *) object->data ;
						break;
					  
					     case Child:
						break;
					  }
					  
				    }
			
			      }
		  
			      found = 1;
		  
			}
	    
			i++;
	    
		  }
		  
		  if ( !found ) {
		      line[strlen(line)-1] = '\0';
		      fprintf(stderr,"line #%d (%s) not recognised\n",line_num, line);
		  }

	    }		  

	    if ( strcmp(filename,"-" ) )
		  fclose(fp);

      }
      

}


