static char rcsid[] = "$Id: panel-list.c,v 1.5 1995/05/10 09:11:49 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* panel-list.c

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_PANEL


static void rtcListCallback(
#if NeedFunctionPrototypes
			    Widget	widget,
			    RTCObject	*object,
			    XtPointer	call
#endif
			    );

#if NeedFunctionPrototypes
ObjectReturnType RtcParseList(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParseList(master, parent, object, line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{

      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*result,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;
      
      result = strchr(ptr,'=');
      
      if ( result ) {
	    result++;
	    sscanf(result,"%s",keyword);
	    object->command = XtNewString(keyword);

	    result += strlen(keyword);

	    object->data = XtNewString(result);

      }
      else { 
	    RtcMsg(object->master,Error,"No result indicator (=) in line %s\n",line);
	    return ( Child );
	    
      }
      
      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );
      
}


#if NeedFunctionPrototypes
void RtcCreateList(RTCObject *object)
#else
void RtcCreateList(object)
RTCObject	*object;
#endif
{

      Widget	frame,form,label,list;
      XmString	xmstr;
      int	i=0;
      int	n;
      Arg	args[6];
      char	*line,*item,*expand,*def,*def_text=NULL;
      int	num_chars;
      

      frame = XtVaCreateWidget("panel-entry-frame",
			       xmFrameWidgetClass,
			       object->parent->widget,
			       NULL);
      
#ifdef HAVE_MOTIF_1_1
      form = XtVaCreateWidget("panel-entry-form",
			      xmFormWidgetClass,
			      frame,
			      NULL);
#else
      form = frame;
#endif

      xmstr = XmStringCreateLtoR(object->name,"panel-prompt");
	    
      label = XtVaCreateManagedWidget("panel-entry-label",
				      xmLabelGadgetClass,
				      form,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNleftAttachment, XmATTACH_FORM,
				      XmNbottomAttachment, XmATTACH_FORM,
#ifndef HAVE_MOTIF_1_1
				      XmNchildType, XmFRAME_TITLE_CHILD,
#endif
				      XmNlabelString, xmstr,
				      NULL);
      
      XmStringFree(xmstr);


      if ( object->option_mask & DefaultMask ) { 
	    while( object->options[i] ) { 
		  if ( object->options[i]->type == DefaultMask ) {
			def = object->options[i]->value;
			break;
		  }
	    }
	    def_text = RtcExpandShellVariable(def, strlen(def));

      }      

      n=0;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;

#ifdef HAVE_MOTIF_1_1
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
      XtSetArg(args[n], XmNleftWidget, label);n++;
#else
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
#endif
      XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
      
      list = XmCreateScrolledList(form,
				  "panel-entry-label",
				  args,
				  n);


      object->widget = list;

      line = object->data;
      
      while( (num_chars=RtcExtractString(&item,line,"{}")) != 0 ) { 

	    line += num_chars;

	    expand = RtcExpandShellVariable(item, strlen(item));
	    
	    xmstr = XmStringCreateLtoR(expand,"list-items");
	    
	    XmListAddItemUnselected(list,xmstr,0);
	    
	    if ( def_text && !strcmp(expand,def_text)) 
		  XmListSelectPos(list,0,False);
	    
	    XmStringFree(xmstr);
	    
	    XtFree(item);
	    
	    XtFree(expand);
	    

      }
      
      if ( def_text) {
	    XtFree(def_text);
      }
      
      XtAddCallback(list,
		    XmNdefaultActionCallback, 
		    (XtCallbackProc) rtcListCallback, 
		    (XtPointer) object);

      XtAddCallback(list,
		    XmNbrowseSelectionCallback, 
		    (XtCallbackProc) rtcListCallback, 
		    (XtPointer) object);
      

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(list, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

      XtManageChild(list);

#ifdef HAVE_MOTIF_1_1
      XtManageChild(form);
#endif

      XtManageChild(frame);

}


#if NeedFunctionPrototypes
char *RtcListConfig(RTCObject *object, ConfigMaskType what)
#else
char *RtcListConfig(object,what)
RTCObject	*object;
ConfigMaskType	what;
#endif
{

      char 	*item,*def,*def_text;
      XmStringTable	selected;
      int	i=0,n;
      XmString	xmstr;
      
      
      switch ( what ) {

	 case GetResultValue:

	    XtVaGetValues(object->widget,
			  XmNselectedItems, &selected,
			  XmNselectedItemCount,&n,
			  NULL);
	    
	    if ( n ) {
		  if ( XmStringGetLtoR(selected[0],"list-items",&item) )
			return( item );
	    }
	    else 
		  return ( ""  );

	    break;
	    
	 case GetResultName:

	    return( object->command );
	    break;

	 case ResetToDefault:

	    if ( object->option_mask & DefaultMask ) {
		  while( object->options[i] ) { 
			if ( object->options[i]->type == DefaultMask ) {
			      def = object->options[i]->value;
			      def_text = RtcExpandShellVariable(def, strlen(def));
			      xmstr = XmStringCreateLtoR(def_text,"list-items");

			      XmListSelectItem(object->widget,xmstr,False);

			      XtFree( def_text );
			      XmStringFree(xmstr);

			      return ( NULL );
			      
			      break;
			}
		  }
	    }      
	    else 
		  XmListDeselectAllItems(object->widget);
 
	    return ( NULL );
	    break;

	 default:
	    break;
      }
      

      return NULL;

}

#if NeedFunctionPrototypes
static void rtcListCallback(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcListCallback(widget,object,call)
Widget		widget;
RTCObject	*object;
XtPointer	call;
#endif
{


      RtcUpdatePanelStatus(object->parent);
      
}

#endif /* WANT_PANEL */
