static char rcsid[] = "$Id: menu.c,v 1.5 1995/03/17 13:42:49 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* menu.c for rtc --- generates pull-right menus

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#if NeedFunctionPrototypes
ObjectReturnType RtcParseMenu(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseMenu(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				     object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }
 
	    ptr += num_chars;

      }

      sscanf(ptr,"%s",keyword);
 
      object->data = XtNewString(keyword);

      object->parent = parent;
 
      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

       object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;

      return ( Child );
      
}


#if NeedFunctionPrototypes
void	RtcCreateMenu(RTCObject *object)
#else
void RtcCreateMenu(object)
RTCObject	*object;
#endif
{

      int	n;
      Widget	pulldownmenu,button;
      XmString	xmstr ;
      Pixmap pixmap ;
      Arg	args[5];
      Boolean	good_pixmap = False;
      

      n=0;
      pulldownmenu = XmCreatePulldownMenu(object->parent->widget,
					  "pull-down-menu",
					  args,
					  n);
      
      n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object, &pixmap); 

      if ( good_pixmap ) { 
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }
      

      XtSetArg( args[n], XmNsubMenuId, pulldownmenu);n++;

      
      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "menu",
					   args,
					   n);

#ifdef WANT_HELP      
      if ( object->type == HelpMenuType ) {
	      XtVaSetValues(object->parent->widget,
			    XmNmenuHelpWidget,button, 
			    NULL);

	      XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcPostInfoPanel,
			  (XtPointer) object);
      }

      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

      XtManageChild( button );

      object->children[0]->widget = pulldownmenu;
      
      if ( ! good_pixmap ) 
	    XmStringFree(xmstr);

      
}

#if NeedFunctionprototypes
ObjectReturnType RtcParseAddToMenu(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseAddToMenu(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars;
      char	*ptr;
      char	menu[32];
      RTCObject	*re_parent;
      
      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

      sscanf(ptr,"%s %n%s",menu,&num_chars,keyword);
      
      re_parent = RtcGetObjectByName(master,menu,MenuDefType);
   
      if ( re_parent == NULL ) { 
	    RtcMsg(master,Error,"Cannot find Menu %s for AddToMenu",menu);
	    return ( Reset );
      }


      object->data = (char * ) re_parent;

      return( ReParent );
      
}

#if NeedFunctionprototypes
ObjectReturnType RtcParseDeleteFromMneu(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseDeleteFromMenu(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars;
      char	*ptr;
      char	menu[32];
      RTCObject	*re_parent;
      
      
      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

      sscanf(ptr,"%s",menu);
      
      re_parent = RtcGetObjectByName(master,menu,MenuDefType);
   
      if ( re_parent == NULL ) { 
	    RtcMsg(master,Error,"Cannot find Menu %s for AddToMenu",menu);
	    return ( Child );
      }
      
      object->parent = re_parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );
      
}


