static char rcsid[] = "$Id: main.c,v 1.8 1995/07/04 12:26:00 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* main.c for rtc

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

static String	fallbacks[] = {
      ".geometry:			0+0",


      "*XmList.visibleItemCount:	3",

      "*reminder.width:			500", 		

      "*help-text.rows:				20",
      "*help-text.columns:		     40",
      "*help-html.width:		      450",
      "*help-html.height:		     500",
      "*help-html.anchorColor:		red",

      "*quit-dialog.messageString:		Quit rTc ?",
      "*quit-dialog.okLabelString:		Way",
      "*quit-dialog.cancelLabelString:	No Way",
      "*quit-dialog.helpLabelString:	Restart",

      "*reminder*save.labelString:		->",
      "*reminder*edit.labelString:		<-",
      "*reminder*delete.labelString:		Del.",
      "*help-display*OK.labelString:		Dismiss",
      "*help-display*Help.labelString:	       	Top",
      "*panel*OK.labelString:			Execute",
      "*panel*Cancel.labelString:	       	Done",
      "*panel*Help.labelString:			Default",
      NULL,
};


static XtResource resources[] = {
      { "userFile", "UserFile", XmRString, sizeof( String ),
	 XtOffsetOf(struct _resources,userFile), XmRImmediate, SITE_USER_FILE },  
#ifdef WANT_SYSTEM_FILE   
      { "systemFile", "SystemFile", XmRString, sizeof( String ),
	 XtOffsetOf(struct _resources, systemFile), XmRImmediate, SITE_SYSTEM_FILE },  
#endif
      { "vertical", "Vertical", XmRBoolean, sizeof( Boolean ),
	 XtOffsetOf(struct _resources,vertical), XmRString, (XtPointer) "False" }, 

      { "maximumSize", "MaximumSize", XmRBoolean, sizeof( Boolean ),
	 XtOffsetOf(struct _resources,maximumSize), XmRString, (XtPointer) "True" }, 

      { "usage", "Usage", XmRBoolean, sizeof( Boolean ),
	 XtOffsetOf(struct _resources,usage), XmRString, (XtPointer) "False" },
 
#ifdef WANT_CLOCK
      { "reminderFile", "ReminderFile", XmRString, sizeof( String ),
	 XtOffsetOf(struct _resources,reminderFile), XmRImmediate, SITE_REMINDER_FILE },  
#endif
#ifdef WANT_HELP
      { "helpFilePath", "HelpFilePath", XmRString, sizeof( String ),
	 XtOffsetOf(struct _resources,helpFilePath), XmRImmediate, SITE_HELP_PATH },  
#endif
      { "iconFilePath", "IconFilePath", XmRString, sizeof( String ),
	 XtOffsetOf(struct _resources,iconFilePath), XmRImmediate, SITE_ICON_PATH },
  
      { "msgStyle", "MsgStyle", RMsgStyle , sizeof( unsigned char ),
	 XtOffsetOf(struct _resources,msgStyle), XmRImmediate, (XtPointer) StatusArea },
 
      { "msgLevel", "MsgLevel", RMsgLevel , sizeof( unsigned char ),
	 XtOffsetOf(struct _resources,msgLevel), XmRImmediate, (XtPointer) Info  }, 

      { "userType", "UserType", RUserType , sizeof( unsigned char ),
	 XtOffsetOf(struct _resources,userType), XmRImmediate, (XtPointer) Beginner  }, 
#ifdef WANT_MULTI_SCREEN
      { "singleScreen", "SingleScreen", XmRBoolean , sizeof( Boolean ),
	 XtOffsetOf(struct _resources,singleScreen), XmRString, (XtPointer) "False"  }, 
#endif
      { "messageBeep", "MessageBeep", XmRBoolean, sizeof( Boolean ),
	 XtOffsetOf(struct _resources,messageBeep), XmRString, "False" },  
      { "messageBeepVolume", "MessageBeepVolume", XmRInt, sizeof( int ),
	 XtOffsetOf(struct _resources,messageBeepVolume), XmRString, "50" },  
      { "messageBeepDuration", "MessageBeepDuration", XmRInt, sizeof( int ),
	 XtOffsetOf(struct _resources,messageBeepDuration), XmRString, "25" }, 
 
      { "executeBeep", "ExecuteBeep", XmRBoolean, sizeof( Boolean ),
	 XtOffsetOf(struct _resources,executeBeep), XmRString, "False" },  
      { "executeBeepVolume", "ExecuteBeepVolume", XmRInt, sizeof( int ),
	 XtOffsetOf(struct _resources,executeBeepVolume), XmRString, "20" },  
      { "executeBeepDuration", "ExecuteBeepDuration", XmRInt, sizeof( int ),
	 XtOffsetOf(struct _resources,executeBeepDuration), XmRString, "10" },  
};

static XrmOptionDescRec options[] = {      
      { "--user-file", "userFile", XrmoptionSepArg, NULL
	},
      { "-f", "userFile", XrmoptionSepArg, NULL
	},
      { "--icon-file-path", "iconFilePath", XrmoptionSepArg, NULL
	},
      { "--console", "msgStyle", XrmoptionNoArg, "Console"
	},
      { "--dialogs", "msgStyle", XrmoptionNoArg, "Dialogs"
	},
      { "--status-area", "msgStyle", XrmoptionNoArg, "StatusArea"
	},
      { "--error", "msgLevel", XrmoptionNoArg, "Error"
	},
      { "--warn", "msgLevel", XrmoptionNoArg, "Warning"
	},
      { "--info", "msgLevel", XrmoptionNoArg, "Info"
	},
      { "--diag", "msgLevel", XrmoptionNoArg, "Diag"
	},
      { "--beginner", "userType", XrmoptionNoArg, "Beginner"
	},
      { "--expert", "userType", XrmoptionNoArg, "Expert"
	},
      { "--minimum-size", "maximumSize", XrmoptionNoArg, "False"
	},
      { "--single", "singleScreen", XrmoptionNoArg, "True"
	},
      { "--mbeep", "messageBeep", XrmoptionNoArg, "True"
	},
      { "--ebeep", "executeBeep", XrmoptionNoArg, "True"
	},
      { "--no-mbeep", "messageBeep", XrmoptionNoArg, "False"
	},
      { "--no-ebeep", "executeBeep", XrmoptionNoArg, "False"
	},
      { "--usage", "usage", XrmoptionNoArg, "True"
	},
      { "--help", "usage", XrmoptionNoArg, "True"
	},
      { "-help", "usage", XrmoptionNoArg, "True"
	},
#ifdef WANT_SYSTEM_FILE
      { "--system-file", "systemFile", XrmoptionSepArg, NULL
	},
#endif
#ifdef WANT_CLOCK
      { "--reminder-file", "reminderFile", XrmoptionSepArg, NULL
	},
#endif
#ifdef WANT_HELP
      { "--help-file-path", "helpFilePath", XrmoptionSepArg, NULL
	},
#endif
};


XtAppContext	AppContext;
Widget		TopLevel,MsgArea=NULL;


int main(argc,argv,environ)
int	argc;
char	**argv;
char	**environ;
{


      RTCMaster	*master;
      Display	*dpy;
#ifdef WANT_MULTI_SCREEN
      char	**sargs, display[128], scn[4];
      int	i,pid;
#endif


      master = RtcInit();
/* have to copy the calling args, before X can get its thieving hands on my data */      
      master->argv = (char **) XtMalloc( sizeof(char*) * argc);

      memcpy(master->argv, argv, sizeof(char *) * argc);
      master->argc = argc;


#ifndef HAVE_X11R4
      XtSetLanguageProc(NULL,NULL,NULL);
#endif

#ifndef HAVE_X11R6

      TopLevel = XtVaAppInitialize(&AppContext,"Rtc",
				   options,XtNumber(options),
				   (Cardinal *) &argc,argv,
				   fallbacks,
				   NULL);

      
  
#else
      
      TopLevel = XtVaOpenApplication(&AppContext,
				     "Rtc",
				     options,
				     XtNumber(options),
				     &argc,
				     argv,
				     fallbacks,
				     sessionShellWidgetClass,
				     NULL);
      
#endif

/* install resource converters */
      XtSetTypeConverter(XmRString,
			 RMsgLevel,
			 (XtTypeConverter) CvtStringToMsgLevel,
			 (XtConvertArgList) NULL, 0,
			 XtCacheAll,
			 (XtDestructor) NULL);
      
      XtSetTypeConverter(XmRString,
			 RMsgStyle,
			 (XtTypeConverter) CvtStringToMsgStyle,
			 (XtConvertArgList) NULL, 0,
			 XtCacheAll,
			 (XtDestructor) NULL);
      
      XtSetTypeConverter(XmRString,
			 RUserType,
			 (XtTypeConverter) CvtStringToUserType,
			 (XtConvertArgList) NULL, 0,
			 XtCacheAll,
			 (XtDestructor) NULL);
      

      XtVaGetApplicationResources(TopLevel,
				  (XtPointer) &master->resources,
				  resources, XtNumber(resources),
				  NULL);



      if ( master->resources.usage) {
	    fprintf(stderr,
"rTc Usage....\n\n\
Cmd Line Arg.                      Default\n\
--user-file <file>                 %s\n\
--system-file <file>               %s\n\
--reminder-file <file>             %s\n\
--help-file-path <dir/:dir/: ...>  %s\n\
--icon-file-path <dir/:dir/: ...>  %s\n\n\
rTc requires a description file (%s)\n",
		    master->resources.userFile,
#ifdef WANT_SYSTEM_FILE
		    master->resources.systemFile,
#else
		    "(no support)",
#endif
#ifdef WANT_CLOCK
		    master->resources.reminderFile,
#else
		    "(no support)",
#endif
#ifdef WANT_HELP
		    master->resources.helpFilePath,
#else
		    "(no support)",
#endif
		    master->resources.iconFilePath,
		    master->resources.userFile);

	    fflush(stderr);
	    exit(0);
      }
      

      dpy = XtDisplay(TopLevel);
      
#ifdef WANT_MULTI_SCREEN

/* in an ideal world, we would only have one process that talked to
   multiple displays, perhaps in version 3.0 :-) 
*/

      if ( ! master->resources.singleScreen ) {

	  sargs = (char **) XtMalloc(sizeof(char *) * 9);

	  sargs[0] = argv[0];
	  sargs[1] = XtNewString("--single");
	  sargs[2] = XtNewString("-d");
	  sargs[4] = XtNewString("--user-file");
	  sargs[5] = XtNewString(master->resources.userFile);
#ifdef WANT_SYSTEM_FILE
	  sargs[6] = XtNewString("--system-file");
	  sargs[7] = XtNewString(master->resources.systemFile);
#else
	sargs[6] = NULL;
#endif	  
	  sargs[8] = NULL;

	  for ( i=0; i< ScreenCount(dpy); i++ ) { 

	      if ( i != DefaultScreen(dpy) ) { 

		  strcpy(display,XDisplayString(dpy));
		  display[strlen(display) - 1 ] = '\0';
		  sprintf(scn,"%d",i);
		  strcat(display,scn);
		  sargs[3] = XtNewString(display);

		  pid = fork();

		  if ( pid == 0 ) {
		      char  disp[128];

		      sprintf(disp,"DISPLAY=%s",display);
		      if ( putenv(disp) )
			  RtcMsg(master, Error, "Failed to set DISPLAY to  on %s\n",display);
		      
		      execvp(sargs[0],sargs);

/* if we get here then something is screwed */
		      RtcMsg(master, Error, "Failed to start rtc on %s\n",display);
		      
		  }
	      }
	  }

	  XtFree((char *) sargs);

      }
#endif	    

      master->display = XtNewString(XDisplayString(dpy)); 

      if ( master->resources.maximumSize ) {
	    if ( master->resources.vertical ) { 
		  XtVaSetValues(TopLevel,
				XmNheight,HeightOfScreen(XtScreen(TopLevel)-2),  /* -2 to allow for the shadow, hack */
				NULL);
	    }
	    else {
		  XtVaSetValues(TopLevel,
				XmNwidth,WidthOfScreen(XtScreen(TopLevel))-2,
				NULL);
	    }	
      }	

      if ( master->resources.userType == (unsigned char) Beginner ) {
	    master->resources.msgLevel = Error;
      }


#ifdef WANT_SYSTEM_FILE
/* undocumented hack */
      if ( strcmp("--",master->resources.systemFile) )
	   RtcReadDescriptionFile(master, master->resources.systemFile);
#endif
      if ( strcmp("--",master->resources.userFile) )
	    RtcReadDescriptionFile(master, master->resources.userFile);


      if ( master->num_objects == 0 ) {
	    RtcMsg(master,Error,"No Descriptions. Exiting\n");
	    exit(1);
      }

      RtcFixupObjectHierarchy(master);

      RtcMakeGUI(master);

#ifdef WANT_EDITRES
      XtAddEventHandler(TopLevel,
			0,
			True, 
			_XEditResCheckMessages,
			NULL);
#endif

      XtRealizeWidget(TopLevel);
      XtAppMainLoop(AppContext);
      

      return( 0 );
      
}

