static char rcsid[] = "$Id: exit.c,v 1.6 1995/03/27 12:49:03 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* f.exit functions

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>


void rtcExit(
#if needFunctionPrototypes
		      Widget	widget,
		      RTCObject	*object,
		      XtPointer	call
#endif
		      );


void rtcReallyExit(
#if needFunctionPrototypes
		      Widget	widget,
		      RTCObject	*object,
		      XtPointer	call
#endif
		      );

void rtcRestart(
#if needFunctionPrototypes
                 Widget	widget,
                 RTCObject	*object,
                 XtPointer	call
#endif
    );



#if NeedFunctionPrototypes
ObjectReturnType RtcParseExit(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseExit(master,parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			fprintf(stderr,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      fprintf(stderr,"%d ",
				      object->options[i]->type);

			      i++;
			}

			fprintf(stderr,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );

}




#if NeedFunctionprototypes
void RtcCreateExit(RTCObject *object)
#else
void RtcCreateExit(object)
RTCObject	*object;
#endif
{

      XmString	xmstr = NULL;
      Widget	button;
      Pixmap	pixmap;
      Boolean	good_pixmap = False;
      Arg	args[5];
      int	n;
      
      
     n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object,&pixmap);

      if ( good_pixmap ) {
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {	 
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }
      

      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "exit",
					   args,
					   n);

      XtAddCallback(button, 
		    XmNactivateCallback, 
		    (XtCallbackProc) rtcExit,
		    (XtPointer) object);
      
#ifdef WANT_HELP      
      if ( object->option_mask & HelpMask ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

      XtManageChild( button );

      if ( xmstr ) 
	    XmStringFree(xmstr);
  

}

#if NeedFunctionPrototypes
void rtcExit(Widget widget, RTCObject *object, XtPointer call)
#else
void rtcExit(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{
      Widget  confirm;
      int     n;
      Arg     args[5];
      extern Widget TopLevel;
      

      n=0;
      XtSetArg( args[n], XmNtitle, "Quit rTc ?");n++;

      confirm = XmCreateQuestionDialog(TopLevel,
				       "quit-dialog",
				       args,
				       n);

      XtAddCallback(confirm, XmNokCallback, (XtCallbackProc) rtcReallyExit, (XtPointer) object);
      XtAddCallback(confirm, XmNcancelCallback, (XtCallbackProc) RtcDestroyDialog, (XtPointer) confirm);
      XtAddCallback(confirm, XmNhelpCallback, (XtCallbackProc) rtcRestart, (XtPointer) object);


      XtManageChild(confirm);
  
}

#if NeedFunctionPrototypes
void rtcReallyExit(Widget widget, RTCObject *object, XtPointer call)
#else
void rtcReallyExit(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{
#ifdef FIND_MEM_LEAKS
    int	i;
    RTCMaster	*master = object->master;

/* free off as much space as possible so leaks can be found easier */

    for ( i=0; i< master->num_objects; i++ ) {
	fprintf(stderr,"Freeing %s\n",master->objects[i]->name);

	RtcFreeObject(master->objects[i]);
    }
#endif
    exit(0);
    
}


#if NeedFunctionPrototypes
void rtcRestart(Widget widget, RTCObject *object, XtPointer call)
#else
void rtcRestart(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{

    char	**argv;

    argv  = (char **) XtMalloc(sizeof(char *) * (object->master->argc + 3));

    memcpy(argv,object->master->argv,sizeof(char *) * object->master->argc);
 
    argv[object->master->argc] = "-d";
    argv[object->master->argc+1] = object->master->display;
    argv[object->master->argc+2] = "--single";
    argv[object->master->argc+3] = NULL;
    

    XCloseDisplay(XtDisplay(widget));

    execvp(argv[0],argv);
/* if we get here, something cocked up */

    RtcMsg(object->master, Error, "Failed to restart rtc, help\n");


}
