/* defines and enum's used in rtc

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: rtc-defines.h,v 1.3 1995/07/03 09:24:39 richardo Exp $

*/

#ifndef RTC_DEFINES_H
#define RTC_DEFINES_H

typedef enum {
      MenuDefType=1<<0,
      EndMenuType=1<<1,
      PanelDefType=1<<2,
      EndPanelType=1<<3,
      ButtonType=1<<4,
      MenuType=1<<5,
      PanelType=1<<6,
      LabelType=1<<7,
      SeparatorType=1<<8,
      ExitType=1<<9,
      InfoType=1<<10,
#ifdef WANT_CLOCK
      ClockType=1<<11,
#endif
#ifdef WANT_HELP
      HelpTextDefType=1<<12,
      HelpMenuType=1<<13,
      HelpTextType=1<<14,
      HelpFileType=1<<15,
      HelpContextType=1<<16,
#endif
#ifdef WANT_MAILBOX_WATCHER
      MailBoxType=1<<17,
#endif
#ifdef WANT_DISK_WATCHER
      DiskSpaceType=1<<18,
#endif
#ifdef WANT_PANEL
      TextType=1<<19,
      ListType=1<<20,
      FileType=1<<21,
      ToggleType=1<<22,
      CommandType=1<<23,
      ScaleType=1<<24,
#endif
      AddToMenuType=1<<25,
      DeleteFromMenuType=1<<26,
#ifdef WANT_URL	    
      UrlType=1<<27,	    
#endif
      CommentType=1<<28
} ObjectType;


typedef enum {
      Reset,
      Parent,
      Child,
      ReParent
} ObjectReturnType;

/* option mask variables */

typedef enum {
      HelpMask=1<<0,
      IconFileMask=1<<1,
      TimeMask=1<<2,
      NumExecMask=1<<3,
      DefaultMask=1<<4,
      HelpFileMask=1<<5
} OptionType;

typedef enum {
      StartUp=0,
      Error=1,
      Warning=2,
      Info=3,
      Diagnostics=4
} ErrorType;

typedef enum {
      StatusArea=0,
      Dialogs=1,
      Console=2
} MsgStyle;

typedef enum {
      Beginner=0,
      Expert=1
} UserType;



typedef enum {
      GetResultValue=1<<0,
      GetResultName=1<<1,
      ResetToDefault=1<<2
} ConfigMaskType;      

#define MAX_LINE_LEN 1024
      

#endif /* RTC_DEFINES_H */
