/*
 * t_harness.c --
 * Chris Hyde
 * created: 
 *
 * Modified: Dean Collins Wed Feb 23 17:00:42 1994
 * Changed PTSROOT (a constant) to PtsRoot (a variable).
 */

/*
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the University of Idaho
 * not be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  The University
 * of Idaho makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE UNIVERSITY OF IDAHO BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <pwd.h>
#include "zdbm.h"

void print_reop(reopened_record *);

main(int argc, char* argv[])
{
 char param1[81], param2[81], param3[81], param4[81], param5[81], param6[81];
 char long_string[1024], *cp;
 int  error_code, temp_int, temp3, temp4, i;
 reporter_record rep_rec;
 index_record index;
 problem_record pro_rec, *pro_point;
 edit_record *edit_pointer;
 reopened_record *reop;
 FILE *temp=NULL, *temp2;
 int testflag=0 ; 

 if (argc!=0) testflag=atoi(argv[1]) ;
 printf ("testflag=%d\n",testflag) ;


/* To test a single function, give the appropriate value for "testflag"
 * as an argument.  Giving no argument will do all tests.
 */
if (testflag==1)
{
/******************************************
 *
 * Code to test deny_reopen()
 */
 fprintf(stderr, "Testing deny_reopen()\n");

 fprintf(stderr, "PRID: ");
 gets(param1);

 if (deny_reopen(param1)==FAIL)
 {
    printf("Could Not Deny, Error number %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The deny suceeded.\n");
}
if (testflag==2)
{
/******************************************
 *
 * Code to test confirm_reopen()
 */

 fprintf(stderr, "PRID: ");
 gets(param1);
 fprintf(stderr, "SYSOP: ");
 gets(param2);
 
 strcpy(long_string, "The reasons for reopening this problem are: I'm a SYSOP\nand I want to!");
 sprintf(param3, "%s%s/%s.rep", PtsRoot, REOPENDIR, param1);
 if ((temp=fopen(param3, "r"))==NULL)
 {
    printf("Could not open %s\n", param3);
    perror(NULL);
    exit(errno);
 }
 fread(&rep_rec, sizeof(reporter_record), 1, temp);

 if ((cp=confirm_reopen(param1, &rep_rec, param2, long_string))==NULL)
 {
    printf("Could Not Confirm, Error number %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("Confirmed Problem, new PRID = %s\n", cp);

}
if (testflag==3)
{
/******************************************
 *
 * Code to test delete_record().
 */

 fprintf(stderr, "PRID: ");
 gets(param1);

 if (delete_record(param1)==FAIL)
 {
    printf("Could Not delete %s.\nErro number %d\n", param1, 
		db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The problem has been removed.\n");

}
if (testflag==4)
{
/******************************************
 *
 * Code to test view_reopen().
 */

 while (TRUE)
 {
    fprintf(stderr, "PRID? ");
    gets(param1);
    if (param1[0]=='\0')
       cp=NULL;
    else
       cp=param1;
    fprintf(stderr, "Full problem record (1) or Partial (0)? ");
    gets(param2);
    temp_int=atoi(param2);

    fprintf(stderr, "WARNING!!!!! This will run FOEVER!!!!\n");
    if ((reop=view_reopen(cp, temp_int))==NULL)
    {
       printf("Could Not Create Reopened Record.\nError Number %d.\n",
   			db_errorno);
       perror(NULL);
       exit(db_errorno);
    }
    else
       print_reop(reop);
 }
 
}
if (testflag==5)
{
/******************************************
 *
 * Code to test reopen_request().
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 fprintf(stderr, "Prid: ");
 gets(param2);
 fprintf(stderr, "Reporter: ");
 gets(rep_rec.account_name);
 fprintf(stderr, "Node: ");
 gets(rep_rec.node_name);
 fprintf(stderr, "Time: ");
 gets(rep_rec.date_time);
 cp="The reason I want to reopen this problem, is because I want to and I'm a SYSOP dammit!!!!";

 if (reopen_request(param1, param2, cp, &rep_rec)==FAIL)
 {
    printf("Could Not Reopen Problem.\nError Number %d.\n",
		 db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("Reopend Problem.\n");

}
if (testflag==6)
{
/******************************************
 *
 * Code to test get_problem().
 */

 param1[0]='y';

 while (param1[0]=='y' || param1[0]=='Y')
 {
    fprintf(stderr, "DB Path: ");
    gets(param1);
    fprintf(stderr, "PRID: ");
    gets(param2);
    fprintf(stderr, "Type of problem (unsolved = 143, solved 135, particular=144)? ");
    gets(param3);
    temp_int=atoi(param3);
    fprintf(stderr, "Follow links (Yes = 1, No = 0)?");
    gets(param4);
    temp3=atoi(param4);
    fprintf(stderr, "Full problem record (1) or Partial (0)? ");
    gets(param4);
    temp4=atoi(param4);

    if ((pro_point=get_problem(param1, param2, temp_int, NULL, temp3, temp4))
				==NULL)
    {
       printf("Could Not Create Problem Record.\n");
       printf("Error No. - %d.\n", db_errorno);
       perror(NULL);
       exit(db_errorno);
    }
    else
       print_prob(pro_point);
    fprintf(stderr, "Seacrh Again? ");
    gets(param1);
 }

}
if (testflag==7)
{
/******************************************
 *
 * Code to test create_record().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);

 if ((temp=open_file(param1, ".index", "r+", INDEX))==NULL)
 {
    printf("Could Not Open - %s.\n", param1);
    perror(NULL);
    exit(errno);
 }

 if (find_problem(temp, param2, &index)==NULL)
 {
    printf("Could Not Find - %s/%s.\n", param1, param2);
    printf("Error No. - %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }

 fclose(temp); 
 if (create_record(param1, &index, &pro_rec)==NULL)
 {
    printf("Could Not Create Problem Record.\n");
    printf("Error No. - %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    print_prob(&pro_rec);

}
if (testflag==8)
{
/******************************************
 *
 * Code to test next_unsolved().
 */

 while (TRUE)
 {
    fprintf(stderr, "New database (yes = 1, no = 0)? ");
    gets(param2);
    temp_int=atoi(param2);
    if (temp_int)
    {
       fclose(temp);
       fprintf(stderr, "Index of problem: ");
       gets(param1);
       fprintf(stderr, "Follow links (yes = 1, no = 0)?");
       gets(param2);
       temp3=atoi(param2);
       if ((temp=open_file(param1, ".index", "r+", INDEX))==NULL)
       {
          printf("Could Not open %s.\n", param1);
          perror(NULL);
          exit(1);
       }
       printf("\n\nNew leaf = %s.\n\n", param1);
    }
 
    if (next_unsolved(temp, temp_int, temp3, &index)==NULL)
    {
       printf("Function returned error %d.\n", db_errorno);
       if ((db_errorno!=ROLLEDOVER) && (db_errorno!=NOTFOUND))
       {
          perror(NULL);
          exit(db_errorno);
       }
    }
    else
       printf("Found an unsolved problem.\n");
    
    fprintf(stderr, "Search Again (Y/N)? ");
    gets(param3);
    if ((param3[0]=='N') || (param3[0]=='n'))
       break;
 }

}
if (testflag==9)
{
/******************************************
 *
 * Code to test next_solved().
 */

 while (TRUE)
 {
    fprintf(stderr, "New database (yes = 1, no = 0)? ");
    gets(param2);
    temp_int=atoi(param2);
    if (temp_int)
    {
       fclose(temp);
       fprintf(stderr, "Index of problem: ");
       gets(param1);
       fprintf(stderr, "Follow links (Yes = 1, no = 0)?");
       gets(param2);
       temp3=atoi(param2);
       if ((temp=open_file(param1, ".index", "r+", INDEX))==NULL)
       {
          printf("Could Not open %s.\n", param1);
          perror(NULL);
          exit(1);
       }
       printf("\n\nNew leaf = %s.\n\n", param1);
    }
 
    if (next_solved(temp, temp_int, temp3, &index)==NULL)
    {
       printf("Function returned error %d.\n", db_errorno);
       if ((db_errorno!=ROLLEDOVER) && (db_errorno!=NOTFOUND))
       {
          perror(NULL);
          exit(db_errorno);
       }
    }
    else
       printf("Found a solved problem.\n");
    
    fprintf(stderr, "Search Again (Y/N)? ");
    gets(param3);
    if ((param3[0]=='N') || (param3[0]=='n'))
       break;
 }

}
if (testflag==10)
{
/******************************************
 *
 * Code to test edit_info().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);

 if ((edit_pointer=edit_info(param1, param3))==NULL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("Account name - %s\nNode name - %s\nPID - %d\n",
		edit_pointer->account_name, edit_pointer->node_name, 
		edit_pointer->pid);

}
if (testflag==11)
{
/******************************************
 *
 * Code to test remove_edit().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);

 if (remove_edit(param1, param3)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("Problem has been marked as NOT being in edit.\n");

}
if (testflag==12)
{
/******************************************
 *
 * Code to test edit_log().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);
 fprintf(stderr, "Mode of edit (START = 145, END = 146): ");
 gets(param2);
 temp_int=atoi(param2);
 if (temp_int==146)
 {
    fprintf(stderr, "New Problem Log (^D to quit):\n");
    for (i=0; i<1023; i++)
      if ((long_string[i]=getchar())==EOF)
         break;
    long_string[i]='\0';
 }

 if (edit_log(param1, param3, long_string, temp_int)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("edit_log() returned sucessfully.\n");

}
if (testflag==13)
{
/******************************************
 *
 * Code to test unlock_from_edit().
 */

 fprintf(stderr, "Index of problem: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);
 strcpy(long_string, "This is some text to add to the problem log.");

 if ((temp=fopen(param1, "r+"))==NULL)
 {
    printf("Could Not open %s.\n", param1);
    perror(NULL);
    exit(1);
 }
 if (find_problem(temp, param3, &index)==NULL)
 {
    printf("Could Not Find %s - %s.\n", param1, param3);
    printf("Returned error number - %d\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 
 if (unlock_from_edit(temp, &index, param3, long_string)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The edit block has been removed.\n");

}
if (testflag==14)
{
/******************************************
 *
 * Code to test lock_for_edit().
 */

 fprintf(stderr, "Index of problem: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);

 if ((temp=fopen(param1, "r+"))==NULL)
 {
    printf("Could Not open %s.\n", param1);
    perror(NULL);
    exit(1);
 }
 if (find_problem(temp, param3, &index)==NULL)
 {
    printf("Could Not Find %s - %s.\n", param1, param3);
    printf("Returned error number - %d\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 
 if (lock_for_edit(temp, &index)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The Problem Has Been marked for editing.\n");

}
if (testflag==15)
{
/******************************************
 *
 * Code to test solve_problem().
 */

 param3[0]='y';
 while (param3[0]=='y' || param3[0]=='Y')
 {
    fprintf(stderr, "Path: ");
    gets(param1);
    fprintf(stderr, "PRID: ");
    gets(param2);

    if (solve_problem(param1, param2)==FAIL)
    {
       printf("solve_problem() returned error number - %d\n", db_errorno);
       perror(NULL);
       exit(db_errorno);
    }
    else
       printf("The problem has been solved (It's magic!)\n");
   
   fprintf(stderr, "Solve Another? ");
   gets(param3);
 } /* end while */
 } /* end test for solve_problem() */

if (testflag==16)
{
/******************************************
 *
 * Code to test rename_file().
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 fprintf(stderr, "From filename (no extension): ");
 gets(param2);
 fprintf(stderr, "From filename extension: ");
 gets(param3);
 fprintf(stderr, "To filename (no extension): ");
 gets(param4);
 fprintf(stderr, "To filname extension: ");
 gets(param5);

 if (rename_file(param1, param2, param3, param1, param4, param5)==FAIL) 
 {
    printf("rename_file() returned error number - %d\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The rename suceeded.\n");
 
}
if (testflag==17)
{
/******************************************
 *
 * Code to test append().
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 fprintf(stderr, "From filename (no extension): ");
 gets(param2);
 fprintf(stderr, "From filename extension: ");
 gets(param3);
 fprintf(stderr, "To filename (no extension): ");
 gets(param4);
 fprintf(stderr, "To filname extension: ");
 gets(param5);

 if (append(param1, param2, param3, param4, param5)==FAIL) 
 {
    printf("append() returned error number - %d\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The append suceeded.\n");
 
}
if (testflag==18)
{
/******************************************
 *
 * Code to test check_index().
 */

 fprintf(stderr, "Index of problem: ");
 gets(param1);
 fprintf(stderr, "PRID to check: ");
 gets(param3);

 if ((temp=fopen(param1, "r+"))==NULL)
 {
    printf("Could Not open %s.\n", param1);
    perror(NULL);
    exit(1);
 }
 if (find_problem(temp, param3, &index)==NULL)
 {
    printf("Could Not Find %s - %s.\n", param1, param3);
    printf("Returned error number - %d\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 
 if (check_index(temp, &index)==NULL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The Problem Has Been Checked.\n");

}
if (testflag==19)
{
/******************************************
 *
 * Code to test link_problem().
 */

 fprintf(stderr, "From DB Path: ");
 gets(param1);
 fprintf(stderr, "To DB Path: ");
 gets(param2);
 fprintf(stderr, "PRID to link: ");
 gets(param3);
 
 if (link_problem(param1, param2, param3)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The Problem Has Been Linked.\n");

}
if (testflag==20)
{
/******************************************
 *
 * Code to test move_problem().
 */

 fprintf(stderr, "From DB Path: ");
 gets(param1);
 fprintf(stderr, "To DB Path: ");
 gets(param2);
 fprintf(stderr, "PRID to move: ");
 gets(param3);
 
 if (move_problem(param1, param2, param3)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The Problem Has Been Moved.\n");

}
if (testflag==21)
{
/******************************************
 *
 * Code to test move_record().
 */

 fprintf(stderr, "From DB Path: ");
 gets(param1);
 fprintf(stderr, "To DB Path: ");
 gets(param2);
 fprintf(stderr, "PRID to move: ");
 gets(index.prid);
 fprintf(stderr, "Account Name: ");
 gets(index.account_name);
 fprintf(stderr, "Node Name: ");
 gets(index.node_name);
 fprintf(stderr, "Short Description: ");
 gets(index.sd);
 index.mrd=0;
 index.sf=UNSOLVED;
 index.ef=FALSE;
 index.pid=0;
 index.ln_prid[0]='\0';
 index.fr[0]='\0';
 
 if ((cp=move_record(param1, param2, &index))==NULL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The Record Has Been Moved.\nThe new PRID is %s.\n", cp);

}
if (testflag==22)
{
/******************************************
 * 
 * Code to test copy_file().
 */

 fprintf(stderr, "From DB Path: ");
 gets(param1);
 fprintf(stderr, "From File Name: ");
 gets(param2);
 fprintf(stderr, "From File Extension: ");
 gets(param3);
 fprintf(stderr, "To DB Path: ");
 gets(param4);
 fprintf(stderr, "To File Name: ");
 gets(param5);
 fprintf(stderr, "To File Extension: ");
 gets(param6);

 if (copy_file(param1, param2, param3, param4, param5, param6)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The File Has Been Copied.\n");

}
if (testflag==23)
{
/******************************************
 *
 * Code to test exists()
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "File Name: ");
 gets(param2);
 fprintf(stderr, "File Extension: ");
 gets(param3);

 if (exists(PtsRoot, param1, param2, param3)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("The File Exists.\n");

}
if (testflag==24)
{
/******************************************
 *
 * Code to test delete_problem()
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);
 fprintf(stderr, "Permission (147 = DELETEOK, 148 = DELETENOTOK): ");
 gets(param3);
 temp_int=atoi(param3);

 if (delete_problem(param1, param2, temp_int)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("Problem has been deleted.\n");
 
}
if (testflag==25)
{
/***************************************************
 *
 * Code to test remove_file().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "File Name: ");
 gets(param2);
 fprintf(stderr, "File Extension: ");
 gets(param3);

 if (remove_file(param1, param2, param3)==FAIL)
 {
    printf("Function returned error %d.\n", db_errorno);
    perror(NULL);
    exit(db_errorno);
 }
 else
    printf("File has been deleted.\n");

}

if (testflag==39)
{
/***************************************************
 * 
 * Code to test add_reporter().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);
 fprintf(stderr, "Account name: ");
 gets(rep_rec.account_name);
 fprintf(stderr, "Node name: ");
 gets(rep_rec.node_name);
 fprintf(stderr, "Date/time: ");
 gets(rep_rec.date_time);

 if (add_reporter(param1, param2, &rep_rec)==NULL)
 {
    printf("add_reporter reported error %d\n", db_errorno);
    perror(NULL);
 }
 else
    printf("Reporter was added.\n");

}

if (testflag==26)
{
/***************************************************
 *
 * Code to test append_reporter().
 */

 fprintf(stderr, "DB Path: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);
 fprintf(stderr, "Account name: ");
 gets(rep_rec.account_name);
 fprintf(stderr, "Node name: ");
 gets(rep_rec.node_name);
 fprintf(stderr, "Date/time: ");
 gets(rep_rec.date_time);

 if (append_reporter(param1, param2, &rep_rec)==FAIL)
 {
    printf("append_reporter reported error %d\n", db_errorno);
    perror(NULL);
 }
 else
    printf("Reporter was appended.\n");

}
if (testflag==27)
{
/*********************************************************
 *
 * Code to test double_reporter().
 */

 fprintf(stderr, "Pathlist: ");
 gets(param1);
 fprintf(stderr, "Account Name: ");
 gets(rep_rec.account_name);
 fprintf(stderr, "Node Name: ");
 gets(rep_rec.node_name);
 fprintf(stderr, "Date and time: ");
 gets(rep_rec.date_time);

 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could Not Open %s.\n", param1);
    perror(NULL);
    exit(errno);
 }
 if (double_reporter(temp, &rep_rec))
 {
    printf("Double reporter was found.\n");
    printf("db_errorno = %d\n", db_errorno);
 }
 else
    printf("No Doubles were found.\n");

}
if (testflag==28)
{
/*********************************************************
 *
 * Code to test find_problem()
 */

 fprintf(stderr, "Pathlist: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);
 
 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could Not Open %s.\n", param1);
    perror(NULL);
    exit(errno);
 }

 if (find_problem(temp, param2, &index)==NULL)
 {
    printf("Function returned error code %d\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
 {
    printf("PRID - %s\nMRD - %d\nSF - %d\nEF - %d\n", index.prid,
		index.mrd, index.sf, index.ef); 
    printf("Account Name - %s\nNode Name - %s\nPID - %d\n", 
		index.account_name, index.node_name, index.pid);
    printf("Ln Prid - %s\nLN PATH - %s\nSD - %s\n", index.ln_prid, 
		index.ln_path, index.sd);
 }

}
if (testflag==29)
{
/**********************************************************
 *
 * Code to test search_index().
 */

 fprintf(stderr, "Pathlist: ");
 gets(param1);
 fprintf(stderr, "PRID: ");
 gets(param2);
 
 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could Not Open %s.\n", param1);
    perror(NULL);
    exit(errno);
 }

 if (search_index(temp, param2, &index, 0L)==NULL)
 {
    printf("Function returned error code %d\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
 {
    printf("PRID - %s\nMRD - %d\nSF - %d\nEF - %d\n", index.prid, 
		index.mrd, index.sf, index.ef); 
    printf("Account Name - %s\nNode Name - %s\nPID - %d\n", 
		index.account_name, index.node_name, index.pid);
    printf("Ln Prid - %s\nLN PATH - %s\nSD - %s\n", index.ln_prid, 
		index.ln_path, index.sd);
 }

}
if (testflag==30)
{
/**********************************************************
 *
 * Code to test the add_problem() function.
 */

 sprintf(long_string, "This is a long string\\n\nWith interspersed newlines\\n\nUsed to test the add_problem() function\\n\n");
 
 fprintf(stderr, "Short Description: ");
 gets(param1);
 fprintf(stderr, "Db_path: ");
 gets(param2);

 fprintf(stderr, "Account Name: ");
 gets(rep_rec.account_name);
 fprintf(stderr, "Node Name: ");
 gets(rep_rec.node_name);
 fprintf(stderr, "Time: ");
 gets(rep_rec.date_time);

 cp=add_problem(&rep_rec, long_string, param1, param2);
 if (cp==NULL)
 {
    printf("DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("CP = %s\n", cp);


}
if (testflag==31)
{
/******************************************
 *
 * Code for testing remove_file().
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 fprintf(stderr, "Fname: ");
 gets(param2);
 fprintf(stderr, "Extension: ");
 gets(param3);
 
 error_code=remove_file(param1, param2, param3);
 if (error_code==FAIL)
 {
    printf("remove_file() - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Removed File Sucessfully\n");

}
if (testflag==32)
{
/******************************************
 *
 * Code for testing create_file().
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 fprintf(stderr, "Fname: ");
 gets(param2);
 fprintf(stderr, "Extension: ");
 gets(param3);

 temp=create_file(param1, param2, param3, FILE_PERMS);
 if (temp==NULL)
 {
    printf("create_file() - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Created File Sucessfully\n");

}
if (testflag==33)
{
/******************************************
 *
 * Code for testing new_prid().
 */

 if ((cp=new_prid(100L))==NULL)
 {
    printf("DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("CP = %s\n", cp);
    
}
if (testflag==34)
{
/*******************************************
 *
 * Code for testing file_size().
 */

 fprintf(stderr, "File name: ");
 gets(param1);

 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could not open %s\n");
    perror(NULL);
    exit(errno);
 }
 printf("Using record size of %d bytes.\n", sizeof(int));
 printf("The size of the file is: %d\n", file_size(temp, sizeof(int)));

}
if (testflag==35)
{
/*******************************************
 *
 * Code for testing open_file()
 */

 fprintf(stderr, "Leaf: ");
 gets(param1);
 fprintf(stderr, "Extension: ");
 gets(param2);
 fprintf(stderr, "Perm: ");
 gets(param3);
 fprintf(stderr, "Index Flag: ");
 gets(param4);
 temp_int=atoi(param4);
 temp=open_file(param1, param2, param3, temp_int);
 if (temp==NULL)
 {
    printf("Open_file() - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Opened File Sucessfully\n");


}
if (testflag==36)
{
/*****************************************
 *
 * Code for checking lock_file()
 */

 fprintf(stderr, "File to lock: ");
 gets(param1);

 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could not open %s error number = %d.\n", param1, db_errorno);
    perror(NULL);
    exit(db_errorno);
 }

 error_code=lock_file(temp);
 if (error_code==FAIL)
 {
    printf("lock_file() 1st call - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Locked File Sucessfully\n");

 temp=fopen(param1, "r");
 if (temp2==NULL)
 {
    printf("Open_file() 2nd open - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Opened File Sucessfully\n");

}
if (testflag==37)
{
/**************************************
 *
 * Code for checking unlock_file().
 * 
 */

 fprintf(stderr, "File to unlock: ");
 gets(param1);

 if ((temp=fopen(param1, "r"))==NULL)
 {
    printf("Could not open %s error number = %d.\n", param1, db_errorno);
    perror(NULL);
    exit(db_errorno);
 }

 error_code=unlock_file(temp);
 if (error_code==FAIL)
 {
    printf("unlock_file() - DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("Unlocked File Sucessfully\n");

}
if (testflag==38)
{
/**********************************************************************
 * 
 * Code for the testing of make_branch()
 */

 fprintf(stderr, "Path: ");
 gets(param1);
 
 error_code=make_branch(param1);
 if (error_code!=SUCESS)
 {
    printf("Error Code Returned = %d\n", error_code);
    printf("DB_ERRORNO = %d is:\n", db_errorno);
    perror(NULL);
    exit(errno);
 }
 else
    printf("SUCESS\n");

}

if (testflag==40)
{
/**********************************************************************
 *
 * code to test zdbm_strerror().
 *
 */

 for (error_code=255; error_code < END_ZDBM_ERROR_CODES +2; error_code++)
    printf("\n%s\n", zdbm_strerror(error_code));

} /* end zdbm_strerror() */

} /* end of main */


void print_reop(reopened_record *reop)
{
 printf("\nReopened Record:\n\n");
 printf("Reopen PRID - %s\n", reop->prid);
 printf("Name of reasons log - %s\n", reop->reasons_log);
 printf("Requestor Info:\n");
 printf("\tReporter - %s\tNode - %s\tDate - %s\n", 
		reop->rep_rec.account_name, reop->rep_rec.node_name,
		reop->rep_rec.date_time);
 printf("\nThe Problem to be reopened.\n\n");
 print_prob(reop->pro_rec);
}
