/*
 * readreop.c -- 
 * Chris Hyde
 * created: 
 */

/*
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the University of Idaho
 * not be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  The University
 * of Idaho makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE UNIVERSITY OF IDAHO BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <pwd.h>
#include "zdbm.h"

main(int argc, char **argv)
{
 index_record index;
 FILE *index_file;
 int count=1;
 long temp;

 if ((index_file=open_file(REOPENDIR, ".index", "r", INDEX))==NULL)
 {
    fprintf(stderr, "Could Not Open %s.\n", argv[1]);
    exit(errno);
 }
 fread(&temp, sizeof(long), 1, index_file);
 printf("Index records from the Reopened index file.\n\n");
 while (fread(&index, sizeof(index_record), 1, index_file)!=NULL)
 {
    printf("Index record %d:\n", count++);
    printf("\tPrid - %s\n\tMRD - %03d\tSF - %03d\tEF - %03d\n", index.prid, 
		index.mrd, index.sf, index.ef);
    printf("\tAccount_name - %s\n", index.account_name);
    printf("\tNode_name - %s\n", index.node_name);
    printf("\tPid - %d\n", index.pid);
    printf("\tLn_prid - %s\n\tSD - %s\n\tFR - %s\n\n", index.ln_prid, index.sd,
		index.fr);
 }
}
 
